/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.browser;

import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.browser.IQualifiedTypeName;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.ITypeSearchScope;
import org.eclipse.cdt.core.browser.IndexTypeInfo;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.browser.util.IndexModelUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class AllTypesCache {
    private static final boolean DEBUG = false;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ITypeInfo[] getTypes(ICProject[] projects, final int[] kinds, IProgressMonitor monitor) throws CoreException {
        IIndex index = CCorePlugin.getIndexManager().getIndex(projects);
        try {
            try {
                index.acquireReadLock();
                System.currentTimeMillis();
                IIndexBinding[] all = index.findBindings(Pattern.compile(".*"), false, new IndexFilter(){

                    public boolean acceptBinding(IBinding binding) {
                        return IndexModelUtil.bindingHasCElementType(binding, kinds);
                    }
                }, monitor);
                ITypeInfo[] result = new ITypeInfo[all.length];
                int i = 0;
                while (true) {
                    if (i >= all.length) {
                        ITypeInfo[] iTypeInfoArray = result;
                        Object var8_10 = null;
                        index.releaseReadLock();
                        return iTypeInfoArray;
                    }
                    IIndexBinding ib = all[i];
                    result[i] = new IndexTypeInfo(ib.getQualifiedName(), IndexModelUtil.getElementType(ib), index);
                    ++i;
                }
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            index.releaseReadLock();
            throw throwable;
        }
        {
            Object var8_12 = null;
            index.releaseReadLock();
            return new ITypeInfo[0];
        }
    }

    public static ITypeInfo[] getAllTypes() {
        return AllTypesCache.getAllTypes((IProgressMonitor)new NullProgressMonitor());
    }

    public static ITypeInfo[] getAllTypes(IProgressMonitor monitor) {
        try {
            ICProject[] projects = CoreModel.getDefault().getCModel().getCProjects();
            return AllTypesCache.getTypes(projects, ITypeInfo.KNOWN_TYPES, monitor);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new ITypeInfo[0];
        }
    }

    public static ITypeInfo[] getTypes(ITypeSearchScope scope, int[] kinds) {
        try {
            return AllTypesCache.getTypes(scope.getEnclosingProjects(), kinds, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new ITypeInfo[0];
        }
    }

    public static ITypeInfo[] getNamespaces(ITypeSearchScope scope, boolean includeGlobalNamespace) {
        try {
            return AllTypesCache.getTypes(scope.getEnclosingProjects(), new int[]{61}, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new ITypeInfo[0];
        }
    }

    public static ITypeInfo getType(ICProject project, int type, IQualifiedTypeName qualifiedName) {
        return null;
    }

    public static ITypeInfo[] getTypes(ICProject project, IQualifiedTypeName qualifiedName, boolean matchEnclosed, boolean ignoreCase) {
        return new ITypeInfo[0];
    }
}

