/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlStorageElement
implements ICStorageElement {
    Element fElement;
    private ICStorageElement fParent;
    private List fChildList = new ArrayList();
    private boolean fChildrenCreated;
    private String[] fAttributeFilters;
    private String[] fChildFilters;
    private boolean fParentRefAlowed;
    static /* synthetic */ Class class$0;

    public XmlStorageElement(Element element) {
        this(element, null, false);
    }

    public XmlStorageElement(Element element, ICStorageElement parent, boolean alowReferencingParent) {
        this(element, parent, alowReferencingParent, null, null);
    }

    public XmlStorageElement(Element element, ICStorageElement parent, boolean alowReferencingParent, String[] attributeFilters, String[] childFilters) {
        this.fElement = element;
        this.fParent = parent;
        this.fParentRefAlowed = alowReferencingParent;
        if (attributeFilters != null && attributeFilters.length != 0) {
            this.fAttributeFilters = (String[])attributeFilters.clone();
        }
        if (childFilters != null && childFilters.length != 0) {
            this.fChildFilters = (String[])childFilters.clone();
        }
    }

    private void createChildren() {
        if (this.fChildrenCreated) {
            return;
        }
        this.fChildrenCreated = true;
        NodeList list = this.fElement.getChildNodes();
        int size = list.getLength();
        int i = 0;
        while (i < size) {
            Node node = list.item(i);
            if (node.getNodeType() == 1 && this.isChildAlowed(node.getNodeName())) {
                this.createAddChild((Element)node, true, null, null);
            }
            ++i;
        }
    }

    private XmlStorageElement createAddChild(Element element, boolean alowReferencingParent, String[] attributeFilters, String[] childFilters) {
        XmlStorageElement child = this.createChild(element, alowReferencingParent, attributeFilters, childFilters);
        this.fChildList.add(child);
        return child;
    }

    protected XmlStorageElement createChild(Element element, boolean alowReferencingParent, String[] attributeFilters, String[] childFilters) {
        return new XmlStorageElement(element, this, alowReferencingParent, attributeFilters, childFilters);
    }

    public ICStorageElement[] getChildren() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.settings.model.util.XmlStorageElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return this.getChildren(clazz);
    }

    protected ICStorageElement[] getChildren(Class clazz) {
        return this.getChildren(clazz, true);
    }

    protected ICStorageElement[] getChildren(boolean load) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.settings.model.util.XmlStorageElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return this.getChildren(clazz, load);
    }

    protected ICStorageElement[] getChildren(Class clazz, boolean load) {
        if (load) {
            this.createChildren();
        }
        ICStorageElement[] children = (ICStorageElement[])Array.newInstance(clazz, this.fChildList.size());
        return this.fChildList.toArray(children);
    }

    public ICStorageElement getParent() {
        return this.fParentRefAlowed ? this.fParent : null;
    }

    public String getAttribute(String name) {
        if (this.isPropertyAlowed(name) && this.fElement.hasAttribute(name)) {
            return this.fElement.getAttribute(name);
        }
        return null;
    }

    private boolean isPropertyAlowed(String name) {
        if (this.fAttributeFilters != null) {
            return this.checkString(name, this.fAttributeFilters);
        }
        return true;
    }

    private boolean isChildAlowed(String name) {
        if (this.fChildFilters != null) {
            return this.checkString(name, this.fChildFilters);
        }
        return true;
    }

    private boolean checkString(String name, String[] array) {
        if (array.length > 0) {
            int i = 0;
            while (i < array.length) {
                if (name.equals(array[i])) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    protected void removed() {
        this.fElement = null;
    }

    public void removeChild(ICStorageElement el) {
        if (el instanceof XmlStorageElement) {
            ICStorageElement[] children = this.getChildren();
            int i = 0;
            while (i < children.length) {
                if (children[i] == el) {
                    XmlStorageElement xmlEl = (XmlStorageElement)el;
                    this.fElement.removeChild(xmlEl.fElement);
                    this.fChildList.remove(el);
                    xmlEl.removed();
                }
                ++i;
            }
        }
    }

    public void removeAttribute(String name) {
        if (this.isPropertyAlowed(name)) {
            this.fElement.removeAttribute(name);
        }
    }

    public void setAttribute(String name, String value) {
        if (this.isPropertyAlowed(name)) {
            this.fElement.setAttribute(name, value);
        }
    }

    public void clear() {
        this.createChildren();
        ICStorageElement[] children = this.fChildList.toArray(new ICStorageElement[this.fChildList.size()]);
        int i = 0;
        while (i < children.length) {
            this.removeChild(children[i]);
            ++i;
        }
        NamedNodeMap map = this.fElement.getAttributes();
        int i2 = 0;
        while (i2 < map.getLength()) {
            Node attr = map.item(i2);
            if (this.isPropertyAlowed(attr.getNodeName())) {
                map.removeNamedItem(attr.getNodeName());
            }
            ++i2;
        }
        NodeList list = this.fElement.getChildNodes();
        int i3 = 0;
        while (i3 < list.getLength()) {
            Node node = list.item(i3);
            if (node.getNodeType() == 3) {
                this.fElement.removeChild(node);
            }
            ++i3;
        }
    }

    public ICStorageElement createChild(String name, boolean alowReferencingParent, String[] attributeFilters, String[] childFilters) {
        if (!this.isChildAlowed(name)) {
            return null;
        }
        Element childElement = this.fElement.getOwnerDocument().createElement(name);
        this.fElement.appendChild(childElement);
        return this.createAddChild(childElement, alowReferencingParent, attributeFilters, childFilters);
    }

    public String getName() {
        return this.fElement.getNodeName();
    }

    public ICStorageElement createChild(String name) {
        return this.createChild(name, true, null, null);
    }

    public String getValue() {
        Text text = this.getTextChild();
        if (text != null) {
            return text.getData();
        }
        return null;
    }

    public void setValue(String value) {
        Text text = this.getTextChild();
        if (value != null) {
            if (text == null) {
                text = this.fElement.getOwnerDocument().createTextNode(value);
                this.fElement.appendChild(text);
            } else {
                text.setData(value);
            }
        } else if (text != null) {
            this.fElement.removeChild(text);
        }
    }

    private Text getTextChild() {
        NodeList nodes = this.fElement.getChildNodes();
        Text text = null;
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 3) {
                text = (Text)node;
                break;
            }
            ++i;
        }
        return text;
    }

    public ICStorageElement importChild(ICStorageElement el) throws UnsupportedOperationException {
        return this.addChild(el, true, null, null);
    }

    public ICStorageElement addChild(ICStorageElement el, boolean alowReferencingParent, String[] attributeFilters, String[] childFilters) throws UnsupportedOperationException {
        if (!this.isChildAlowed(el.getName())) {
            return null;
        }
        if (el instanceof XmlStorageElement) {
            Document otherDoc;
            XmlStorageElement xmlStEl = (XmlStorageElement)el;
            Element xmlEl = xmlStEl.fElement;
            Document thisDoc = this.fElement.getOwnerDocument();
            xmlEl = !thisDoc.equals(otherDoc = xmlEl.getOwnerDocument()) ? (Element)thisDoc.importNode(xmlEl, true) : (Element)xmlEl.cloneNode(true);
            xmlEl = (Element)this.fElement.appendChild(xmlEl);
            return this.createAddChild(xmlEl, alowReferencingParent, attributeFilters, childFilters);
        }
        throw new UnsupportedOperationException();
    }

    public String[] getAttributeFilters() {
        if (this.fAttributeFilters != null) {
            return (String[])this.fAttributeFilters.clone();
        }
        return new String[0];
    }

    public String[] getChildFilters() {
        if (this.fChildFilters != null) {
            return (String[])this.fChildFilters.clone();
        }
        return new String[0];
    }

    public boolean isParentRefAlowed() {
        return this.fParentRefAlowed;
    }

    public boolean matches(ICStorageElement el) {
        ICStorageElement[] otherChildren;
        XmlStorageElement[] children;
        String[] otherAttrs;
        if (!this.getName().equals(el.getName())) {
            return false;
        }
        String value = this.getValue();
        if (value == null ? el.getValue() != null : !value.equals(el.getValue())) {
            return false;
        }
        String[] attrs = this.getAttributeNames();
        if (attrs.length != (otherAttrs = el.getAttributeNames()).length) {
            return false;
        }
        if (attrs.length != 0) {
            HashSet<String> set = new HashSet<String>(Arrays.asList(attrs));
            set.removeAll(Arrays.asList(otherAttrs));
            if (set.size() != 0) {
                return false;
            }
            int i = 0;
            while (i < attrs.length) {
                if (!this.getAttribute(attrs[i]).equals(el.getAttribute(attrs[i]))) {
                    return false;
                }
                ++i;
            }
        }
        if ((children = (XmlStorageElement[])this.getChildren()).length != (otherChildren = el.getChildren()).length) {
            return false;
        }
        if (children.length != 0) {
            int i = 0;
            while (i < children.length) {
                if (!children[i].matches(otherChildren[i])) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public String[] getAttributeNames() {
        NamedNodeMap nodeMap = this.fElement.getAttributes();
        int length = nodeMap.getLength();
        ArrayList<String> list = new ArrayList<String>(length);
        int i = 0;
        while (i < length) {
            Node node = nodeMap.item(i);
            String name = node.getNodeName();
            if (this.isPropertyAlowed(name)) {
                list.add(name);
            }
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }
}

