/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICExtension;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.core.ICOwnerInfo;
import org.eclipse.cdt.core.settings.model.ICConfigExtensionReference;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.core.settings.model.util.CExtensionUtil;
import org.eclipse.cdt.internal.core.COwner;
import org.eclipse.cdt.internal.core.InternalCExtension;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationSpecSettings;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionManager;
import org.eclipse.cdt.internal.core.settings.model.IInternalCCfgInfo;
import org.eclipse.cdt.internal.core.settings.model.InternalXmlStorageElement;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.w3c.dom.Element;

public class CConfigBasedDescriptor
implements ICDescriptor {
    private static final String CEXTENSION_NAME = "cextension";
    private ICConfigurationDescription fCfgDes;
    private IProject fProject;
    private COwner fOwner;
    private HashMap fDesMap = new HashMap();
    private HashMap fStorageDataElMap = new HashMap();
    private boolean fApplyOnChange = true;
    private boolean fIsDirty;

    public CConfigBasedDescriptor(ICConfigurationDescription des) throws CoreException {
        this.updateConfiguration(des);
    }

    public void setApplyOnChange(boolean apply) {
        if (this.fApplyOnChange == apply) {
            return;
        }
        this.fApplyOnChange = apply;
    }

    public boolean isApplyOnChange() {
        return this.fApplyOnChange;
    }

    public void apply(boolean force) throws CoreException {
        if (force || this.fIsDirty) {
            ICProjectDescription des = this.fCfgDes.getProjectDescription();
            if (des.isCdtProjectCreating()) {
                des.setCdtProjectCreated();
            }
            CProjectDescriptionManager.getInstance().setProjectDescription(this.fProject, des);
            this.fIsDirty = false;
        }
    }

    private void checkApply() throws CoreException {
        if (this.fApplyOnChange) {
            this.apply(false);
            this.fIsDirty = false;
        } else {
            this.fIsDirty = true;
        }
    }

    public ICExtensionReference create(String extensionPoint, String id) throws CoreException {
        ICConfigExtensionReference ref = this.fCfgDes.create(extensionPoint, id);
        ICProjectDescription des = this.fCfgDes.getProjectDescription();
        ICConfigurationDescription[] cfgs = des.getConfigurations();
        int i = 0;
        while (i < cfgs.length) {
            ICConfigurationDescription cfg = cfgs[i];
            if (cfg != this.fCfgDes) {
                try {
                    cfg.create(extensionPoint, id);
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
        CConfigBaseDescriptorExtensionReference r = this.create(ref);
        this.fIsDirty = true;
        this.checkApply();
        return r;
    }

    void setDirty(boolean dirty) {
        this.fIsDirty = dirty;
    }

    public void updateConfiguration(ICConfigurationDescription des) throws CoreException {
        this.fCfgDes = des;
        this.fProject = this.fCfgDes.getProjectDescription().getProject();
        CConfigurationSpecSettings settings = ((IInternalCCfgInfo)((Object)this.fCfgDes)).getSpecSettings();
        this.fOwner = settings.getCOwner();
        this.fStorageDataElMap.clear();
    }

    private CConfigBaseDescriptorExtensionReference create(ICConfigExtensionReference ref) {
        CConfigBaseDescriptorExtensionReference dr = new CConfigBaseDescriptorExtensionReference(ref);
        ArrayList<CConfigBaseDescriptorExtensionReference> list = (ArrayList<CConfigBaseDescriptorExtensionReference>)this.fDesMap.get(ref.getExtensionPoint());
        if (list == null) {
            list = new ArrayList<CConfigBaseDescriptorExtensionReference>(1);
            this.fDesMap.put(ref.getExtensionPoint(), list);
        } else {
            list.ensureCapacity(list.size() + 1);
        }
        list.add(dr);
        return dr;
    }

    public ICExtensionReference[] get(String extensionPoint) {
        ICConfigExtensionReference[] cfgRefs = this.fCfgDes.get(extensionPoint);
        if (cfgRefs.length == 0) {
            return new ICExtensionReference[0];
        }
        ICExtensionReference[] extRefs = new ICExtensionReference[cfgRefs.length];
        ArrayList<ICExtensionReference> list = (ArrayList<ICExtensionReference>)this.fDesMap.get(extensionPoint);
        int num = cfgRefs.length - 1;
        int i = cfgRefs.length - 1;
        while (i >= 0) {
            ICConfigExtensionReference ref = cfgRefs[i];
            int k = list != null ? list.size() - 1 : -1;
            while (k >= 0) {
                CConfigBaseDescriptorExtensionReference r = (CConfigBaseDescriptorExtensionReference)list.get(k);
                if (r.fCfgExtRef == ref) {
                    extRefs[num--] = r;
                    list.remove(k);
                    break;
                }
                --k;
            }
            if (k < 0) {
                extRefs[num--] = new CConfigBaseDescriptorExtensionReference(ref);
            }
            --i;
        }
        if (list == null) {
            list = new ArrayList<ICExtensionReference>(cfgRefs.length);
            this.fDesMap.put(extensionPoint, list);
        } else {
            list.clear();
            list.ensureCapacity(cfgRefs.length);
        }
        list.addAll(Arrays.asList(extRefs));
        list.trimToSize();
        return extRefs;
    }

    public ICExtensionReference[] get(String extensionPoint, boolean update) throws CoreException {
        ICExtensionReference[] refs = this.get(extensionPoint);
        if (refs.length == 0 && update) {
            boolean prevApplyOnChange = this.fApplyOnChange;
            this.fApplyOnChange = false;
            this.fOwner.update(this.fProject, this, extensionPoint);
            this.fApplyOnChange = prevApplyOnChange;
            this.checkApply();
            refs = this.get(extensionPoint);
        }
        return this.get(extensionPoint);
    }

    public String getPlatform() {
        return this.fOwner.getPlatform();
    }

    public IProject getProject() {
        return this.fProject;
    }

    public Element getProjectData(String id) throws CoreException {
        Element el = (Element)this.fStorageDataElMap.get(id);
        if (el == null) {
            InternalXmlStorageElement storageEl = (InternalXmlStorageElement)this.fCfgDes.getStorage(id, true);
            el = CProjectDescriptionManager.getInstance().createXmlElementCopy(storageEl);
            this.fStorageDataElMap.put(id, el);
        }
        return el;
    }

    public ICOwnerInfo getProjectOwner() {
        return this.fOwner;
    }

    public void remove(ICExtensionReference extension) throws CoreException {
        ICConfigExtensionReference ref = ((CConfigBaseDescriptorExtensionReference)extension).fCfgExtRef;
        this.fCfgDes.remove(ref);
        ICProjectDescription des = this.fCfgDes.getProjectDescription();
        ICConfigurationDescription[] cfgs = des.getConfigurations();
        int i = 0;
        while (i < cfgs.length) {
            ICConfigurationDescription cfg = cfgs[i];
            if (cfg != this.fCfgDes) {
                try {
                    ICConfigExtensionReference[] rs = cfg.get(ref.getExtensionPoint());
                    int k = 0;
                    while (k < rs.length) {
                        if (ref.getID().equals(rs[i].getID())) {
                            cfg.remove(rs[i]);
                            break;
                        }
                        ++k;
                    }
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
        this.fIsDirty = true;
        this.checkApply();
    }

    public void remove(String extensionPoint) throws CoreException {
        this.fCfgDes.remove(extensionPoint);
        ICProjectDescription des = this.fCfgDes.getProjectDescription();
        ICConfigurationDescription[] cfgs = des.getConfigurations();
        int i = 0;
        while (i < cfgs.length) {
            ICConfigurationDescription cfg = cfgs[i];
            if (cfg != this.fCfgDes) {
                try {
                    cfg.remove(extensionPoint);
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
        this.fIsDirty = true;
        this.checkApply();
    }

    public void saveProjectData() throws CoreException {
        if (CProjectDescriptionManager.getInstance().getDescriptorManager().reconsile(this, this.fCfgDes.getProjectDescription())) {
            this.fIsDirty = true;
        }
        this.checkApply();
    }

    public Map getStorageDataElMap() {
        return (HashMap)this.fStorageDataElMap.clone();
    }

    public ICConfigurationDescription getConfigurationDescription() {
        return this.fCfgDes;
    }

    class CConfigBaseDescriptorExtensionReference
    implements ICExtensionReference {
        private ICConfigExtensionReference fCfgExtRef;

        CConfigBaseDescriptorExtensionReference(ICConfigExtensionReference cfgRef) {
            this.fCfgExtRef = cfgRef;
        }

        public ICExtension createExtension() throws CoreException {
            InternalCExtension cExtension = null;
            IConfigurationElement el = CExtensionUtil.getFirstConfigurationElement(this.fCfgExtRef, CConfigBasedDescriptor.CEXTENSION_NAME, false);
            cExtension = (InternalCExtension)((Object)el.createExecutableExtension("run"));
            cExtension.setExtensionReference(this);
            cExtension.setProject(CConfigBasedDescriptor.this.fProject);
            return (ICExtension)((Object)cExtension);
        }

        public ICDescriptor getCDescriptor() {
            return CConfigBasedDescriptor.this;
        }

        public String getExtension() {
            return this.fCfgExtRef.getExtensionPoint();
        }

        public String getExtensionData(String key) {
            return this.fCfgExtRef.getExtensionData(key);
        }

        public IConfigurationElement[] getExtensionElements() throws CoreException {
            IConfigurationElement el = CExtensionUtil.getFirstConfigurationElement(this.fCfgExtRef, CConfigBasedDescriptor.CEXTENSION_NAME, false);
            if (el != null) {
                return el.getChildren();
            }
            return new IConfigurationElement[0];
        }

        public String getID() {
            return this.fCfgExtRef.getID();
        }

        public void setExtensionData(String key, String value) throws CoreException {
            if (!CDataUtil.objectsEqual(this.fCfgExtRef.getExtensionData(key), value)) {
                CConfigBasedDescriptor.this.fIsDirty = true;
                this.fCfgExtRef.setExtensionData(key, value);
                CConfigBasedDescriptor.this.checkApply();
            }
        }
    }
}

