/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.ASTNodeProperty;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.c.CASTVisitor;
import org.eclipse.cdt.core.dom.ast.c.ICASTTypedefNameSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICScope;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayObjectMap;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.IASTInternalScope;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTName;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class CScope
implements ICScope,
IASTInternalScope {
    public static final int NAMESPACE_TYPE_TAG = 0;
    public static final int NAMESPACE_TYPE_OTHER = 1;
    public static final int NAMESPACE_TYPE_BOTH = 2;
    private IASTNode physicalNode = null;
    private boolean isFullyCached = false;
    private CharArrayObjectMap[] bindings = new CharArrayObjectMap[]{CharArrayObjectMap.EMPTY_MAP, CharArrayObjectMap.EMPTY_MAP};
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public CScope(IASTNode physical) {
        this.physicalNode = physical;
    }

    public IScope getParent() {
        return CVisitor.getContainingScope(this.physicalNode);
    }

    public IBinding[] find(String name) throws DOMException {
        return CVisitor.findBindings(this, name, false);
    }

    public IBinding getBinding(int namespaceType, char[] name) {
        IASTName n = (IASTName)this.bindings[namespaceType].get(name);
        return n != null ? n.resolveBinding() : null;
    }

    public void removeBinding(IBinding binding) {
        int type;
        int n = type = binding instanceof ICompositeType || binding instanceof IEnumeration ? 0 : 1;
        if (this.bindings[type] != CharArrayObjectMap.EMPTY_MAP) {
            this.bindings[type].remove(binding.getNameCharArray(), 0, binding.getNameCharArray().length);
        }
        this.isFullyCached = false;
    }

    public IASTNode getPhysicalNode() {
        return this.physicalNode;
    }

    public void addName(IASTName name) {
        char[] n;
        Object current;
        int type = this.getNamespaceType(name);
        if (this.bindings[type] == CharArrayObjectMap.EMPTY_MAP) {
            this.bindings[type] = new CharArrayObjectMap(1);
        }
        if (!((current = this.bindings[type].get(n = name.toCharArray())) instanceof IASTName) || ((CASTName)current).getOffset() > ((CASTName)name).getOffset()) {
            this.bindings[type].put(n, name);
        }
    }

    private int getNamespaceType(IASTName name) {
        ASTNodeProperty prop = name.getPropertyInParent();
        if (prop == IASTCompositeTypeSpecifier.TYPE_NAME || prop == IASTElaboratedTypeSpecifier.TYPE_NAME || prop == IASTEnumerationSpecifier.ENUMERATION_NAME || prop == CVisitor.STRING_LOOKUP_TAGS_PROPERTY) {
            return 0;
        }
        return 1;
    }

    public IBinding getBinding(IASTName name, boolean resolve) {
        char[] c = name.toCharArray();
        if (c.length == 0) {
            return null;
        }
        int type = this.getNamespaceType(name);
        Object o = this.bindings[type].get(name.toCharArray());
        if (o == null) {
            IIndex index;
            IBinding result = null;
            if (this.physicalNode instanceof IASTTranslationUnit && (index = ((IASTTranslationUnit)this.physicalNode).getIndex()) != null) {
                try {
                    IBinding[] bindings = index.findBindings(name.toCharArray(), this.getIndexFilter(type), (IProgressMonitor)new NullProgressMonitor());
                    result = this.processIndexResults(name, bindings);
                }
                catch (CoreException ce) {
                    CCorePlugin.log(ce);
                }
            }
            return result;
        }
        if (o instanceof IBinding) {
            return (IBinding)o;
        }
        IASTName foundName = (IASTName)o;
        if (!(!resolve && foundName.getBinding() == null || foundName == name || this.isTypeDefinition(name) && !CVisitor.declaredBefore(foundName, name))) {
            return foundName.resolveBinding();
        }
        return null;
    }

    private boolean isTypeDefinition(IASTName name) {
        return name.getPropertyInParent() == ICASTTypedefNameSpecifier.NAME;
    }

    public IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup) {
        Class<?> clazz;
        IIndex index;
        char[] c = name.toCharArray();
        Object[] obj = null;
        int i = 0;
        while (i < this.bindings.length) {
            if (prefixLookup) {
                Object[] keys = this.bindings[i].keyArray();
                int j = 0;
                while (j < keys.length) {
                    char[] key = (char[])keys[j];
                    if (CharArrayUtils.equals(key, 0, c.length, c, true)) {
                        obj = ArrayUtil.append(obj, this.bindings[i].get(key));
                    }
                    ++j;
                }
            } else {
                obj = ArrayUtil.append(obj, this.bindings[i].get(c));
            }
            ++i;
        }
        if (this.physicalNode instanceof IASTTranslationUnit && (index = ((IASTTranslationUnit)this.physicalNode).getIndex()) != null) {
            try {
                Object[] bindings = prefixLookup ? index.findBindingsForPrefix(name.toCharArray(), true, this.getIndexFilter(2), null) : index.findBindings(name.toCharArray(), this.getIndexFilter(2), null);
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("java.lang.Object");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                obj = ArrayUtil.addAll(clazz2, obj, bindings);
            }
            catch (CoreException ce) {
                CCorePlugin.log(ce);
            }
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        obj = ArrayUtil.trim(clazz, obj);
        Object[] result = null;
        int i2 = 0;
        while (i2 < obj.length) {
            if (obj[i2] instanceof IBinding) {
                Class<?> clazz3 = class$2;
                if (clazz3 == null) {
                    try {
                        clazz3 = Class.forName("org.eclipse.cdt.core.dom.ast.IBinding");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                result = (IBinding[])ArrayUtil.append(clazz3, result, obj[i2]);
            }
            if ((resolve || ((IASTName)obj[i2]).getBinding() != null) && obj[i2] != name) {
                Class<?> clazz4 = class$2;
                if (clazz4 == null) {
                    try {
                        clazz4 = Class.forName("org.eclipse.cdt.core.dom.ast.IBinding");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                result = (IBinding[])ArrayUtil.append(clazz4, result, ((IASTName)obj[i2]).resolveBinding());
            }
            ++i2;
        }
        Class<?> clazz5 = class$2;
        if (clazz5 == null) {
            try {
                clazz5 = class$2 = Class.forName("org.eclipse.cdt.core.dom.ast.IBinding");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IBinding[])ArrayUtil.trim(clazz5, result);
    }

    private IBinding processIndexResults(IASTName name, IBinding[] bindings) {
        IASTFunctionDefinition def;
        IASTNode parent2;
        IASTNode parent;
        if (bindings.length != 1) {
            return null;
        }
        IBinding candidate = bindings[0];
        if (candidate instanceof IFunction && (parent = name.getParent()) instanceof IASTFunctionDeclarator && (parent2 = parent.getParent()) instanceof IASTFunctionDefinition && (def = (IASTFunctionDefinition)parent2).getDeclSpecifier().getStorageClass() == 3) {
            try {
                if (!((IFunction)candidate).isStatic()) {
                    return null;
                }
            }
            catch (DOMException de) {
                CCorePlugin.log(de);
            }
        }
        return candidate;
    }

    private IndexFilter getIndexFilter(int type) {
        switch (type) {
            case 0: {
                return new IndexFilter(){

                    public boolean acceptBinding(IBinding binding) {
                        return binding instanceof ICompositeType || binding instanceof IEnumeration;
                    }

                    public boolean acceptLinkage(ILinkage linkage) {
                        return linkage.getID().equals("C");
                    }
                };
            }
            case 1: {
                return new IndexFilter(){

                    public boolean acceptBinding(IBinding binding) {
                        return !(binding instanceof ICompositeType) && !(binding instanceof IEnumeration);
                    }

                    public boolean acceptLinkage(ILinkage linkage) {
                        return linkage.getID().equals("C");
                    }
                };
            }
        }
        return IndexFilter.getFilter("C");
    }

    public void setFullyCached(boolean b) {
        this.isFullyCached = b;
    }

    public boolean isFullyCached() {
        return this.isFullyCached;
    }

    public IName getScopeName() {
        if (this.physicalNode instanceof IASTCompositeTypeSpecifier) {
            return ((IASTCompositeTypeSpecifier)this.physicalNode).getName();
        }
        return null;
    }

    public void flushCache() {
        this.bindings[0].clear();
        this.bindings[1].clear();
        this.isFullyCached = false;
    }

    public void addBinding(IBinding binding) {
        int type = 1;
        if (binding instanceof ICompositeType || binding instanceof IEnumeration) {
            type = 0;
        }
        if (this.bindings[type] == CharArrayObjectMap.EMPTY_MAP) {
            this.bindings[type] = new CharArrayObjectMap(2);
        }
        this.bindings[type].put(binding.getNameCharArray(), binding);
    }

    protected static class CollectNamesAction
    extends CASTVisitor {
        private char[] name;
        private IASTName[] result = null;

        CollectNamesAction(char[] n) {
            this.name = n;
            this.shouldVisitNames = true;
        }

        public int visit(IASTName n) {
            ASTNodeProperty prop = n.getPropertyInParent();
            if ((prop == IASTElaboratedTypeSpecifier.TYPE_NAME || prop == IASTCompositeTypeSpecifier.TYPE_NAME || prop == IASTDeclarator.DECLARATOR_NAME) && CharArrayUtils.equals(n.toCharArray(), this.name)) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.cdt.core.dom.ast.IASTName");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.result = (IASTName[])ArrayUtil.append(clazz, this.result, n);
            }
            return 3;
        }

        public int visit(IASTStatement statement) {
            if (statement instanceof IASTDeclarationStatement) {
                return 3;
            }
            return 1;
        }

        public IASTName[] getNames() {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.core.dom.ast.IASTName");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IASTName[])ArrayUtil.trim(clazz, this.result);
        }
    }
}

