/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index;

import java.util.Collection;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.internal.core.index.CIndex;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFile;
import org.eclipse.cdt.internal.core.index.IWritableIndex;
import org.eclipse.cdt.internal.core.index.IWritableIndexFragment;
import org.eclipse.core.runtime.CoreException;

public class WritableCIndex
extends CIndex
implements IWritableIndex {
    private final IWritableIndexFragment[] fWritableFragments;
    private boolean fIsWriteLocked = false;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.internal.core.index.WritableCIndex");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public WritableCIndex(IWritableIndexFragment[] writable, IIndexFragment[] readonly) {
        super(WritableCIndex.concat(writable, readonly));
        this.fWritableFragments = writable;
    }

    private static IIndexFragment[] concat(IIndexFragment[] writable, IIndexFragment[] readonly) {
        IIndexFragment[] result = new IIndexFragment[writable.length + readonly.length];
        System.arraycopy(writable, 0, result, 0, writable.length);
        System.arraycopy(readonly, 0, result, writable.length, readonly.length);
        return result;
    }

    public IIndexFragmentFile addFile(IIndexFileLocation fileLocation) throws CoreException {
        IWritableIndexFragment frag = this.selectFragment(fileLocation);
        return frag.addFile(fileLocation);
    }

    private IWritableIndexFragment selectFragment(IIndexFileLocation fileLocation) {
        if (!$assertionsDisabled && this.fWritableFragments.length != 1) {
            throw new AssertionError();
        }
        return this.fWritableFragments[0];
    }

    private boolean isWritableFragment(IIndexFragment frag) {
        int i = 0;
        while (i < this.fWritableFragments.length) {
            if (this.fWritableFragments[i] == frag) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setFileContent(IIndexFragmentFile file, IWritableIndex.IncludeInformation[] includes, IASTPreprocessorMacroDefinition[] macros, IASTName[][] names) throws CoreException {
        IIndexFragment indexFragment = file.getIndexFragment();
        if (!$assertionsDisabled && !this.isWritableFragment(indexFragment)) {
            throw new AssertionError();
        }
        int i = 0;
        while (i < includes.length) {
            IWritableIndex.IncludeInformation ii = includes[i];
            if (ii.fLocation != null) {
                ii.fTargetFile = this.addFile(ii.fLocation);
            }
            ++i;
        }
        ((IWritableIndexFragment)indexFragment).addFileContent(file, includes, macros, names);
    }

    public void clear() throws CoreException {
        int i = 0;
        while (i < this.fWritableFragments.length) {
            IWritableIndexFragment frag = this.fWritableFragments[i];
            frag.clear();
            ++i;
        }
    }

    public void clearFile(IIndexFragmentFile file, Collection clearedContexts) throws CoreException {
        IIndexFragment indexFragment = file.getIndexFragment();
        if (!$assertionsDisabled && !this.isWritableFragment(indexFragment)) {
            throw new AssertionError();
        }
        ((IWritableIndexFragment)indexFragment).clearFile(file, clearedContexts);
    }

    public synchronized void acquireReadLock() throws InterruptedException {
        if (!$assertionsDisabled && this.fIsWriteLocked) {
            throw new AssertionError((Object)"Read locks are not allowed while write-locked.");
        }
        super.acquireReadLock();
    }

    public synchronized void releaseReadLock() {
        if (!$assertionsDisabled && this.fIsWriteLocked) {
            throw new AssertionError((Object)"Read locks are not allowed while write-locked.");
        }
        super.releaseReadLock();
    }

    /*
     * Exception decompiling
     */
    public synchronized void acquireWriteLock(int giveupReadlockCount) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 134->138)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized void releaseWriteLock(int establishReadlockCount) {
        this.releaseWriteLock(establishReadlockCount, true);
    }

    public synchronized void releaseWriteLock(int establishReadlockCount, boolean flush) {
        if (!$assertionsDisabled && !this.fIsWriteLocked) {
            throw new AssertionError((Object)"No write lock to be released");
        }
        if (!$assertionsDisabled && establishReadlockCount != this.getReadLockCount()) {
            throw new AssertionError((Object)"Unexpected read lock is not allowed");
        }
        this.fIsWriteLocked = false;
        int i = 0;
        while (i < this.fWritableFragments.length) {
            this.fWritableFragments[i].releaseWriteLock(establishReadlockCount, flush);
            ++i;
        }
    }

    public IWritableIndexFragment getPrimaryWritableFragment() {
        return this.fWritableFragments.length > 0 ? this.fWritableFragments[0] : null;
    }

    public void flush() throws CoreException {
        if (!$assertionsDisabled && this.fIsWriteLocked) {
            throw new AssertionError();
        }
        int i = 0;
        i = 0;
        while (i < this.fWritableFragments.length) {
            this.fWritableFragments[i].flush();
            ++i;
        }
    }
}

