/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.provider;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.provider.IIndexProvider;
import org.eclipse.cdt.core.index.provider.IReadOnlyPDOMProvider;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.provider.IIndexFragmentProvider;
import org.eclipse.cdt.internal.core.index.provider.Messages;
import org.eclipse.cdt.internal.core.index.provider.ReadOnlyPDOMProviderBridge;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public final class IndexProviderManager
implements IElementChangedListener {
    public static final String READ_ONLY_PDOM_PROVIDER = "ReadOnlyPDOMProvider";
    private IIndexFragmentProvider[] allProviders = new IIndexFragmentProvider[0];
    private Map provisionMap = new HashMap();

    public void startup() {
        ArrayList<IIndexProvider> providers = new ArrayList<IIndexProvider>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint indexProviders = registry.getExtensionPoint("org.eclipse.cdt.core.CIndex");
        IExtension[] extensions = indexProviders.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            try {
                IConfigurationElement[] ce = extension.getConfigurationElements();
                int j = 0;
                while (j < ce.length) {
                    if (ce[j].getName().equals(READ_ONLY_PDOM_PROVIDER)) {
                        IIndexProvider provider = (IIndexProvider)ce[0].createExecutableExtension("class");
                        if (provider instanceof IReadOnlyPDOMProvider) {
                            provider = new ReadOnlyPDOMProviderBridge((IReadOnlyPDOMProvider)provider);
                            providers.add(provider);
                        } else {
                            CCorePlugin.log(MessageFormat.format(Messages.IndexProviderManager_0, extension.getContributor().getName()));
                        }
                    }
                    ++j;
                }
            }
            catch (CoreException ce) {
                CCorePlugin.log(ce);
            }
            ++i;
        }
        CoreModel.getDefault().addElementChangedListener(this);
        this.allProviders = providers.toArray(new IIndexFragmentProvider[providers.size()]);
    }

    public IIndexFragment[] getProvidedIndexFragments(ICConfigurationDescription config) throws CoreException {
        ArrayList<IIndexFragment> preResult = new ArrayList<IIndexFragment>();
        IProject project = config.getProjectDescription().getProject();
        int i = 0;
        while (i < this.allProviders.length) {
            try {
                if (this.providesForProject(this.allProviders[i], project)) {
                    preResult.addAll(Arrays.asList(this.allProviders[i].getIndexFragments(config)));
                }
            }
            catch (CoreException ce) {
                CCorePlugin.log(ce);
            }
            ++i;
        }
        IIndexFragment[] result = preResult.toArray(new IIndexFragment[preResult.size()]);
        return result;
    }

    public void addIndexProvider(IIndexProvider provider) {
        if (!(provider instanceof IIndexFragmentProvider)) {
            CCorePlugin.log("An unknown index provider implementation was plugged in to the CIndex extension point");
            return;
        }
        IIndexFragmentProvider[] newAllProviders = new IIndexFragmentProvider[this.allProviders.length + 1];
        System.arraycopy(this.allProviders, 0, newAllProviders, 0, this.allProviders.length);
        newAllProviders[this.allProviders.length] = (IIndexFragmentProvider)provider;
        this.allProviders = newAllProviders;
    }

    private boolean providesForProject(IIndexProvider provider, IProject project) {
        ArrayList<IIndexProvider> key = new ArrayList<IIndexProvider>();
        key.add(provider);
        key.add((IIndexProvider)project);
        if (!this.provisionMap.containsKey(key)) {
            try {
                ICProject cproject = CoreModel.getDefault().create(project);
                this.provisionMap.put(key, new Boolean(provider.providesFor(cproject)));
            }
            catch (CoreException ce) {
                CCorePlugin.log(ce);
                this.provisionMap.put(key, Boolean.FALSE);
            }
        }
        return (Boolean)this.provisionMap.get(key);
    }

    public void elementChanged(ElementChangedEvent event) {
        try {
            if (event.getType() == 1) {
                this.processDelta(event.getDelta());
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
    }

    private void processDelta(ICElementDelta delta) throws CoreException {
        int type = delta.getElement().getElementType();
        switch (type) {
            case 10: {
                ICElementDelta[] children = delta.getAffectedChildren();
                int i = 0;
                while (i < children.length) {
                    this.processDelta(children[i]);
                    ++i;
                }
                break;
            }
            case 11: {
                ICProject cproject = (ICProject)delta.getElement();
                switch (delta.getKind()) {
                    case 2: {
                        ArrayList<List> toRemove = new ArrayList<List>();
                        Iterator<Object> i = this.provisionMap.keySet().iterator();
                        while (i.hasNext()) {
                            List key = (List)i.next();
                            if (!key.contains(cproject.getProject())) continue;
                            toRemove.add(key);
                        }
                        i = toRemove.iterator();
                        while (i.hasNext()) {
                            this.provisionMap.remove(i.next());
                        }
                        break block0;
                    }
                }
            }
        }
    }
}

