/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.provider;

import java.io.File;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.internal.core.index.provider.Messages;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

class PDOMCache {
    private Map path2pdom = new HashMap();
    private Set versionMismatch = new HashSet();
    private static PDOMCache singleton;
    private static Object singletonMutex;

    static {
        singletonMutex = new Object();
    }

    private PDOMCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PDOMCache getInstance() {
        Object object = singletonMutex;
        synchronized (object) {
            if (singleton == null) {
                singleton = new PDOMCache();
            }
            return singleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PDOM getPDOM(IPath path, IIndexLocationConverter converter) {
        PDOM result = null;
        File file = path.toFile();
        if (this.versionMismatch.contains(file)) return result;
        Map map = this.path2pdom;
        synchronized (map) {
            if (this.path2pdom.containsKey(file)) {
                result = (PDOM)this.path2pdom.get(file);
            }
            if (result != null) return result;
            try {
                result = new PDOM(file, converter, LanguageManager.getInstance().getPDOMLinkageFactoryMappings());
                result.acquireReadLock();
                try {
                    if (result.versionMismatch()) {
                        this.versionMismatch.add(file);
                        String msg = MessageFormat.format(Messages.PDOMCache_VersionTooOld, file);
                        CCorePlugin.log(msg);
                        Object var7_9 = null;
                        result.releaseReadLock();
                        return null;
                    }
                    this.path2pdom.put(file, result);
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    result.releaseReadLock();
                    throw throwable;
                }
                {
                    Object var7_11 = null;
                    result.releaseReadLock();
                }
            }
            catch (CoreException ce) {
                CCorePlugin.log(ce);
            }
            catch (InterruptedException ie) {
                CCorePlugin.log(ie);
            }
            return result;
        }
    }
}

