/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.indexer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.model.AbstractLanguage;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.internal.core.index.IWritableIndex;
import org.eclipse.cdt.internal.core.index.IndexBasedCodeReaderFactory;
import org.eclipse.cdt.internal.core.index.IndexFileLocation;
import org.eclipse.cdt.internal.core.indexer.StandaloneFastIndexer;
import org.eclipse.cdt.internal.core.indexer.StandaloneIndexBasedCodeReaderFactory;
import org.eclipse.cdt.internal.core.indexer.StandaloneIndexerTask;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class StandaloneFastIndexerTask
extends StandaloneIndexerTask
implements IndexBasedCodeReaderFactory.CallbackHandler {
    private List fChanged = new ArrayList();
    private List fRemoved = new ArrayList();
    private IWritableIndex fIndex;
    private StandaloneIndexBasedCodeReaderFactory fCodeReaderFactory;
    private Map fIflCache;
    private int fCurrentConfigHash = 0;

    public StandaloneFastIndexerTask(StandaloneFastIndexer indexer, List added, List changed, List removed) {
        super(indexer);
        this.fChanged.addAll(added);
        this.fChanged.addAll(changed);
        this.fRemoved.addAll(removed);
        this.updateInfo(0, 0, this.fChanged.size() + this.fRemoved.size());
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) throws IOException {
        start = System.currentTimeMillis();
        try {
            block14: {
                block13: {
                    this.setupIndexAndReaderFactory();
                    this.fIndex.acquireReadLock();
                    try {
                        this.registerTUsInReaderFactory(this.fChanged);
                        i = this.fRemoved.iterator();
                        while (true) {
                            if (!i.hasNext()) break;
                            if (monitor.isCanceled()) {
lbl12:
                                // 2 sources

                                while (true) {
                                    var9_6 = null;
                                    break block13;
                                    break;
                                }
                            }
                            tu = (String)i.next();
                            this.removeTU(this.fIndex, this.getIndexFileLocation(tu), 1);
                            if (this.isValidSourceUnitName(tu)) {
                                this.updateInfo(1, 0, 0);
                                continue;
                            }
                            this.updateInfo(0, 1, -1);
                        }
                        headers = new ArrayList<String>();
                        sources = this.fChanged;
                        iter = this.fChanged.iterator();
                        while (true) {
                            if (!iter.hasNext()) {
                                this.parseTUs(this.fIndex, 1, sources, headers, monitor);
                                if (monitor.isCanceled()) {
                                    ** continue;
                                }
                                break block14;
                            }
                            tu = (String)iter.next();
                            if (this.isValidSourceUnitName(tu)) continue;
                            headers.add(tu);
                            iter.remove();
                        }
                    }
                    catch (Throwable var10_12) {
                        var9_7 = null;
                        this.fIndex.releaseReadLock();
                        throw var10_12;
                    }
                }
                this.fIndex.releaseReadLock();
                return;
            }
            var9_8 = null;
            this.fIndex.releaseReadLock();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (InterruptedException v0) {}
        this.traceEnd(start);
    }

    private void setupIndexAndReaderFactory() throws CoreException {
        this.fIndex = this.fIndexer.getIndex();
        this.fIndex.resetCacheCounters();
        this.fIflCache = new HashMap();
        this.fCodeReaderFactory = new StandaloneIndexBasedCodeReaderFactory((IIndex)this.fIndex, this.fIflCache);
        this.fCodeReaderFactory.setCallbackHandler(this);
    }

    private void registerTUsInReaderFactory(Collection files) throws IOException, CoreException {
        int removed = 0;
        Iterator iter = files.iterator();
        while (iter.hasNext()) {
            String sourcePath = (String)iter.next();
            String path = new File(sourcePath).getCanonicalPath();
            IIndexFileLocation location = this.getIndexFileLocation(path);
            IndexBasedCodeReaderFactory.IndexFileInfo info = this.fCodeReaderFactory.createFileInfo(location);
            if (this.updateAll()) {
                info.fRequested = 2;
                continue;
            }
            if (this.updateChangedTimestamps() && this.isOutdated(location, info.fFile)) {
                info.fRequested = 2;
                continue;
            }
            iter.remove();
            ++removed;
        }
        this.updateInfo(0, 0, -removed);
    }

    protected IIndexFileLocation findLocation(String absolutePath) {
        IIndexFileLocation result = (IIndexFileLocation)this.fIflCache.get(absolutePath);
        if (result == null) {
            result = new IndexFileLocation(URIUtil.toURI((String)absolutePath), absolutePath);
            this.fIflCache.put(absolutePath, result);
        }
        return result;
    }

    protected IASTTranslationUnit createAST(AbstractLanguage lang, CodeReader codeReader, IScannerInfo scanInfo, int options, IProgressMonitor pm) throws CoreException {
        IASTTranslationUnit ast = lang.getASTTranslationUnit(codeReader, scanInfo, this.fCodeReaderFactory, this.fIndex, options, this.fIndexer.getParserLog());
        if (pm.isCanceled()) {
            return null;
        }
        this.fCodeReaderFactory.clearMacroAttachements();
        return ast;
    }

    protected boolean needToUpdate(IIndexFileLocation location, int confighash) throws CoreException {
        if (super.needToUpdate(location, confighash)) {
            IndexBasedCodeReaderFactory.IndexFileInfo info = this.fCodeReaderFactory.createFileInfo(location);
            return this.needToUpdate(info, confighash);
        }
        return false;
    }

    public boolean needToUpdate(IndexBasedCodeReaderFactory.IndexFileInfo info) throws CoreException {
        return this.needToUpdate(info, this.fCurrentConfigHash);
    }

    private boolean needToUpdate(IndexBasedCodeReaderFactory.IndexFileInfo info, int confighash) throws CoreException {
        if (info.fFile == null) {
            return true;
        }
        if (confighash != 0 && info.fRequested == 1) {
            int oldhash = info.fFile.getScannerConfigurationHashcode();
            if (oldhash == 0 || oldhash == confighash) {
                info.fRequested = 0;
                this.updateInfo(0, 0, -1);
            } else {
                info.fRequested = 2;
            }
        }
        return info.fRequested != 0;
    }

    protected boolean postAddToIndex(IIndexFileLocation path, IIndexFile file) throws CoreException {
        IndexBasedCodeReaderFactory.IndexFileInfo info = this.fCodeReaderFactory.createFileInfo(path);
        info.fFile = file;
        if (info.fRequested != 0) {
            info.fRequested = 0;
            return true;
        }
        return false;
    }
}

