/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.language;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.language.ProjectLanguageConfiguration;
import org.eclipse.cdt.core.language.WorkspaceLanguageConfiguration;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.internal.core.language.LanguageMapping;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;

public class LanguageMappingResolver {
    public static final int DEFAULT_MAPPING = 0;
    public static final int WORKSPACE_MAPPING = 1;
    public static final int PROJECT_MAPPING = 2;
    public static final int FILE_MAPPING = 3;

    public static LanguageMapping[] computeLanguage(IProject project, String filePath, ICConfigurationDescription configuration, String contentTypeId, boolean fetchAll) throws CoreException {
        WorkspaceLanguageConfiguration workspaceMappings;
        String id;
        ProjectLanguageConfiguration mappings;
        LanguageManager manager = LanguageManager.getInstance();
        LinkedList<LanguageMapping> inheritedLanguages = new LinkedList<LanguageMapping>();
        if (project != null && (mappings = manager.getLanguageConfiguration(project)) != null) {
            if (filePath != null) {
                id = mappings.getLanguageForFile(configuration, filePath);
                if (id != null) {
                    inheritedLanguages.add(new LanguageMapping(manager.getLanguage(id), 3));
                    if (!fetchAll) {
                        return LanguageMappingResolver.createLanguageMappingArray(inheritedLanguages);
                    }
                }
                if (configuration != null && (id = mappings.getLanguageForFile(null, filePath)) != null) {
                    inheritedLanguages.add(new LanguageMapping(manager.getLanguage(id), 3));
                    if (!fetchAll) {
                        return LanguageMappingResolver.createLanguageMappingArray(inheritedLanguages);
                    }
                }
            }
            if ((id = mappings.getLanguageForContentType(configuration, contentTypeId)) != null) {
                inheritedLanguages.add(new LanguageMapping(manager.getLanguage(id), 2));
                if (!fetchAll) {
                    return LanguageMappingResolver.createLanguageMappingArray(inheritedLanguages);
                }
            }
            if (configuration != null && (id = mappings.getLanguageForContentType(null, contentTypeId)) != null) {
                inheritedLanguages.add(new LanguageMapping(manager.getLanguage(id), 2));
                if (!fetchAll) {
                    return LanguageMappingResolver.createLanguageMappingArray(inheritedLanguages);
                }
            }
        }
        if ((id = (workspaceMappings = manager.getWorkspaceLanguageConfiguration()).getLanguageForContentType(contentTypeId)) != null) {
            inheritedLanguages.add(new LanguageMapping(manager.getLanguage(id), 1));
            if (!fetchAll) {
                return LanguageMappingResolver.createLanguageMappingArray(inheritedLanguages);
            }
        }
        IContentType contentType = Platform.getContentTypeManager().getContentType(contentTypeId);
        inheritedLanguages.add(new LanguageMapping(manager.getLanguage(contentType), 0));
        return LanguageMappingResolver.createLanguageMappingArray(inheritedLanguages);
    }

    private static LanguageMapping[] createLanguageMappingArray(List inheritedLanguages) {
        LanguageMapping[] results = new LanguageMapping[inheritedLanguages.size()];
        Iterator mappings = inheritedLanguages.iterator();
        int i = 0;
        while (mappings.hasNext()) {
            LanguageMapping mapping;
            results[i] = mapping = (LanguageMapping)mappings.next();
            ++i;
        }
        return results;
    }
}

