/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.IProblemRequestor;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.CommitWorkingCopyOperation;
import org.eclipse.cdt.internal.core.model.DestroyWorkingCopyOperation;
import org.eclipse.cdt.internal.core.model.ExternalTranslationUnit;
import org.eclipse.cdt.internal.core.model.IBufferFactory;
import org.eclipse.cdt.internal.core.model.ReconcileWorkingCopyOperation;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.internal.core.model.TranslationUnitInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class WorkingCopy
extends TranslationUnit
implements IWorkingCopy {
    protected IBufferFactory bufferFactory;
    protected int useCount = 1;

    public WorkingCopy(ICElement parent, IFile file, String id, IBufferFactory bufferFactory) {
        this(parent, file, id, bufferFactory, null);
    }

    public WorkingCopy(ICElement parent, IFile file, String id, IBufferFactory bufferFactory, IProblemRequestor requestor) {
        super(parent, file, id);
        this.bufferFactory = bufferFactory == null ? this.getBufferManager() : bufferFactory;
        this.problemRequestor = requestor;
    }

    public WorkingCopy(ICElement parent, IPath path, String id, IBufferFactory bufferFactory) {
        super(parent, path, id);
        this.bufferFactory = bufferFactory == null ? this.getBufferManager() : bufferFactory;
    }

    public void commit(boolean force, IProgressMonitor monitor) throws CModelException {
        ITranslationUnit original = this.getOriginalElement();
        if (original.exists()) {
            CommitWorkingCopyOperation op = new CommitWorkingCopyOperation(this, force);
            op.runOperation(monitor);
        } else {
            String contents = this.getSource();
            if (contents == null) {
                return;
            }
            try {
                IFile originalRes = (IFile)original.getResource();
                String encoding = null;
                try {
                    encoding = originalRes.getCharset();
                }
                catch (CoreException coreException) {}
                byte[] bytes = encoding == null ? contents.getBytes() : contents.getBytes(encoding);
                ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                if (originalRes.exists()) {
                    originalRes.setContents((InputStream)stream, force ? 3 : 2, null);
                } else {
                    originalRes.create((InputStream)stream, force, monitor);
                }
            }
            catch (IOException e) {
                throw new CModelException(e, 985);
            }
            catch (CoreException e) {
                throw new CModelException(e);
            }
        }
    }

    public void destroy() {
        if (--this.useCount > 0) {
            return;
        }
        try {
            DestroyWorkingCopyOperation op = new DestroyWorkingCopyOperation(this);
            op.runOperation(null);
        }
        catch (CModelException cModelException) {}
    }

    public boolean exists() {
        return this.useCount != 0;
    }

    public IBufferFactory getBufferFactory() {
        return this.bufferFactory;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public ICElement getOriginal(ICElement workingCopyElement) {
        if (workingCopyElement instanceof ISourceReference) {
            ITranslationUnit wunit = ((ISourceReference)((Object)workingCopyElement)).getTranslationUnit();
            if (!wunit.equals(this)) {
                return null;
            }
        } else {
            return null;
        }
        ITranslationUnit tu = this.getOriginalElement();
        if (tu == null) {
            return null;
        }
        ICElement element = workingCopyElement;
        ArrayList<ICElement> children = new ArrayList<ICElement>();
        while (element != null && element.getElementType() != 60) {
            children.add(element);
            element = element.getParent();
        }
        ICElement current = tu;
        int i = children.size() - 1;
        while (i >= 0) {
            ICElement child = (ICElement)children.get(i);
            if (current instanceof IParent) {
                try {
                    ICElement[] celems = ((IParent)((Object)current)).getChildren();
                    current = null;
                    int j = 0;
                    while (j < celems.length) {
                        if (celems[j].getElementName().equals(child.getElementName()) && celems[j].getElementType() == child.getElementType()) {
                            current = celems[j];
                            break;
                        }
                        ++j;
                    }
                }
                catch (CModelException cModelException) {
                    current = null;
                }
            } else {
                current = null;
            }
            --i;
        }
        return current;
    }

    public ITranslationUnit getOriginalElement() {
        IFile file = this.getFile();
        if (file != null) {
            return new TranslationUnit(this.getParent(), this.getFile(), this.getContentTypeId());
        }
        return new ExternalTranslationUnit(this.getParent(), this.getLocation(), this.getContentTypeId());
    }

    public IWorkingCopy getSharedWorkingCopy(IProgressMonitor monitor, IBufferFactory factory) throws CModelException {
        return this;
    }

    public IWorkingCopy getWorkingCopy() {
        return this;
    }

    public IWorkingCopy getWorkingCopy(IProgressMonitor monitor, IBufferFactory factory) {
        return this;
    }

    public boolean isBasedOn(IResource resource) {
        if (resource.getType() != 1) {
            return false;
        }
        if (this.useCount == 0) {
            return false;
        }
        try {
            return ((TranslationUnitInfo)this.getElementInfo()).fTimestamp == ((IFile)resource).getModificationStamp();
        }
        catch (CModelException cModelException) {
            return false;
        }
    }

    public boolean isWorkingCopy() {
        return true;
    }

    public void open(IProgressMonitor monitor) throws CModelException {
        if (this.useCount == 0) {
            throw this.newNotPresentException();
        }
        super.open(monitor);
    }

    protected IBuffer openBuffer(IProgressMonitor pm) throws CModelException {
        if (this.useCount == 0) {
            throw this.newNotPresentException();
        }
        IBuffer buffer = this.getBufferFactory().createBuffer(this);
        if (buffer == null) {
            return null;
        }
        if (buffer.getContents() == null) {
            IBuffer originalBuffer;
            block8: {
                ITranslationUnit original = this.getOriginalElement();
                originalBuffer = null;
                try {
                    originalBuffer = original.getBuffer();
                }
                catch (CModelException e) {
                    if (e.getCModelStatus().doesNotExist()) break block8;
                    throw e;
                }
            }
            if (originalBuffer != null) {
                char[] originalContents = originalBuffer.getCharacters();
                if (originalContents != null) {
                    buffer.setContents((char[])originalContents.clone());
                }
            } else {
                buffer.setContents(new char[0]);
            }
        }
        this.getBufferManager().addBuffer(buffer);
        buffer.addBufferChangedListener(this);
        return buffer;
    }

    public IMarker[] reconcile() throws CModelException {
        this.reconcile(false, null);
        return null;
    }

    public void reconcile(boolean forceProblemDetection, IProgressMonitor monitor) throws CModelException {
        this.reconcile(false, forceProblemDetection, monitor);
    }

    public void restore() throws CModelException {
        if (this.useCount == 0) {
            throw this.newNotPresentException();
        }
        TranslationUnit original = (TranslationUnit)this.getOriginalElement();
        IBuffer buffer = this.getBuffer();
        if (buffer == null) {
            return;
        }
        buffer.setContents(original.getContents());
        this.updateTimeStamp(original);
        this.makeConsistent(null);
    }

    public void save(IProgressMonitor pm, boolean force) throws CModelException {
        if (this.isReadOnly()) {
            throw new CModelException(new CModelStatus(976, this));
        }
        this.reconcile();
    }

    protected void updateTimeStamp(TranslationUnit original) throws CModelException {
        long timeStamp = ((IFile)original.getResource()).getModificationStamp();
        if (timeStamp == -1L) {
            throw new CModelException(new CModelStatus(995));
        }
        ((TranslationUnitInfo)this.getElementInfo()).fTimestamp = timeStamp;
    }

    public IASTTranslationUnit reconcile(boolean computeAST, boolean forceProblemDetection, IProgressMonitor monitor) throws CModelException {
        if (this.useCount == 0) {
            throw this.newNotPresentException();
        }
        ReconcileWorkingCopyOperation op = new ReconcileWorkingCopyOperation(this, computeAST, forceProblemDetection);
        op.runOperation(monitor);
        return op.fAST;
    }
}

