/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.db;

import java.text.MessageFormat;
import org.eclipse.cdt.internal.core.pdom.db.Chunk;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeComparator;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.cdt.internal.core.pdom.db.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class BTree {
    private static final int DELMODE_NORMAL = 0;
    private static final int DELMODE_DELETE_MINIMUM = 1;
    private static final int DELMODE_DELETE_MAXIMUM = 2;
    protected final Database db;
    protected final int rootPointer;
    protected final int DEGREE;
    protected final int MAX_RECORDS;
    protected final int MAX_CHILDREN;
    protected final int MIN_RECORDS;
    protected final int OFFSET_CHILDREN;
    protected final int MEDIAN_RECORD;
    protected final IBTreeComparator cmp;

    public BTree(Database db, int rootPointer, IBTreeComparator cmp) {
        this(db, rootPointer, 8, cmp);
    }

    public BTree(Database db, int rootPointer, int degree, IBTreeComparator cmp) {
        if (degree < 2) {
            throw new IllegalArgumentException(Messages.getString("BTree.IllegalDegree"));
        }
        this.db = db;
        this.rootPointer = rootPointer;
        this.cmp = cmp;
        this.DEGREE = degree;
        this.MIN_RECORDS = this.DEGREE - 1;
        this.MAX_RECORDS = 2 * this.DEGREE - 1;
        this.MAX_CHILDREN = 2 * this.DEGREE;
        this.OFFSET_CHILDREN = this.MAX_RECORDS * 4;
        this.MEDIAN_RECORD = this.DEGREE - 1;
    }

    protected int getRoot() throws CoreException {
        return this.db.getInt(this.rootPointer);
    }

    protected final void putRecord(Chunk chunk, int node, int index, int record) {
        chunk.putInt(node + index * 4, record);
    }

    protected final int getRecord(Chunk chunk, int node, int index) {
        return chunk.getInt(node + index * 4);
    }

    protected final void putChild(Chunk chunk, int node, int index, int child) {
        chunk.putInt(node + this.OFFSET_CHILDREN + index * 4, child);
    }

    protected final int getChild(Chunk chunk, int node, int index) {
        return chunk.getInt(node + this.OFFSET_CHILDREN + index * 4);
    }

    public int insert(int record) throws CoreException {
        int root = this.getRoot();
        if (root == 0) {
            this.firstInsert(record);
            return record;
        }
        return this.insert(null, 0, 0, root, record);
    }

    private int insert(Chunk pChunk, int parent, int iParent, int node, int record) throws CoreException {
        int child;
        Chunk chunk = this.db.getChunk(node);
        if (this.getRecord(chunk, node, this.MAX_RECORDS - 1) != 0) {
            int median = this.getRecord(chunk, node, this.MEDIAN_RECORD);
            if (median == record) {
                return median;
            }
            int newnode = this.allocateNode();
            Chunk newchunk = this.db.getChunk(newnode);
            int i = 0;
            while (i < this.MEDIAN_RECORD) {
                this.putRecord(newchunk, newnode, i, this.getRecord(chunk, node, this.MEDIAN_RECORD + 1 + i));
                this.putRecord(chunk, node, this.MEDIAN_RECORD + 1 + i, 0);
                this.putChild(newchunk, newnode, i, this.getChild(chunk, node, this.MEDIAN_RECORD + 1 + i));
                this.putChild(chunk, node, this.MEDIAN_RECORD + 1 + i, 0);
                ++i;
            }
            this.putChild(newchunk, newnode, this.MEDIAN_RECORD, this.getChild(chunk, node, this.MAX_RECORDS));
            this.putChild(chunk, node, this.MAX_RECORDS, 0);
            if (parent == 0) {
                parent = this.allocateNode();
                pChunk = this.db.getChunk(parent);
                this.db.putInt(this.rootPointer, parent);
                this.putChild(pChunk, parent, 0, node);
            } else {
                i = this.MAX_RECORDS - 2;
                while (i >= iParent) {
                    int r = this.getRecord(pChunk, parent, i);
                    if (r != 0) {
                        this.putRecord(pChunk, parent, i + 1, r);
                        this.putChild(pChunk, parent, i + 2, this.getChild(pChunk, parent, i + 1));
                    }
                    --i;
                }
            }
            this.putRecord(pChunk, parent, iParent, median);
            this.putChild(pChunk, parent, iParent + 1, newnode);
            this.putRecord(chunk, node, this.MEDIAN_RECORD, 0);
            if (this.cmp.compare(record, median) > 0) {
                node = newnode;
                chunk = newchunk;
            }
        }
        int i = 0;
        while (i < this.MAX_RECORDS) {
            int record1 = this.getRecord(chunk, node, i);
            if (record1 == 0) break;
            int compare = this.cmp.compare(record1, record);
            if (compare == 0) {
                return record;
            }
            if (compare > 0) break;
            ++i;
        }
        if ((child = this.getChild(chunk, node, i)) != 0) {
            return this.insert(chunk, node, i, child, record);
        }
        int j = this.MAX_RECORDS - 2;
        while (j >= i) {
            int r = this.getRecord(chunk, node, j);
            if (r != 0) {
                this.putRecord(chunk, node, j + 1, r);
            }
            --j;
        }
        this.putRecord(chunk, node, i, record);
        return record;
    }

    private void firstInsert(int record) throws CoreException {
        int root = this.allocateNode();
        this.db.putInt(this.rootPointer, root);
        this.putRecord(this.db.getChunk(root), root, 0, record);
    }

    private int allocateNode() throws CoreException {
        return this.db.malloc((2 * this.MAX_RECORDS + 1) * 4);
    }

    public void delete(int record) throws CoreException {
        try {
            this.deleteImp(record, this.getRoot(), 0);
        }
        catch (BTreeKeyNotFoundException bTreeKeyNotFoundException) {}
    }

    private int deleteImp(int key, int nodeRecord, int mode) throws CoreException, BTreeKeyNotFoundException {
        int subtreeIndex;
        BTNode node = new BTNode(nodeRecord);
        int keyIndexInNode = -1;
        if (mode == 0) {
            int i = 0;
            while (i < node.keyCount) {
                if (this.getRecord(node.chunk, node.node, i) == key) {
                    keyIndexInNode = i;
                    break;
                }
                ++i;
            }
        }
        if (this.getChild(node.chunk, node.node, 0) == 0) {
            int subst;
            if (keyIndexInNode != -1) {
                this.nodeContentDelete(node, keyIndexInNode, 1);
                return key;
            }
            if (mode == 1) {
                subst = this.getRecord(node.chunk, node.node, 0);
                this.nodeContentDelete(node, 0, 1);
                return subst;
            }
            if (mode == 2) {
                subst = this.getRecord(node.chunk, node.node, node.keyCount - 1);
                this.nodeContentDelete(node, node.keyCount - 1, 1);
                return subst;
            }
            throw new BTreeKeyNotFoundException(MessageFormat.format(Messages.getString("BTree.DeletionOnAbsentKey"), new Integer(key), new Integer(mode)));
        }
        if (keyIndexInNode != -1) {
            BTNode succ = node.getChild(keyIndexInNode + 1);
            if (succ != null && succ.keyCount > this.MIN_RECORDS) {
                int subst = this.deleteImp(-1, succ.node, 1);
                this.putRecord(node.chunk, node.node, keyIndexInNode, subst);
                return key;
            }
            BTNode pred = node.getChild(keyIndexInNode);
            if (pred != null && pred.keyCount > this.MIN_RECORDS) {
                int subst = this.deleteImp(-1, pred.node, 2);
                this.putRecord(node.chunk, node.node, keyIndexInNode, subst);
                return key;
            }
            this.mergeNodes(succ, node, keyIndexInNode, pred);
            return this.deleteImp(key, pred.node, mode);
        }
        block0 : switch (mode) {
            case 0: {
                subtreeIndex = node.keyCount;
                int i = 0;
                while (i < node.keyCount) {
                    if (this.cmp.compare(this.getRecord(node.chunk, node.node, i), key) > 0) {
                        subtreeIndex = i;
                        break block0;
                    }
                    ++i;
                }
                break;
            }
            case 1: {
                subtreeIndex = 0;
                break;
            }
            case 2: {
                subtreeIndex = node.keyCount;
                break;
            }
            default: {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", 0, Messages.getString("BTree.UnknownMode"), null));
            }
        }
        BTNode child = node.getChild(subtreeIndex);
        if (child == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", 0, Messages.getString("BTree.IntegrityError"), null));
        }
        if (child.keyCount > this.MIN_RECORDS) {
            return this.deleteImp(key, child.node, mode);
        }
        BTNode sibR = node.getChild(subtreeIndex + 1);
        if (sibR != null && sibR.keyCount > this.MIN_RECORDS) {
            int rightKey = this.getRecord(node.chunk, node.node, subtreeIndex);
            int leftmostRightSiblingKey = this.getRecord(sibR.chunk, sibR.node, 0);
            this.append(child, rightKey, this.getChild(sibR.chunk, sibR.node, 0));
            this.nodeContentDelete(sibR, 0, 1);
            this.putRecord(node.chunk, node.node, subtreeIndex, leftmostRightSiblingKey);
            return this.deleteImp(key, child.node, mode);
        }
        BTNode sibL = node.getChild(subtreeIndex - 1);
        if (sibL != null && sibL.keyCount > this.MIN_RECORDS) {
            int leftKey = this.getRecord(node.chunk, node.node, subtreeIndex - 1);
            this.prepend(child, leftKey, this.getChild(sibL.chunk, sibL.node, sibL.keyCount));
            int rightmostLeftSiblingKey = this.getRecord(sibL.chunk, sibL.node, sibL.keyCount - 1);
            this.putRecord(sibL.chunk, sibL.node, sibL.keyCount - 1, 0);
            this.putChild(sibL.chunk, sibL.node, sibL.keyCount, 0);
            this.putRecord(node.chunk, node.node, subtreeIndex - 1, rightmostLeftSiblingKey);
            return this.deleteImp(key, child.node, mode);
        }
        if (sibL != null) {
            this.mergeNodes(child, node, subtreeIndex - 1, sibL);
            return this.deleteImp(key, sibL.node, mode);
        }
        if (sibR != null) {
            this.mergeNodes(sibR, node, subtreeIndex, child);
            return this.deleteImp(key, child.node, mode);
        }
        throw new BTreeKeyNotFoundException(MessageFormat.format(Messages.getString("BTree.DeletionOnAbsentKey"), new Integer(key), new Integer(mode)));
    }

    public void mergeNodes(BTNode src, BTNode keyProvider, int kIndex, BTNode dst) throws CoreException {
        int rootNode;
        this.nodeContentCopy(src, 0, dst, dst.keyCount + 1, src.keyCount + 1);
        int midKey = this.getRecord(keyProvider.chunk, keyProvider.node, kIndex);
        this.putRecord(dst.chunk, dst.node, dst.keyCount, midKey);
        int keySucc = kIndex + 1 == this.MAX_RECORDS ? 0 : this.getRecord(keyProvider.chunk, keyProvider.node, kIndex + 1);
        this.db.free(this.getChild(keyProvider.chunk, keyProvider.node, kIndex + 1));
        this.nodeContentDelete(keyProvider, kIndex + 1, 1);
        this.putRecord(keyProvider.chunk, keyProvider.node, kIndex, keySucc);
        if (kIndex == 0 && keySucc == 0 && (rootNode = this.getRoot()) == keyProvider.node) {
            this.db.putInt(this.rootPointer, dst.node);
            this.db.free(rootNode);
        }
    }

    private void prepend(BTNode node, int key, int child) {
        this.nodeContentCopy(node, 0, node, 1, node.keyCount + 1);
        this.putRecord(node.chunk, node.node, 0, key);
        this.putChild(node.chunk, node.node, 0, child);
    }

    private void append(BTNode node, int key, int child) {
        this.putRecord(node.chunk, node.node, node.keyCount, key);
        this.putChild(node.chunk, node.node, node.keyCount + 1, child);
    }

    private void nodeContentCopy(BTNode src, int srcPos, BTNode dst, int dstPos, int length) {
        int i = length - 1;
        while (i >= 0) {
            int srcIndex = srcPos + i;
            int dstIndex = dstPos + i;
            if (srcIndex < src.keyCount + 1) {
                int srcChild = this.getChild(src.chunk, src.node, srcIndex);
                this.putChild(dst.chunk, dst.node, dstIndex, srcChild);
                if (srcIndex < src.keyCount) {
                    int srcKey = this.getRecord(src.chunk, src.node, srcIndex);
                    this.putRecord(dst.chunk, dst.node, dstIndex, srcKey);
                }
            }
            --i;
        }
    }

    private void nodeContentDelete(BTNode node, int i, int length) {
        int index = i;
        while (index <= this.MAX_RECORDS) {
            int newChild;
            int newKey = index + length < node.keyCount ? this.getRecord(node.chunk, node.node, index + length) : 0;
            int n = newChild = index + length < node.keyCount + 1 ? this.getChild(node.chunk, node.node, index + length) : 0;
            if (index < this.MAX_RECORDS) {
                this.putRecord(node.chunk, node.node, index, newKey);
            }
            if (index < this.MAX_CHILDREN) {
                this.putChild(node.chunk, node.node, index, newChild);
            }
            ++index;
        }
    }

    public void accept(IBTreeVisitor visitor) throws CoreException {
        this.accept(this.db.getInt(this.rootPointer), visitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean accept(int node, IBTreeVisitor visitor) throws CoreException {
        boolean bl;
        block11: {
            block10: {
                boolean bl2;
                block9: {
                    if (node == 0) {
                        return true;
                    }
                    if (visitor instanceof IBTreeVisitor2) {
                        ((IBTreeVisitor2)visitor).preNode(node);
                    }
                    try {
                        int record;
                        Chunk chunk = this.db.getChunk(node);
                        int i = 0;
                        while (i < this.MAX_RECORDS && (record = this.getRecord(chunk, node, i)) != 0) {
                            int compare = visitor.compare(record);
                            if (compare > 0) {
                                bl2 = this.accept(this.getChild(chunk, node, i), visitor);
                                Object var7_9 = null;
                                break block9;
                            }
                            if (compare == 0) {
                                if (!this.accept(this.getChild(chunk, node, i), visitor)) {
                                    break block10;
                                }
                                if (!visitor.visit(record)) break block10;
                            }
                            ++i;
                        }
                        bl = this.accept(this.getChild(chunk, node, i), visitor);
                        break block11;
                    }
                    catch (Throwable throwable) {
                        Object var7_12 = null;
                        if (!(visitor instanceof IBTreeVisitor2)) throw throwable;
                        ((IBTreeVisitor2)visitor).postNode(node);
                        throw throwable;
                    }
                }
                if (!(visitor instanceof IBTreeVisitor2)) return bl2;
                ((IBTreeVisitor2)visitor).postNode(node);
                return bl2;
            }
            Object var7_10 = null;
            if (!(visitor instanceof IBTreeVisitor2)) return false;
            ((IBTreeVisitor2)visitor).postNode(node);
            return false;
        }
        Object var7_11 = null;
        if (!(visitor instanceof IBTreeVisitor2)) return bl;
        ((IBTreeVisitor2)visitor).postNode(node);
        return bl;
    }

    public String getInvariantsErrorReport() throws CoreException {
        InvariantsChecker checker = new InvariantsChecker();
        this.accept(checker);
        return checker.isValid() ? "" : checker.getMsg();
    }

    private class BTNode {
        final int node;
        final int keyCount;
        final Chunk chunk;

        BTNode(int node) throws CoreException {
            this.node = node;
            this.chunk = BTree.this.db.getChunk(node);
            int i = 0;
            while (i < BTree.this.MAX_RECORDS && BTree.this.getRecord(this.chunk, node, i) != 0) {
                ++i;
            }
            this.keyCount = i;
        }

        private BTNode getChild(int index) throws CoreException {
            int child;
            if (index >= 0 && index < BTree.this.MAX_CHILDREN && (child = BTree.this.getChild(this.chunk, this.node, index)) != 0) {
                return new BTNode(child);
            }
            return null;
        }
    }

    private class BTreeKeyNotFoundException
    extends Exception {
        private static final long serialVersionUID = 9065438266175091670L;

        public BTreeKeyNotFoundException(String msg) {
            super(msg);
        }
    }

    private static interface IBTreeVisitor2
    extends IBTreeVisitor {
        public void preNode(int var1) throws CoreException;

        public void postNode(int var1) throws CoreException;
    }

    private class InvariantsChecker
    implements IBTreeVisitor2 {
        boolean valid = true;
        String msg = "";
        Integer leafDepth;
        int depth;

        private InvariantsChecker() {
        }

        public String getMsg() {
            return this.msg;
        }

        public boolean isValid() {
            return this.valid;
        }

        public void postNode(int node) throws CoreException {
            --this.depth;
        }

        public int compare(int record) throws CoreException {
            return 0;
        }

        public boolean visit(int record) throws CoreException {
            return true;
        }

        public void preNode(int node) throws CoreException {
            ++this.depth;
            int keyCount = 0;
            int indexFirstBlankKey = BTree.this.MAX_RECORDS;
            int indexLastNonBlankKey = 0;
            int i = 0;
            while (i < BTree.this.MAX_RECORDS) {
                if (BTree.this.getRecord(BTree.this.db.getChunk(node), node, i) != 0) {
                    ++keyCount;
                    indexLastNonBlankKey = i;
                } else if (indexFirstBlankKey == BTree.this.MAX_RECORDS) {
                    indexFirstBlankKey = i;
                }
                ++i;
            }
            int childCount = 0;
            int i2 = 0;
            while (i2 < BTree.this.MAX_CHILDREN) {
                if (BTree.this.getChild(BTree.this.db.getChunk(node), node, i2) != 0) {
                    ++childCount;
                }
                ++i2;
            }
            if (indexFirstBlankKey != indexLastNonBlankKey + 1) {
                boolean empty;
                boolean full = indexFirstBlankKey == BTree.this.MAX_RECORDS && indexLastNonBlankKey == BTree.this.MAX_RECORDS - 1;
                boolean bl = empty = indexFirstBlankKey == 0 && indexLastNonBlankKey == 0;
                if (!full && !empty) {
                    this.valid = false;
                    this.msg = String.valueOf(this.msg) + MessageFormat.format(Messages.getString("BTree.IntegrityErrorA"), new Integer(node), new Integer(indexFirstBlankKey), new Integer(indexLastNonBlankKey));
                }
            }
            if (childCount != 0 && childCount != keyCount + 1) {
                this.valid = false;
                this.msg = String.valueOf(this.msg) + MessageFormat.format(Messages.getString("BTree.IntegrityErrorB"), new Integer(node));
            }
            if (node == BTree.this.db.getInt(BTree.this.rootPointer)) {
                return;
            }
            if (keyCount < BTree.this.MIN_RECORDS || keyCount > BTree.this.MAX_RECORDS) {
                this.valid = false;
                this.msg = String.valueOf(this.msg) + MessageFormat.format(Messages.getString("BTree.IntegrityErrorC"), new Integer(node));
            }
            if (childCount == 0) {
                if (this.leafDepth == null) {
                    this.leafDepth = new Integer(this.depth);
                }
                if (this.depth != this.leafDepth) {
                    this.valid = false;
                    this.msg = String.valueOf(this.msg) + Messages.getString("BTree.IntegrityErrorD");
                }
            }
        }
    }
}

