/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.db;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.internal.core.pdom.db.BTree;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeComparator;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.core.runtime.CoreException;

public class DBProperties {
    static final int PROP_INDEX = 0;
    static final int RECORD_SIZE = 4;
    protected BTree index;
    protected Database db;
    protected int record;
    static /* synthetic */ Class class$0;

    public DBProperties(Database db) throws CoreException {
        this.record = db.malloc(4);
        this.index = new BTree(db, this.record + 0, DBProperty.getComparator(db));
        this.db = db;
    }

    public DBProperties(Database db, int record) throws CoreException {
        this.record = record;
        this.index = new BTree(db, record + 0, DBProperty.getComparator(db));
        this.db = db;
    }

    public String getProperty(String key) throws CoreException {
        DBProperty existing;
        if (key != null && (existing = DBProperty.search(this.db, this.index, key)) != null) {
            return existing.getValue().getString();
        }
        return null;
    }

    public String getProperty(String key, String defaultValue) throws CoreException {
        String val = this.getProperty(key);
        return val == null ? defaultValue : val;
    }

    public Set getKeySet() throws CoreException {
        return DBProperty.getKeySet(this.db, this.index);
    }

    public void setProperty(String key, String value) throws CoreException {
        this.removeProperty(key);
        DBProperty newProperty = new DBProperty(this.db, key, value);
        this.index.insert(newProperty.getRecord());
    }

    public boolean removeProperty(String key) throws CoreException {
        DBProperty existing;
        if (key != null && (existing = DBProperty.search(this.db, this.index, key)) != null) {
            this.index.delete(existing.getRecord());
            existing.delete();
            return true;
        }
        return false;
    }

    public void clear() throws CoreException {
        this.index.accept(new IBTreeVisitor(){

            public int compare(int record) throws CoreException {
                return 0;
            }

            public boolean visit(int record) throws CoreException {
                new DBProperty(DBProperties.this.db, record).delete();
                return false;
            }
        });
    }

    public void delete() throws CoreException {
        this.clear();
        this.db.free(this.record);
    }

    public int getRecord() {
        return this.record;
    }

    private static class DBProperty {
        static final int KEY = 0;
        static final int VALUE = 4;
        static final int RECORD_SIZE = 8;
        Database db;
        int record;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.internal.core.pdom.db.DBProperties");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public int getRecord() {
            return this.record;
        }

        DBProperty(Database db, String key, String value) throws CoreException {
            if (!$assertionsDisabled && key == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && value == null) {
                throw new AssertionError();
            }
            IString dbkey = db.newString(key);
            IString dbvalue = db.newString(value);
            this.record = db.malloc(8);
            db.putInt(this.record + 0, dbkey.getRecord());
            db.putInt(this.record + 4, dbvalue.getRecord());
            this.db = db;
        }

        DBProperty(Database db, int record) {
            this.record = record;
            this.db = db;
        }

        public IString getKey() throws CoreException {
            return this.db.getString(this.db.getInt(this.record + 0));
        }

        public IString getValue() throws CoreException {
            return this.db.getString(this.db.getInt(this.record + 4));
        }

        public static IBTreeComparator getComparator(Database db) {
            return new IBTreeComparator(db){
                private final /* synthetic */ Database val$db;
                {
                    this.val$db = database;
                }

                public int compare(int record1, int record2) throws CoreException {
                    IString left = this.val$db.getString(this.val$db.getInt(record1 + 0));
                    IString right = this.val$db.getString(this.val$db.getInt(record2 + 0));
                    return left.compare(right, true);
                }
            };
        }

        public static DBProperty search(Database db, BTree index, String key) throws CoreException {
            DBProperty[] result = new DBProperty[1];
            index.accept(new IBTreeVisitor(db, key, result){
                private final /* synthetic */ Database val$db;
                private final /* synthetic */ String val$key;
                private final /* synthetic */ DBProperty[] val$result;
                {
                    this.val$db = database;
                    this.val$key = string;
                    this.val$result = dBPropertyArray;
                }

                public int compare(int record) throws CoreException {
                    return this.val$db.getString(this.val$db.getInt(record + 0)).compare(this.val$key, true);
                }

                public boolean visit(int record) throws CoreException {
                    this.val$result[0] = new DBProperty(this.val$db, record);
                    return false;
                }
            });
            return result[0];
        }

        public static Set getKeySet(Database db, BTree index) throws CoreException {
            HashSet result = new HashSet();
            index.accept(new IBTreeVisitor(result, db){
                private final /* synthetic */ Set val$result;
                private final /* synthetic */ Database val$db;
                {
                    this.val$result = set;
                    this.val$db = database;
                }

                public int compare(int record) throws CoreException {
                    return 0;
                }

                public boolean visit(int record) throws CoreException {
                    this.val$result.add(new DBProperty(this.val$db, record).getKey().getString());
                    return true;
                }
            });
            return result;
        }

        public void delete() throws CoreException {
            this.db.getString(this.db.getInt(this.record + 0)).delete();
            this.db.getString(this.db.getInt(this.record + 4)).delete();
            this.db.free(this.record);
        }
    }
}

