/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.db;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.core.pdom.db.Chunk;
import org.eclipse.cdt.internal.core.pdom.db.ChunkCache;
import org.eclipse.cdt.internal.core.pdom.db.DBStatus;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.cdt.internal.core.pdom.db.LongString;
import org.eclipse.cdt.internal.core.pdom.db.ShortString;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class Database {
    private final File location;
    private final RandomAccessFile file;
    private boolean fWritable = false;
    private boolean fPermanentlyReadOnly;
    private Chunk[] chunks;
    private long malloced;
    private long freed;
    private long cacheHits;
    private long cacheMisses;
    private ChunkCache fCache;
    public static final int VERSION_OFFSET = 0;
    public static final int CHUNK_SIZE = 4096;
    public static final int MIN_SIZE = 16;
    public static final int INT_SIZE = 4;
    public static final int CHAR_SIZE = 2;
    public static final int PREV_OFFSET = 4;
    public static final int NEXT_OFFSET = 8;
    public static final int DATA_AREA = 1028;
    public static final int MAX_SIZE = 4092;

    public Database(File location, ChunkCache cache, int version, boolean permanentlyReadOnly) throws CoreException {
        try {
            this.location = location;
            this.fPermanentlyReadOnly = permanentlyReadOnly;
            this.file = new RandomAccessFile(location, permanentlyReadOnly ? "r" : "rw");
            this.fCache = cache;
            long nChunks = this.file.length() / 4096L;
            this.chunks = new Chunk[(int)nChunks];
            if (nChunks == 0L) {
                if (!permanentlyReadOnly) {
                    this.setWritable();
                }
                this.createNewChunk();
                this.setVersion(version);
                this.setReadOnly(true);
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new DBStatus(e));
        }
    }

    public FileChannel getChannel() {
        return this.file.getChannel();
    }

    public int getVersion() throws CoreException {
        return this.getChunk(0).getInt(0);
    }

    public void setVersion(int version) throws CoreException {
        this.getChunk(0).putInt(0, version);
    }

    public void clear(long timeout) throws CoreException {
        int version = this.getVersion();
        this.removeChunksFromCache();
        Chunk header = this.getChunk(0);
        header.clear(0, 4096);
        this.setVersion(version);
        this.chunks = new Chunk[]{header};
        try {
            this.getChannel().truncate(4096L);
        }
        catch (IOException e) {
            CCorePlugin.log(e);
        }
        this.freed = 0L;
        this.malloced = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeChunksFromCache() {
        ChunkCache chunkCache = this.fCache;
        synchronized (chunkCache) {
            int i = 0;
            while (i < this.chunks.length) {
                Chunk chunk = this.chunks[i];
                if (chunk != null) {
                    this.fCache.remove(chunk);
                    this.chunks[i] = null;
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chunk getChunk(int offset) throws CoreException {
        int index = offset / 4096;
        Chunk chunk = this.chunks[index];
        if (chunk != null && (chunk.fLocked || !this.fWritable)) {
            chunk.fCacheHitFlag = true;
            ++this.cacheHits;
            return chunk;
        }
        ChunkCache chunkCache = this.fCache;
        synchronized (chunkCache) {
            chunk = this.chunks[index];
            if (chunk == null) {
                ++this.cacheMisses;
                chunk = this.chunks[index] = new Chunk(this, index);
                chunk.read();
            } else {
                ++this.cacheHits;
            }
            this.fCache.add(chunk, this.fWritable);
            return chunk;
        }
    }

    public int malloc(int size) throws CoreException {
        Chunk chunk;
        if (size > 4092) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", 0, CCorePlugin.getResourceString("pdom.requestTooLarge"), (Throwable)new IllegalArgumentException()));
        }
        int freeblock = 0;
        int matchsize = 0;
        int blocksize = 16;
        while (blocksize <= 4096) {
            if (blocksize - 4 >= size) {
                if (matchsize == 0) {
                    matchsize = blocksize;
                }
                if ((freeblock = this.getFirstBlock(blocksize)) != 0) break;
            }
            blocksize += 16;
        }
        if (freeblock == 0) {
            freeblock = this.createNewChunk();
            blocksize = 4096;
            chunk = this.getChunk(freeblock);
        } else {
            chunk = this.getChunk(freeblock);
            this.removeBlock(chunk, blocksize, freeblock);
        }
        if (blocksize != matchsize) {
            this.addBlock(chunk, blocksize - matchsize, freeblock + matchsize);
        }
        chunk.putInt(freeblock, -matchsize);
        chunk.clear(freeblock + 4, size);
        this.malloced += (long)matchsize;
        return freeblock + 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createNewChunk() throws CoreException {
        int oldLen = this.chunks.length;
        Chunk chunk = new Chunk(this, oldLen);
        chunk.fDirty = true;
        Chunk[] newchunks = new Chunk[oldLen + 1];
        ChunkCache chunkCache = this.fCache;
        synchronized (chunkCache) {
            System.arraycopy(this.chunks, 0, newchunks, 0, oldLen);
            newchunks[oldLen] = chunk;
            this.chunks = newchunks;
            this.fCache.add(chunk, true);
        }
        return oldLen * 4096;
    }

    private int getFirstBlock(int blocksize) throws CoreException {
        return this.getChunk(0).getInt(blocksize / 16 * 4);
    }

    private void setFirstBlock(int blocksize, int block) throws CoreException {
        this.getChunk(0).putInt(blocksize / 16 * 4, block);
    }

    private void removeBlock(Chunk chunk, int blocksize, int block) throws CoreException {
        int prevblock = chunk.getInt(block + 4);
        int nextblock = chunk.getInt(block + 8);
        if (prevblock != 0) {
            this.putInt(prevblock + 8, nextblock);
        } else {
            this.setFirstBlock(blocksize, nextblock);
        }
        if (nextblock != 0) {
            this.putInt(nextblock + 4, prevblock);
        }
    }

    private void addBlock(Chunk chunk, int blocksize, int block) throws CoreException {
        chunk.putInt(block, blocksize);
        int prevfirst = this.getFirstBlock(blocksize);
        chunk.putInt(block + 4, 0);
        chunk.putInt(block + 8, prevfirst);
        if (prevfirst != 0) {
            this.putInt(prevfirst + 4, block);
        }
        this.setFirstBlock(blocksize, block);
    }

    public void free(int offset) throws CoreException {
        int block = offset - 4;
        Chunk chunk = this.getChunk(block);
        int blocksize = -chunk.getInt(block);
        if (blocksize < 0) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", 0, "Already Freed", (Throwable)new Exception()));
        }
        this.addBlock(chunk, blocksize, block);
        this.freed += (long)blocksize;
    }

    public void putByte(int offset, byte value) throws CoreException {
        this.getChunk(offset).putByte(offset, value);
    }

    public byte getByte(int offset) throws CoreException {
        return this.getChunk(offset).getByte(offset);
    }

    public void putInt(int offset, int value) throws CoreException {
        this.getChunk(offset).putInt(offset, value);
    }

    public int getInt(int offset) throws CoreException {
        return this.getChunk(offset).getInt(offset);
    }

    public void putShort(int offset, short value) throws CoreException {
        this.getChunk(offset).putShort(offset, value);
    }

    public short getShort(int offset) throws CoreException {
        return this.getChunk(offset).getShort(offset);
    }

    public void putLong(int offset, long value) throws CoreException {
        this.getChunk(offset).putLong(offset, value);
    }

    public long getLong(int offset) throws CoreException {
        return this.getChunk(offset).getLong(offset);
    }

    public void putChar(int offset, char value) throws CoreException {
        this.getChunk(offset).putChar(offset, value);
    }

    public char getChar(int offset) throws CoreException {
        return this.getChunk(offset).getChar(offset);
    }

    public IString newString(String string) throws CoreException {
        if (string.length() > 2044) {
            return new LongString(this, string);
        }
        return new ShortString(this, string);
    }

    public IString newString(char[] chars) throws CoreException {
        if (chars.length > 2044) {
            return new LongString(this, chars);
        }
        return new ShortString(this, chars);
    }

    public IString getString(int offset) throws CoreException {
        int length = this.getInt(offset);
        if (length > 2044) {
            return new LongString(this, offset);
        }
        return new ShortString(this, offset);
    }

    public int getChunkCount() {
        return this.chunks.length;
    }

    public void reportFreeBlocks() throws CoreException {
        System.out.println("Allocated size: " + this.chunks.length * 4096);
        System.out.println("malloc'ed: " + this.malloced);
        System.out.println("free'd: " + this.freed);
        System.out.println("wasted: " + ((long)(this.chunks.length * 4096) - (this.malloced - this.freed)));
        System.out.println("Free blocks");
        int bs = 16;
        while (bs <= 4096) {
            int count = 0;
            int block = this.getFirstBlock(bs);
            while (block != 0) {
                ++count;
                block = this.getInt(block + 8);
            }
            if (count != 0) {
                System.out.println("Block size: " + bs + "=" + count);
            }
            bs += 16;
        }
    }

    public void close() throws CoreException {
        this.setReadOnly(true);
        this.removeChunksFromCache();
        this.chunks = new Chunk[0];
        try {
            this.file.close();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new DBStatus(e));
        }
    }

    public File getLocation() {
        return this.location;
    }

    void releaseChunk(Chunk chunk) {
        if (!chunk.fLocked) {
            this.chunks[chunk.fSequenceNumber] = null;
        }
    }

    public ChunkCache getChunkCache() {
        return this.fCache;
    }

    public void setWritable() {
        if (this.fPermanentlyReadOnly) {
            throw new IllegalStateException("A Database created as permanent-read-only may not be changed to writable state");
        }
        this.fWritable = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReadOnly(boolean flush) throws CoreException {
        if (this.fWritable) {
            this.fWritable = false;
            ArrayList<Chunk> dirtyChunks = new ArrayList<Chunk>();
            ChunkCache chunkCache = this.fCache;
            synchronized (chunkCache) {
                int i = this.chunks.length - 1;
                while (i >= 0) {
                    Chunk chunk = this.chunks[i];
                    if (chunk != null) {
                        if (chunk.fCacheIndex < 0) {
                            chunk.fLocked = false;
                            this.chunks[i] = null;
                            if (chunk.fDirty) {
                                dirtyChunks.add(chunk);
                            }
                        } else if (chunk.fLocked) {
                            if (!chunk.fDirty) {
                                chunk.fLocked = false;
                            } else if (flush) {
                                chunk.fLocked = false;
                                dirtyChunks.add(chunk);
                            }
                        } else if (flush && chunk.fDirty) {
                            dirtyChunks.add(chunk);
                        }
                    }
                    --i;
                }
            }
            if (!dirtyChunks.isEmpty()) {
                Iterator it = dirtyChunks.iterator();
                while (it.hasNext()) {
                    Chunk chunk = (Chunk)it.next();
                    chunk.flush();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void flush() throws CoreException {
        Chunk chunk;
        if (this.fWritable) {
            try {
                this.setReadOnly(true);
            }
            catch (Throwable throwable) {
                Object var1_3 = null;
                this.setWritable();
                throw throwable;
            }
            {
                Object var1_4 = null;
                this.setWritable();
                return;
            }
        }
        ArrayList<Chunk> dirtyChunks = new ArrayList<Chunk>();
        ChunkCache chunkCache = this.fCache;
        synchronized (chunkCache) {
            int i = this.chunks.length - 1;
            while (i >= 0) {
                chunk = this.chunks[i];
                if (chunk != null && chunk.fDirty) {
                    dirtyChunks.add(chunk);
                }
                --i;
            }
        }
        if (!dirtyChunks.isEmpty()) {
            Iterator it = dirtyChunks.iterator();
            while (it.hasNext()) {
                Chunk chunk2 = (Chunk)it.next();
                chunk2.flush();
            }
        }
        chunkCache = this.fCache;
        synchronized (chunkCache) {
            Iterator it = dirtyChunks.iterator();
            while (true) {
                if (!it.hasNext()) {
                    return;
                }
                chunk = (Chunk)it.next();
                chunk.fLocked = false;
                if (chunk.fCacheIndex >= 0) continue;
                this.chunks[chunk.fSequenceNumber] = null;
            }
        }
    }

    public void resetCacheCounters() {
        this.cacheMisses = 0L;
        this.cacheHits = 0L;
    }

    public long getCacheHits() {
        return this.cacheHits;
    }

    public long getCacheMisses() {
        return this.cacheMisses;
    }
}

