/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.db;

import java.util.NoSuchElementException;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.cdt.internal.core.pdom.db.ShortString;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.core.runtime.CoreException;

public class LongString
implements IString {
    private final Database db;
    private final int record1;
    private static final int LENGTH = 0;
    private static final int NEXT1 = 4;
    private static final int CHARS1 = 8;
    private static final int NUM_CHARS1 = 2042;
    private static final int NEXTN = 0;
    private static final int CHARSN = 4;
    private static final int NUM_CHARSN = 2044;

    public LongString(Database db, int record1) {
        this.db = db;
        this.record1 = record1;
    }

    private int createString(int length, IWriter writer) throws CoreException {
        int firstRecord = this.db.malloc(4092);
        int start = 0;
        this.db.putInt(firstRecord, length);
        writer.writeChars(start, 2042, firstRecord + 8);
        int lastNext = firstRecord + 4;
        start += 2042;
        while (length - start > 2044) {
            int nextRecord = this.db.malloc(4092);
            this.db.putInt(lastNext, nextRecord);
            writer.writeChars(start, 2044, nextRecord + 4);
            start += 2044;
            lastNext = nextRecord + 0;
        }
        int finalRecord = this.db.malloc(4 + (length -= start) * 2);
        this.db.putInt(lastNext, finalRecord);
        writer.writeChars(start, length, finalRecord + 4);
        return firstRecord;
    }

    public LongString(Database db, final String string) throws CoreException {
        this.db = db;
        this.record1 = this.createString(string.length(), new IWriter(){

            public void writeChars(int start, int length, int p) throws CoreException {
                int i = start;
                while (i < start + length) {
                    LongString.this.db.putChar(p, string.charAt(i));
                    p += 2;
                    ++i;
                }
            }
        });
    }

    public LongString(Database db, final char[] chars) throws CoreException {
        this.db = db;
        this.record1 = this.createString(chars.length, new IWriter(){

            public void writeChars(int start, int length, int p) throws CoreException {
                int i = start;
                while (i < start + length) {
                    LongString.this.db.putChar(p, chars[i]);
                    p += 2;
                    ++i;
                }
            }
        });
    }

    public int getRecord() {
        return this.record1;
    }

    public void delete() throws CoreException {
        int length = this.db.getInt(this.record1 + 0) - 2042;
        int nextRecord = this.db.getInt(this.record1 + 4);
        this.db.free(this.record1);
        while (length > 2044) {
            length -= 2044;
            int nextnext = this.db.getInt(nextRecord + 0);
            this.db.free(nextRecord);
            nextRecord = nextnext;
        }
        this.db.free(nextRecord);
    }

    public boolean equals(Object obj) {
        throw new PDOMNotImplementedError();
    }

    public int hashCode() {
        return this.record1;
    }

    public int compare(IString string, boolean caseSensitive) throws CoreException {
        if (string instanceof LongString) {
            return this.compare((LongString)string, caseSensitive);
        }
        if (string instanceof ShortString) {
            return this.compare((ShortString)string, caseSensitive);
        }
        throw new IllegalArgumentException();
    }

    public int compare(char[] other, boolean caseSensitive) throws CoreException {
        CharIterator i1 = new CharIterator();
        int i2 = 0;
        int n2 = other.length;
        while (i1.hasNext() && i2 < n2) {
            int cmp = ShortString.compareChars(i1.next(), other[i2], caseSensitive);
            if (cmp != 0) {
                return cmp;
            }
            ++i2;
        }
        if (!i1.hasNext() && i2 != n2) {
            return -1;
        }
        if (i2 == n2 && i1.hasNext()) {
            return 1;
        }
        return 0;
    }

    public int compare(ShortString other, boolean caseSensitive) throws CoreException {
        CharIterator i1 = new CharIterator();
        int index2 = 0;
        int length2 = other.getLength();
        while (i1.hasNext() && index2 < length2) {
            int cmp = ShortString.compareChars(i1.next(), other.charAt(index2), caseSensitive);
            if (cmp != 0) {
                return cmp;
            }
            ++index2;
        }
        if (!i1.hasNext() && index2 != length2) {
            return -1;
        }
        if (index2 == length2 && i1.hasNext()) {
            return 1;
        }
        return 0;
    }

    public int compare(LongString other, boolean caseSensitive) throws CoreException {
        CharIterator i1 = new CharIterator();
        CharIterator i2 = other.new CharIterator();
        while (i1.hasNext() && i2.hasNext()) {
            int cmp = ShortString.compareChars(i1.next(), i2.next(), caseSensitive);
            if (cmp == 0) continue;
            return cmp;
        }
        if (!i1.hasNext() && i2.hasNext()) {
            return -1;
        }
        if (!i2.hasNext() && i1.hasNext()) {
            return 1;
        }
        return 0;
    }

    public int compare(String other, boolean caseSensitive) throws CoreException {
        CharIterator i1 = new CharIterator();
        int i2 = 0;
        int n2 = other.length();
        while (i1.hasNext() && i2 < n2) {
            int cmp = ShortString.compareChars(i1.next(), other.charAt(i2), caseSensitive);
            if (cmp != 0) {
                return cmp;
            }
            ++i2;
        }
        if (!i1.hasNext() && i2 != n2) {
            return -1;
        }
        if (i2 == n2 && i1.hasNext()) {
            return 1;
        }
        return 0;
    }

    public int comparePrefix(char[] other, boolean caseSensitive) throws CoreException {
        CharIterator i1 = new CharIterator();
        int i2 = 0;
        int n2 = other.length;
        while (i1.hasNext() && i2 < n2) {
            int cmp = ShortString.compareChars(i1.next(), other[i2], caseSensitive);
            if (cmp != 0) {
                return cmp;
            }
            ++i2;
        }
        if (!i1.hasNext() && i2 != n2) {
            return -1;
        }
        return 0;
    }

    private void readChars(int length, IReader reader) throws CoreException {
        int i;
        int p = this.record1 + 8;
        int i2 = 0;
        while (i2 < 2042) {
            reader.appendChar(this.db.getChar(p));
            p += 2;
            ++i2;
        }
        length -= 2042;
        int nextRecord = this.db.getInt(this.record1 + 4);
        while (length > 2044) {
            p = nextRecord + 4;
            i = 0;
            while (i < 2044) {
                reader.appendChar(this.db.getChar(p));
                p += 2;
                ++i;
            }
            length -= 2044;
            nextRecord = this.db.getInt(nextRecord + 0);
        }
        p = nextRecord + 4;
        i = 0;
        while (i < length) {
            reader.appendChar(this.db.getChar(p));
            p += 2;
            ++i;
        }
    }

    public char[] getChars() throws CoreException {
        int length = this.db.getInt(this.record1 + 0);
        final char[] chars = new char[length];
        this.readChars(length, new IReader(){
            int cp = 0;

            public void appendChar(char c) {
                chars[this.cp++] = c;
            }
        });
        return chars;
    }

    public String getString() throws CoreException {
        int length = this.db.getInt(this.record1 + 0);
        final StringBuffer buffer = new StringBuffer(length);
        this.readChars(length, new IReader(){

            public void appendChar(char c) {
                buffer.append(c);
            }
        });
        return buffer.toString();
    }

    private class CharIterator {
        int p;
        int count;
        int length;

        public CharIterator() throws CoreException {
            this.p = LongString.this.record1 + 8;
            this.length = LongString.this.db.getInt(LongString.this.record1 + 0);
        }

        public char next() throws CoreException {
            char result = LongString.this.db.getChar(this.p);
            this.p += 2;
            ++this.count;
            if (this.count > this.length) {
                throw new NoSuchElementException();
            }
            if (this.count == 2042) {
                this.p = LongString.this.db.getInt(LongString.this.record1 + 4) + 4;
            }
            if (this.count > 2042 && (this.count - 2042) % 2044 == 0) {
                this.p = LongString.this.db.getInt(LongString.this.record1 + 0) + 4;
            }
            return result;
        }

        public boolean hasNext() {
            return this.count < this.length;
        }
    }

    private static interface IReader {
        public void appendChar(char var1);
    }

    private static interface IWriter {
        public void writeChars(int var1, int var2, int var3) throws CoreException;
    }
}

