/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.core.runtime.CoreException;

public abstract class PDOMNode
implements IPDOMNode {
    private static final int TYPE = 0;
    private static final int PARENT = 4;
    protected static final int RECORD_SIZE = 8;
    protected final PDOM pdom;
    protected final int record;

    protected PDOMNode(PDOM pdom, int record) {
        this.pdom = pdom;
        this.record = record;
    }

    protected PDOMNode(PDOM pdom, PDOMNode parent) throws CoreException {
        this.pdom = pdom;
        Database db = pdom.getDB();
        this.record = db.malloc(this.getRecordSize());
        db.putInt(this.record + 0, this.getNodeType());
        db.putInt(this.record + 4, parent != null ? parent.getRecord() : 0);
    }

    protected abstract int getRecordSize();

    public abstract int getNodeType();

    public PDOM getPDOM() {
        return this.pdom;
    }

    public int getRecord() {
        return this.record;
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PDOMNode) {
            PDOMNode other = (PDOMNode)obj;
            return this.pdom == other.pdom && this.record == other.record;
        }
        return super.equals(obj);
    }

    public final int hashCode() {
        return System.identityHashCode(this.pdom) + 41 * this.record;
    }

    public void accept(IPDOMVisitor visitor) throws CoreException {
    }

    public static int getNodeType(PDOM pdom, int record) throws CoreException {
        return pdom.getDB().getInt(record + 0);
    }

    public PDOMNode getParentNode() throws CoreException {
        int parentrec = this.pdom.getDB().getInt(this.record + 4);
        return parentrec != 0 ? this.getLinkageImpl().getNode(parentrec) : null;
    }

    public ILinkage getLinkage() throws CoreException {
        return PDOMNode.getLinkage(this.pdom, this.record);
    }

    public PDOMLinkage getLinkageImpl() throws CoreException {
        return PDOMNode.getLinkage(this.pdom, this.record);
    }

    public static PDOMLinkage getLinkage(PDOM pdom, int record) throws CoreException {
        Database db = pdom.getDB();
        int linkagerec = record;
        int parentrec = db.getInt(linkagerec + 4);
        while (parentrec != 0) {
            linkagerec = parentrec;
            parentrec = db.getInt(linkagerec + 4);
        }
        return pdom.getLinkage(linkagerec);
    }

    public void addChild(PDOMNode child) throws CoreException {
    }

    protected byte getByte(int offset) {
        try {
            return this.pdom.getDB().getByte(offset);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return 0;
        }
    }

    protected int getInt(int offset) {
        try {
            return this.pdom.getDB().getInt(offset);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return 0;
        }
    }

    protected boolean getBit(int bitVector, int offset) {
        int mask = 1 << offset;
        return (bitVector & mask) == mask;
    }
}

