/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.c;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.internal.core.index.IIndexType;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCEnumerator;
import org.eclipse.core.runtime.CoreException;

class PDOMCEnumeration
extends PDOMBinding
implements IEnumeration,
IIndexType {
    private static final int FIRST_ENUMERATOR = 24;
    protected static final int RECORD_SIZE = 28;

    public PDOMCEnumeration(PDOM pdom, PDOMNode parent, IEnumeration enumeration) throws CoreException {
        super(pdom, parent, enumeration.getNameCharArray());
    }

    public PDOMCEnumeration(PDOM pdom, int record) {
        super(pdom, record);
    }

    protected int getRecordSize() {
        return 28;
    }

    public int getNodeType() {
        return 9;
    }

    public IEnumerator[] getEnumerators() throws DOMException {
        try {
            ArrayList<PDOMCEnumerator> enums = new ArrayList<PDOMCEnumerator>();
            PDOMCEnumerator enumerator = this.getFirstEnumerator();
            while (enumerator != null) {
                enums.add(enumerator);
                enumerator = enumerator.getNextEnumerator();
            }
            IEnumerator[] enumerators = enums.toArray(new IEnumerator[enums.size()]);
            int n = enumerators.length;
            int i = 0;
            while (i < n / 2) {
                IEnumerator tmp = enumerators[i];
                enumerators[i] = enumerators[n - 1 - i];
                enumerators[n - 1 - i] = tmp;
                ++i;
            }
            return enumerators;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new IEnumerator[0];
        }
    }

    private PDOMCEnumerator getFirstEnumerator() throws CoreException {
        int value = this.pdom.getDB().getInt(this.record + 24);
        return value != 0 ? new PDOMCEnumerator(this.pdom, value) : null;
    }

    public void addEnumerator(PDOMCEnumerator enumerator) throws CoreException {
        PDOMCEnumerator first = this.getFirstEnumerator();
        enumerator.setNextEnumerator(first);
        this.pdom.getDB().putInt(this.record + 24, enumerator.getRecord());
    }

    public boolean isSameType(IType type) {
        PDOMNode node;
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        if (type instanceof PDOMNode && (node = (PDOMNode)((Object)type)).getPDOM() == this.getPDOM()) {
            return node.getRecord() == this.getRecord();
        }
        if (type instanceof IEnumeration) {
            IEnumeration etype = (IEnumeration)type;
            try {
                return this.getDBName().equals(etype.getNameCharArray());
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        }
        return false;
    }

    public Object clone() {
        throw new PDOMNotImplementedError();
    }
}

