/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.c;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.c.ICCompositeTypeScope;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.index.IIndexScope;
import org.eclipse.cdt.internal.core.index.IIndexType;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.PDOMNodeLinkedList;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMMemberOwner;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;

public class PDOMCStructure
extends PDOMBinding
implements ICompositeType,
ICCompositeTypeScope,
IPDOMMemberOwner,
IIndexType,
IIndexScope {
    private static final int MEMBERLIST = 24;
    private static final int KEY = 28;
    protected static final int RECORD_SIZE = 32;

    public PDOMCStructure(PDOM pdom, PDOMNode parent, ICompositeType compType) throws CoreException {
        super(pdom, parent, compType.getNameCharArray());
        try {
            pdom.getDB().putByte(this.record + 28, (byte)compType.getKey());
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus(e));
        }
    }

    public PDOMCStructure(PDOM pdom, int record) {
        super(pdom, record);
    }

    public void accept(IPDOMVisitor visitor) throws CoreException {
        super.accept(visitor);
        new PDOMNodeLinkedList(this.pdom, this.record + 24, this.getLinkageImpl()).accept(visitor);
    }

    public void addMember(PDOMNode member) throws CoreException {
        new PDOMNodeLinkedList(this.pdom, this.record + 24, this.getLinkageImpl()).addMember(member);
    }

    public int getNodeType() {
        return 7;
    }

    public Object clone() {
        throw new PDOMNotImplementedError();
    }

    public int getKey() throws DOMException {
        try {
            return this.pdom.getDB().getByte(this.record + 28);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return 1;
        }
    }

    public IField[] getFields() throws DOMException {
        try {
            GetFields fields = new GetFields();
            this.accept(fields);
            return fields.getFields();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new IField[0];
        }
    }

    public IField findField(String name) throws DOMException {
        String key = this.pdom.createKeyForCache(this.record, name.toCharArray());
        IField result = (IField)this.pdom.getCachedResult(key);
        if (result != null) {
            return result;
        }
        FindField visitor = new FindField(name);
        try {
            this.accept(visitor);
            return null;
        }
        catch (CoreException e) {
            if (!e.getStatus().equals(Status.OK_STATUS)) {
                CCorePlugin.log(e);
                return null;
            }
            result = visitor.getField();
            if (result != null) {
                this.pdom.putCachedResult(key, result);
            }
            return result;
        }
    }

    public IScope getCompositeScope() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean isSameType(IType type) {
        PDOMNode node;
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        if (type instanceof PDOMNode && (node = (PDOMNode)((Object)type)).getPDOM() == this.getPDOM()) {
            return node.getRecord() == this.getRecord();
        }
        if (type instanceof ICompositeType) {
            ICompositeType etype = (ICompositeType)type;
            try {
                return this.getDBName().equals(etype.getNameCharArray());
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        }
        return false;
    }

    protected int getRecordSize() {
        return 32;
    }

    public void addChild(PDOMNode member) throws CoreException {
        this.addMember(member);
    }

    public boolean mayHaveChildren() {
        return true;
    }

    public ICompositeType getCompositeType() {
        return this;
    }

    public IBinding getBinding(char[] name) throws DOMException {
        this.fail();
        return null;
    }

    public IBinding getBinding(IASTName name, boolean resolve) throws DOMException {
        this.fail();
        return null;
    }

    public IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup) throws DOMException {
        this.fail();
        return null;
    }

    public IBinding[] find(String name) throws DOMException {
        this.fail();
        return null;
    }

    public IIndexBinding getScopeBinding() {
        return this;
    }

    public static class FindField
    implements IPDOMVisitor {
        private IField field;
        private final String name;

        public FindField(String name) {
            this.name = name;
        }

        public boolean visit(IPDOMNode node) throws CoreException {
            IField tField;
            if (node instanceof IField && this.name.equals((tField = (IField)((Object)node)).getName())) {
                this.field = tField;
                throw new CoreException(Status.OK_STATUS);
            }
            return false;
        }

        public void leave(IPDOMNode node) throws CoreException {
        }

        public IField getField() {
            return this.field;
        }
    }

    private static class GetFields
    implements IPDOMVisitor {
        private List fields = new ArrayList();

        private GetFields() {
        }

        public boolean visit(IPDOMNode node) throws CoreException {
            if (node instanceof IField) {
                this.fields.add(node);
            }
            return false;
        }

        public void leave(IPDOMNode node) throws CoreException {
        }

        public IField[] getFields() {
            return this.fields.toArray(new IField[this.fields.size()]);
        }
    }
}

