/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPDelegate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDelegateCreator;
import org.eclipse.cdt.internal.core.index.IndexCPPSignatureUtil;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMOverloader;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPAnnotation;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBinding;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPFunctionType;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPParameter;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPFunction
extends PDOMCPPBinding
implements ICPPFunction,
IPDOMOverloader,
ICPPDelegateCreator {
    private static final int NUM_PARAMS = 24;
    private static final int FIRST_PARAM = 28;
    protected static final int FUNCTION_TYPE = 32;
    private static final int SIGNATURE_MEMENTO = 36;
    protected static final int ANNOTATION = 40;
    protected static final int RECORD_SIZE = 41;

    public PDOMCPPFunction(PDOM pdom, PDOMNode parent, ICPPFunction function, boolean setTypes) throws CoreException {
        super(pdom, parent, function.getNameCharArray());
        Database db = pdom.getDB();
        try {
            Integer memento = IndexCPPSignatureUtil.getSignatureMemento(function);
            pdom.getDB().putInt(this.record + 36, memento != null ? memento : 0);
            if (setTypes) {
                this.initData(function);
            }
            db.putByte(this.record + 40, PDOMCPPAnnotation.encodeAnnotation(function));
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus(e));
        }
    }

    public void initData(ICPPFunction function) throws CoreException, DOMException {
        Database db = this.pdom.getDB();
        ICPPFunctionType ft = (ICPPFunctionType)function.getType();
        PDOMCPPFunctionType pft = (PDOMCPPFunctionType)this.getLinkageImpl().addType(this, ft);
        db.putInt(this.record + 32, pft.getRecord());
        IParameter[] params = function.getParameters();
        db.putInt(this.record + 24, params.length);
        IType[] paramTypes = pft.getParameterTypes();
        int i = 0;
        while (i < params.length) {
            int ptRecord = i < paramTypes.length && paramTypes[i] != null ? ((PDOMNode)((Object)paramTypes[i])).getRecord() : 0;
            this.setFirstParameter(new PDOMCPPParameter(this.pdom, (PDOMNode)this, params[i], ptRecord));
            ++i;
        }
    }

    public int getSignatureMemento() throws CoreException {
        return this.pdom.getDB().getInt(this.record + 36);
    }

    public static int getSignatureMemento(PDOM pdom, int record) throws CoreException {
        return pdom.getDB().getInt(record + 36);
    }

    public PDOMCPPFunction(PDOM pdom, int bindingRecord) {
        super(pdom, bindingRecord);
    }

    protected int getRecordSize() {
        return 41;
    }

    public int getNodeType() {
        return 6;
    }

    public PDOMCPPParameter getFirstParameter() throws CoreException {
        int rec = this.pdom.getDB().getInt(this.record + 28);
        return rec != 0 ? new PDOMCPPParameter(this.pdom, rec) : null;
    }

    public void setFirstParameter(PDOMCPPParameter param) throws CoreException {
        if (param != null) {
            param.setNextParameter(this.getFirstParameter());
        }
        int rec = param != null ? param.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 28, rec);
    }

    public boolean isInline() throws DOMException {
        return this.getBit(this.getByte(this.record + 40), 2);
    }

    public boolean isMutable() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public IScope getFunctionScope() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public IParameter[] getParameters() throws DOMException {
        try {
            int n = this.pdom.getDB().getInt(this.record + 24);
            IParameter[] params = new IParameter[n];
            PDOMCPPParameter param = this.getFirstParameter();
            while (param != null) {
                params[--n] = param;
                param = param.getNextParameter();
            }
            return params;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new IParameter[0];
        }
    }

    public IFunctionType getType() throws DOMException {
        try {
            int offset = this.pdom.getDB().getInt(this.record + 32);
            return offset == 0 ? null : new PDOMCPPFunctionType(this.pdom, offset);
        }
        catch (CoreException ce) {
            CCorePlugin.log(ce);
            return null;
        }
    }

    public boolean isAuto() throws DOMException {
        return false;
    }

    public boolean isExtern() throws DOMException {
        return this.getBit(this.getByte(this.record + 40), 1);
    }

    public boolean isRegister() throws DOMException {
        return false;
    }

    public boolean isStatic() throws DOMException {
        return this.getBit(this.getByte(this.record + 40), 4);
    }

    public boolean takesVarArgs() throws DOMException {
        return this.getBit(this.getByte(this.record + 40), 5);
    }

    public Object clone() {
        throw new PDOMNotImplementedError();
    }

    public int pdomCompareTo(PDOMBinding other) {
        int cmp = super.pdomCompareTo(other);
        return cmp == 0 ? PDOMCPPFunction.compareSignatures(this, other) : cmp;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        try {
            result.append(String.valueOf(this.getName()) + " " + ASTTypeUtil.getParameterTypeString(this.getType()));
            result.append(" " + this.getNodeType());
        }
        catch (DOMException de) {
            result.append(de);
        }
        return result.toString();
    }

    protected static int compareSignatures(IPDOMOverloader a, Object b) {
        if (b instanceof IPDOMOverloader) {
            IPDOMOverloader bb = (IPDOMOverloader)b;
            try {
                int mySM = a.getSignatureMemento();
                int otherSM = bb.getSignatureMemento();
                return mySM == otherSM ? 0 : (mySM < otherSM ? -1 : 1);
            }
            catch (CoreException ce) {
                CCorePlugin.log(ce);
            }
        } else {
            throw new PDOMNotImplementedError(b.getClass().toString());
        }
        return 0;
    }

    public ICPPDelegate createDelegate(IASTName name) {
        return new CPPFunction.CPPFunctionDelegate(name, this);
    }
}

