/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTypeParameter;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.index.IIndexInternalTemplateParameter;
import org.eclipse.cdt.internal.core.index.IIndexType;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBinding;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPTemplateTypeParameter
extends PDOMCPPBinding
implements ICPPTemplateTypeParameter,
IIndexType,
IIndexInternalTemplateParameter {
    private static final int DEFAULT_TYPE = 24;
    protected static final int RECORD_SIZE = 28;

    public PDOMCPPTemplateTypeParameter(PDOM pdom, PDOMNode parent, ICPPTemplateTypeParameter param) throws CoreException {
        super(pdom, parent, param.getNameCharArray());
        try {
            PDOMNode typeNode;
            IType dflt = param.getDefault();
            if (dflt != null && (typeNode = this.getLinkageImpl().addType(this, dflt)) != null) {
                pdom.getDB().putInt(this.record + 24, typeNode.getRecord());
            }
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus(e));
        }
    }

    public PDOMCPPTemplateTypeParameter(PDOM pdom, int bindingRecord) {
        super(pdom, bindingRecord);
    }

    protected int getRecordSize() {
        return 28;
    }

    public int getNodeType() {
        return 42;
    }

    public boolean isSameType(IType type) {
        PDOMNode node;
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        if (type instanceof PDOMNode && (node = (PDOMNode)((Object)type)).getPDOM() == this.getPDOM()) {
            return node.getRecord() == this.getRecord();
        }
        if (type instanceof ICPPTemplateTypeParameter && !(type instanceof ProblemBinding)) {
            ICPPTemplateTypeParameter ttp = (ICPPTemplateTypeParameter)type;
            try {
                char[][] ttpName = ttp.getQualifiedNameCharArray();
                return this.hasQualifiedName(ttpName, ttpName.length - 1);
            }
            catch (DOMException e) {
                CCorePlugin.log(e);
            }
        }
        return false;
    }

    public IType getDefault() throws DOMException {
        try {
            PDOMNode node = this.getLinkageImpl().getNode(this.pdom.getDB().getInt(this.record + 24));
            if (node instanceof IType) {
                return (IType)((Object)node);
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return null;
    }

    public ICPPBinding getParameterOwner() throws CoreException {
        return (ICPPBinding)((Object)this.getParentBinding());
    }

    public Object clone() {
        this.fail();
        return null;
    }
}

