/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.core.runtime.CoreException;

class PDOMClassUtil {
    PDOMClassUtil() {
    }

    static class ConstructorCollector
    implements IPDOMVisitor {
        private List fConstructors = new ArrayList();

        ConstructorCollector() {
        }

        public boolean visit(IPDOMNode node) throws CoreException {
            if (node instanceof ICPPConstructor) {
                this.fConstructors.add(node);
            }
            return false;
        }

        public void leave(IPDOMNode node) throws CoreException {
        }

        public ICPPConstructor[] getConstructors() {
            return this.fConstructors.toArray(new ICPPConstructor[this.fConstructors.size()]);
        }
    }

    static class FieldCollector
    implements IPDOMVisitor {
        private List fields = new ArrayList();

        FieldCollector() {
        }

        public boolean visit(IPDOMNode node) throws CoreException {
            if (node instanceof ICPPField) {
                this.fields.add(node);
            }
            return false;
        }

        public void leave(IPDOMNode node) throws CoreException {
        }

        public ICPPField[] getFields() {
            return this.fields.toArray(new ICPPField[this.fields.size()]);
        }
    }

    static class MethodCollector
    implements IPDOMVisitor {
        private final List methods = new ArrayList();
        private final boolean acceptImplicit;
        private final boolean acceptAll;

        public MethodCollector(boolean acceptImplicit) {
            this(acceptImplicit, true);
        }

        public MethodCollector(boolean acceptImplicit, boolean acceptExplicit) {
            this.acceptImplicit = acceptImplicit;
            this.acceptAll = acceptImplicit && acceptExplicit;
        }

        public boolean visit(IPDOMNode node) throws CoreException {
            if (node instanceof ICPPMethod && (this.acceptAll || ((ICPPMethod)((Object)node)).isImplicit() == this.acceptImplicit)) {
                this.methods.add(node);
            }
            return false;
        }

        public void leave(IPDOMNode node) throws CoreException {
        }

        public ICPPMethod[] getMethods() {
            return this.methods.toArray(new ICPPMethod[this.methods.size()]);
        }
    }
}

