/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.export;

import java.io.File;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.cdt.core.index.export.IExportProjectProvider;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.internal.core.CCoreInternals;
import org.eclipse.cdt.internal.core.pdom.WritablePDOM;
import org.eclipse.cdt.internal.core.pdom.export.GeneratePDOMApplication;
import org.eclipse.cdt.internal.core.pdom.export.Messages;
import org.eclipse.cdt.internal.core.pdom.indexer.IndexerPreferences;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.NullProgressMonitor;

public class GeneratePDOM
implements ISafeRunnable {
    protected IExportProjectProvider pm;
    protected String[] applicationArguments;
    protected File targetLocation;
    protected String indexerID;

    public GeneratePDOM(IExportProjectProvider pm, String[] applicationArguments, File targetLocation, String indexerID) {
        this.pm = pm;
        this.applicationArguments = applicationArguments;
        this.targetLocation = targetLocation;
        this.indexerID = indexerID;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void run() throws CoreException {
        IIndexLocationConverter converter;
        this.pm.setApplicationArguments(this.applicationArguments);
        ICProject cproject = this.pm.createProject();
        if (cproject == null) {
            this.fail(MessageFormat.format(Messages.GeneratePDOM_ProjectProviderReturnedNullCProject, this.pm.getClass().getName()));
        }
        if ((converter = this.pm.getLocationConverter(cproject)) == null) {
            this.fail(MessageFormat.format(Messages.GeneratePDOM_NullLocationConverter, this.pm.getClass().getName()));
        }
        IndexerPreferences.set(cproject.getProject(), "indexerId", this.indexerID);
        CCorePlugin.getIndexManager().joinIndexer(Integer.MAX_VALUE, (IProgressMonitor)new NullProgressMonitor());
        try {
            CCoreInternals.getPDOMManager().exportProjectPDOM(cproject, this.targetLocation, converter);
            WritablePDOM exportedPDOM = new WritablePDOM(this.targetLocation, converter, LanguageManager.getInstance().getPDOMLinkageFactoryMappings());
            try {
                exportedPDOM.acquireWriteLock(0);
                try {
                    Map exportProperties = this.pm.getExportProperties();
                    if (exportProperties != null) {
                        Iterator i = exportProperties.entrySet().iterator();
                        while (i.hasNext()) {
                            Map.Entry entry = i.next();
                            exportedPDOM.setProperty((String)entry.getKey(), (String)entry.getValue());
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    exportedPDOM.releaseWriteLock(0, true);
                    throw throwable;
                }
                {
                    Object var7_11 = null;
                    exportedPDOM.releaseWriteLock(0, true);
                }
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                exportedPDOM.close();
                throw throwable;
            }
            {
                Object var9_14 = null;
                exportedPDOM.close();
                return;
            }
        }
        catch (InterruptedException ie) {
            String msg = MessageFormat.format(Messages.GeneratePDOM_GenericGenerationFailed, ie.getMessage());
            throw new CoreException(CCorePlugin.createStatus(msg, ie));
        }
    }

    public void handleException(Throwable exception) {
        CCorePlugin.log(exception);
    }

    private void fail(String message) throws CoreException {
        GeneratePDOMApplication.fail(message);
    }
}

