/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.indexer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.pdom.indexer.TranslationUnitCollector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class DeltaAnalyzer {
    private List fAdded = new ArrayList();
    private List fChanged = new ArrayList();
    private List fRemoved = new ArrayList();

    public void analyzeDelta(ICElementDelta delta) throws CoreException {
        this.processDelta(delta);
    }

    private void processDelta(ICElementDelta delta) throws CoreException {
        int flags = delta.getFlags();
        if ((flags & 8) != 0) {
            ICElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                this.processDelta(children[i]);
                ++i;
            }
        }
        ICElement element = delta.getElement();
        switch (element.getElementType()) {
            case 60: {
                ITranslationUnit tu = (ITranslationUnit)element;
                if (tu.isWorkingCopy()) break;
                switch (delta.getKind()) {
                    case 4: {
                        if ((flags & 1) == 0) break;
                        this.fChanged.add(tu);
                        break;
                    }
                    case 1: {
                        this.fAdded.add(tu);
                        break;
                    }
                    case 2: {
                        this.fRemoved.add(tu);
                    }
                }
                break;
            }
            case 12: {
                ICContainer folder = (ICContainer)element;
                if (delta.getKind() != 1) break;
                this.collectSources(folder, this.fAdded);
            }
        }
    }

    private void collectSources(ICContainer container, Collection sources) throws CoreException {
        container.accept(new TranslationUnitCollector(sources, sources, true, (IProgressMonitor)new NullProgressMonitor()));
    }

    public ITranslationUnit[] getAddedTUs() {
        return this.fAdded.toArray(new ITranslationUnit[this.fAdded.size()]);
    }

    public ITranslationUnit[] getChangedTUs() {
        return this.fChanged.toArray(new ITranslationUnit[this.fChanged.size()]);
    }

    public ITranslationUnit[] getRemovedTUs() {
        return this.fRemoved.toArray(new ITranslationUnit[this.fRemoved.size()]);
    }
}

