/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.extension.CLanguageData;
import org.eclipse.cdt.core.settings.model.extension.impl.CDefaultLanguageData;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.core.settings.model.util.EntryStore;
import org.eclipse.cdt.core.settings.model.util.KindBasedStore;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationDescription;
import org.eclipse.cdt.internal.core.settings.model.CDataProxy;
import org.eclipse.cdt.internal.core.settings.model.CDataProxyContainer;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettingsManager;

public class CLanguageSetting
extends CDataProxy
implements ICLanguageSetting {
    CLanguageSetting(CLanguageData data, CDataProxyContainer parent, CConfigurationDescription cfg) {
        super(data, parent, cfg);
    }

    public final int getType() {
        return 16;
    }

    public String getLanguageId() {
        CLanguageData data = this.getCLanguageData(false);
        return data.getLanguageId();
    }

    public void setLanguageId(String id) {
        CLanguageData data = this.getCLanguageData(true);
        data.setLanguageId(id);
    }

    private CLanguageData getCLanguageData(boolean write) {
        return (CLanguageData)this.getData(write);
    }

    public ICLanguageSettingEntry[] getSettingEntries(int kind) {
        CLanguageData data = this.getCLanguageData(false);
        return data.getEntries(kind);
    }

    public List getSettingEntriesList(int kind) {
        CLanguageData data = this.getCLanguageData(false);
        ICLanguageSettingEntry[] entries = data.getEntries(kind);
        int size = entries != null ? entries.length : 0;
        ArrayList<ICLanguageSettingEntry> arrayList = new ArrayList<ICLanguageSettingEntry>(size);
        int i = 0;
        while (i < size) {
            arrayList.add(entries[i]);
            ++i;
        }
        return arrayList;
    }

    public String[] getSourceContentTypeIds() {
        CLanguageData data = this.getCLanguageData(false);
        String[] ids = data.getSourceContentTypeIds();
        if (ids != null) {
            return ids;
        }
        return CDefaultLanguageData.EMPTY_STRING_ARRAY;
    }

    public int getSupportedEntryKinds() {
        CLanguageData data = this.getCLanguageData(false);
        return data.getSupportedEntryKinds();
    }

    public boolean supportsEntryKind(int kind) {
        return (this.getSupportedEntryKinds() & kind) == kind;
    }

    public String[] getSourceExtensions() {
        CLanguageData data = this.getCLanguageData(false);
        return CDataUtil.getSourceExtensions(this.getProject(), data);
    }

    public void setSettingEntries(int kind, ICLanguageSettingEntry[] entries) {
        CLanguageData data = this.getCLanguageData(true);
        EntryStore store = new EntryStore();
        if (entries != null) {
            if (entries.length != 0) {
                int i = 0;
                while (i < entries.length) {
                    ICLanguageSettingEntry entry = entries[i];
                    int eKind = entry.getKind();
                    if ((kind & eKind) != 0 && (data.getSupportedEntryKinds() & eKind) != 0) {
                        store.addEntry(entry);
                    }
                    ++i;
                }
            } else {
                int[] kinds = KindBasedStore.getLanguageEntryKinds();
                int i = 0;
                while (i < kinds.length) {
                    if ((kinds[i] & kind) != 0) {
                        store.storeEntries(kinds[i], new ICLanguageSettingEntry[0]);
                    }
                    ++i;
                }
            }
        }
        this.setSettingEntries(kind, data, store);
    }

    private int[] flagsToArray(int flags) {
        int[] arr = new int[32];
        int num = 0;
        int i = 1;
        while (i != 0) {
            if ((flags & i) != 0) {
                arr[num++] = i;
            }
            i <<= 1;
        }
        if (num == arr.length) {
            return arr;
        }
        if (num == 0) {
            return new int[0];
        }
        int[] result = new int[num];
        System.arraycopy(arr, 0, result, 0, num);
        return result;
    }

    public void setSettingEntries(int kind, List list) {
        CLanguageData data = this.getCLanguageData(true);
        EntryStore store = new EntryStore();
        if (list != null) {
            if (list.size() != 0) {
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    ICLanguageSettingEntry entry = (ICLanguageSettingEntry)iter.next();
                    int eKind = entry.getKind();
                    if ((kind & eKind) == 0 || (data.getSupportedEntryKinds() & eKind) == 0) continue;
                    store.addEntry(entry);
                }
            } else {
                int[] kinds = KindBasedStore.getLanguageEntryKinds();
                int i = 0;
                while (i < kinds.length) {
                    if ((kinds[i] & kind) != 0) {
                        store.storeEntries(kinds[i], new ICLanguageSettingEntry[0]);
                    }
                    ++i;
                }
            }
        }
        this.setSettingEntries(kind, data, store);
    }

    private void setSettingEntries(int kind, CLanguageData data, EntryStore store) {
        int oredk = this.getSupportedEntryKinds();
        int[] kinds = this.flagsToArray(oredk);
        int i = 0;
        while (i < kinds.length) {
            ICLanguageSettingEntry[] sortedEntries;
            ICLanguageSettingEntry[] iCLanguageSettingEntryArray = sortedEntries = store.containsEntriesList(kinds[i]) ? store.getEntries(kinds[i]) : null;
            if ((kind & kinds[i]) != 0) {
                data.setEntries(kinds[i], sortedEntries);
                if (sortedEntries == null) {
                    CExternalSettingsManager.getInstance().restoreDefaults(this, kind);
                }
            }
            ++i;
        }
    }

    public ICLanguageSettingEntry[] getResolvedSettingEntries(int kind) {
        ICLanguageSettingEntry[] entries = this.getSettingEntries(kind);
        entries = CDataUtil.resolveEntries(entries, this.getConfiguration());
        return entries;
    }

    public void setSourceContentTypeIds(String[] ids) {
        CLanguageData data = this.getCLanguageData(true);
        data.setSourceContentTypeIds(ids);
    }

    public void setSourceExtensions(String[] exts) {
        CLanguageData data = this.getCLanguageData(true);
        data.setSourceExtensions(exts);
    }
}

