/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.settings.model.ICConfigExtensionReference;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICExternalSetting;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationDataProvider;
import org.eclipse.cdt.core.settings.model.extension.CFileData;
import org.eclipse.cdt.core.settings.model.extension.CFolderData;
import org.eclipse.cdt.core.settings.model.extension.CLanguageData;
import org.eclipse.cdt.core.settings.model.extension.CResourceData;
import org.eclipse.cdt.core.settings.model.extension.impl.CDataFacroty;
import org.eclipse.cdt.core.settings.model.extension.impl.CDefaultConfigurationData;
import org.eclipse.cdt.core.settings.model.extension.impl.CDefaultFileData;
import org.eclipse.cdt.core.settings.model.extension.impl.CDefaultFolderData;
import org.eclipse.cdt.core.settings.model.extension.impl.CDefaultLanguageData;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.core.settings.model.util.EntryStore;
import org.eclipse.cdt.core.settings.model.util.PathEntryResolveInfo;
import org.eclipse.cdt.core.settings.model.util.PathEntryTranslator;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.PathEntryManager;
import org.eclipse.cdt.internal.core.settings.model.ExceptionFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class PathEntryConfigurationDataProvider
extends CConfigurationDataProvider {
    private static PathEntryDataFactory fFactory;

    public static CDataFacroty getDataFactory() {
        if (fFactory == null) {
            fFactory = new PathEntryDataFactory();
        }
        return fFactory;
    }

    public PathEntryConfigurationDataProvider() {
        PathEntryConfigurationDataProvider.getDataFactory();
    }

    public static boolean isPathEntryData(CConfigurationData data) {
        return data instanceof CfgData;
    }

    public CConfigurationData applyConfiguration(ICConfigurationDescription des, ICConfigurationDescription baseDescription, CConfigurationData base, IProgressMonitor monitor) throws CoreException {
        if (!fFactory.isModified(base)) {
            return this.createData(des, base, false);
        }
        IProject project = des.getProjectDescription().getProject();
        IPathEntry[] entries = PathEntryTranslator.getPathEntries(project, baseDescription, 2);
        CModelManager manager = CModelManager.getDefault();
        ICProject cproject = manager.create(project);
        IPathEntry[] curRawEntries = PathEntryManager.getDefault().getRawPathEntries(cproject);
        ArrayList<IPathEntry> list = new ArrayList<IPathEntry>();
        list.addAll(Arrays.asList(entries));
        int i = 0;
        while (i < curRawEntries.length) {
            if (curRawEntries[i].getEntryKind() == 32) {
                list.add(curRawEntries[i]);
            }
            ++i;
        }
        IPathEntry[] newEntries = list.toArray(new IPathEntry[list.size()]);
        PathEntryManager.getDefault().setRawPathEntries(cproject, newEntries, (IProgressMonitor)new NullProgressMonitor());
        return this.createData(des, base, false);
    }

    private CConfigurationData createData(ICConfigurationDescription des, CConfigurationData fallbackData, boolean modifiedFlag) throws CoreException {
        CConfigurationData dataToReturn;
        try {
            dataToReturn = this.createData(des);
        }
        catch (Exception e) {
            if (fallbackData != null) {
                dataToReturn = fallbackData;
            }
            if (e instanceof CoreException) {
                throw (CoreException)((Object)e);
            }
            throw ExceptionFactory.createCoreException(e);
        }
        fFactory.setModified(dataToReturn, modifiedFlag);
        return dataToReturn;
    }

    public CConfigurationData createConfiguration(ICConfigurationDescription des, ICConfigurationDescription baseDescription, CConfigurationData base, boolean clone, IProgressMonitor monitor) throws CoreException {
        CfgData copy = new CfgData(des.getId(), des.getName(), base, clone);
        copy.setModified(false);
        return copy;
    }

    private CfgData createData(ICConfigurationDescription des) throws CoreException {
        IProject project = des.getProjectDescription().getProject();
        CModelManager manager = CModelManager.getDefault();
        ICProject cproject = manager.create(project);
        PathEntryResolveInfo rInfo = PathEntryManager.getDefault().getResolveInfo(cproject);
        CfgData data = new CfgData(des.getId(), des.getName());
        data.initEmptyData();
        CDataUtil.adjustConfig(data, PathEntryConfigurationDataProvider.getDataFactory());
        PathEntryTranslator tr = new PathEntryTranslator(project, data);
        PathEntryTranslator.ReferenceSettingsInfo refInfo = tr.applyPathEntries(rInfo, 3);
        ICExternalSetting[] extSettings = refInfo.getExternalSettings();
        des.removeExternalSettings();
        if (extSettings.length != 0) {
            int i = 0;
            while (i < extSettings.length) {
                ICExternalSetting setting = extSettings[i];
                des.createExternalSetting(setting.getCompatibleLanguageIds(), setting.getCompatibleContentTypeIds(), setting.getCompatibleExtensions(), setting.getEntries());
                ++i;
            }
        }
        cproject.close();
        String[] ids = this.getIds(des.get("org.eclipse.cdt.core.BinaryParser"));
        data.getTargetPlatformData().setBinaryParserIds(ids);
        ids = this.getIds(des.get("org.eclipse.cdt.core.ErrorParser"));
        data.getBuildData().setErrorParserIDs(ids);
        data.setModified(false);
        return data;
    }

    private String[] getIds(ICConfigExtensionReference[] refs) {
        if (refs == null || refs.length == 0) {
            return new String[0];
        }
        String[] ids = new String[refs.length];
        int i = 0;
        while (i < refs.length) {
            ids[i] = refs[i].getID();
            ++i;
        }
        return ids;
    }

    public CConfigurationData loadConfiguration(ICConfigurationDescription des, IProgressMonitor monitor) throws CoreException {
        return this.createData(des, null, false);
    }

    public void removeConfiguration(ICConfigurationDescription des, CConfigurationData data, IProgressMonitor monitor) {
    }

    public void dataCached(ICConfigurationDescription cfgDes, CConfigurationData data, IProgressMonitor monitor) {
        fFactory.setModified(data, false);
    }

    private static class CfgData
    extends CDefaultConfigurationData {
        public CfgData(String id, String name, CConfigurationData base, boolean clone) {
            super(id, name, base, fFactory, clone);
        }

        public CfgData(String id, String name) {
            super(id, name, fFactory);
        }
    }

    private static class PathEntryDataFactory
    extends CDataFacroty {
        private PathEntryDataFactory() {
        }

        public CConfigurationData createConfigurationdata(String id, String name, CConfigurationData base, boolean clone) {
            if (clone) {
                id = base.getId();
            } else if (id == null) {
                id = CDataUtil.genId(null);
            }
            return new CfgData(id, name, base, clone);
        }

        public CFileData createFileData(CConfigurationData cfg, CResourceData base, CLanguageData base2, String id, boolean clone, IPath path) {
            if (id == null) {
                String string = id = clone ? base.getId() : CDataUtil.genId(cfg.getId());
            }
            if (base.getType() == 8) {
                return new PathEntryFileData(id, path, (PathEntryFileData)base, cfg, (CDataFacroty)this, clone);
            }
            return new PathEntryFileData(id, path, (PathEntryFolderData)base, base2, cfg, (CDataFacroty)this);
        }

        public CFolderData createFolderData(CConfigurationData cfg, CFolderData base, String id, boolean clone, IPath path) {
            if (id == null) {
                id = clone ? base.getId() : CDataUtil.genId(cfg.getId());
            }
            return new PathEntryFolderData(id, path, (PathEntryFolderData)base, cfg, (CDataFacroty)this, clone);
        }

        public CLanguageData createLanguageData(CConfigurationData cfg, CResourceData rcBase, CLanguageData base, String id, boolean clone) {
            if (id == null) {
                id = clone ? base.getId() : CDataUtil.genId(rcBase.getId());
            }
            EntryStore store = rcBase.getType() == 4 ? ((PathEntryFolderData)rcBase).fStore : ((PathEntryFileData)rcBase).fStore;
            return new PathEntryLanguageData(id, base, store);
        }

        public CLanguageData createLanguageData(CConfigurationData cfg, CResourceData rcBase, String id, String name, String languageId, int supportedEntryKinds, String[] rcTypes, boolean isContentTypes) {
            if (id == null) {
                id = CDataUtil.genId(rcBase.getId());
            }
            EntryStore store = rcBase.getType() == 4 ? ((PathEntryFolderData)rcBase).fStore : ((PathEntryFileData)rcBase).fStore;
            return new PathEntryLanguageData(id, name, languageId, supportedEntryKinds, rcTypes, isContentTypes, store);
        }
    }

    private static class PathEntryFileData
    extends CDefaultFileData {
        private EntryStore fStore;

        public PathEntryFileData(String id, IPath path, PathEntryFileData base, CConfigurationData cfg, CDataFacroty factory, boolean clone) {
            super(id, path, cfg, factory);
            this.fStore = new EntryStore(base.fStore, true);
            this.copyDataFrom(base, clone);
        }

        public PathEntryFileData(String id, IPath path, PathEntryFolderData base, CLanguageData baseLangData, CConfigurationData cfg, CDataFacroty factory) {
            super(id, path, cfg, factory);
            this.fStore = new EntryStore(base.fStore, true);
            this.copyDataFrom(base, baseLangData);
        }
    }

    private static class PathEntryFolderData
    extends CDefaultFolderData {
        private EntryStore fStore;

        public PathEntryFolderData(String id, IPath path, PathEntryFolderData base, CConfigurationData cfg, CDataFacroty factory, boolean clone) {
            super(id, path, cfg, factory);
            this.fStore = base != null ? new EntryStore(base.fStore, true) : new EntryStore(true);
            this.copyDataFrom(base, clone);
        }
    }

    private static class PathEntryLanguageData
    extends CDefaultLanguageData {
        public PathEntryLanguageData(String id, CLanguageData base, EntryStore store) {
            this.fId = id;
            this.fStore = store;
            this.copySettingsFrom(base);
        }

        public PathEntryLanguageData(String id, String name, String languageId, int kinds, String[] ids, boolean isContentTypes, EntryStore store) {
            super(id, languageId, ids, isContentTypes);
            this.fStore = store;
            this.fName = name;
            this.fSupportedKinds = kinds;
        }

        protected EntryStore createStore() {
            return this.fStore;
        }

        protected EntryStore createStore(CLanguageData data) {
            return this.fStore;
        }
    }
}

