/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.core.settings.model.WriteAccessException;
import org.eclipse.cdt.core.settings.model.util.ResourceChangeHandlerBase;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescription;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ResourceChangeHandler
extends ResourceChangeHandlerBase
implements ISaveParticipant {
    CProjectDescriptionManager fMngr = CProjectDescriptionManager.getInstance();

    protected ResourceChangeHandlerBase.IResourceMoveHandler createResourceMoveHandler(IResourceChangeEvent event) {
        return new RcMoveHandler();
    }

    public void saving(ISaveContext context) throws CoreException {
        context.needDelta();
    }

    public void doneSaving(ISaveContext context) {
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void rollback(ISaveContext context) {
    }

    private class RcMoveHandler
    implements ResourceChangeHandlerBase.IResourceMoveHandler {
        Map fProjDesMap = new HashMap();
        Set fRemovedProjSet = new HashSet();

        private RcMoveHandler() {
        }

        public void handleProjectClose(IProject project) {
            ResourceChangeHandler.this.fMngr.setLoaddedDescription(project, null, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean handleResourceMove(IResource fromRc, IResource toRc) {
            boolean proceed = true;
            IProject fromProject = fromRc.getProject();
            IProject toProject = toRc.getProject();
            switch (toRc.getType()) {
                case 4: {
                    ICProjectDescription des = this.getProjectDescription((IResource)fromProject, false);
                    this.fRemovedProjSet.add(fromProject);
                    if (des == null) break;
                    ((CProjectDescription)des).updateProject(toProject);
                    CProjectDescriptionManager cProjectDescriptionManager = ResourceChangeHandler.this.fMngr;
                    synchronized (cProjectDescriptionManager) {
                        ResourceChangeHandler.this.fMngr.setLoaddedDescription(fromProject, null, true);
                        ResourceChangeHandler.this.fMngr.setLoaddedDescription(toProject, des, true);
                    }
                    this.fProjDesMap.put(toProject, des);
                    ICConfigurationDescription[] cfgs = des.getConfigurations();
                    int i = 0;
                    while (i < cfgs.length) {
                        cfgs[i].getConfigurationData();
                        ++i;
                    }
                    break;
                }
                case 1: 
                case 2: {
                    ICProjectDescription des;
                    IPath fromRcProjPath = fromRc.getProjectRelativePath();
                    IPath toRcProjPath = toRc.getProjectRelativePath();
                    if (toRcProjPath.equals((Object)fromRcProjPath) || !toProject.equals((Object)fromProject) || (des = this.getProjectDescription((IResource)toProject, true)) == null) break;
                    ICConfigurationDescription[] cfgDess = des.getConfigurations();
                    int i = 0;
                    while (i < cfgDess.length) {
                        ICResourceDescription rcDescription = cfgDess[i].getResourceDescription(fromRcProjPath, true);
                        if (rcDescription != null) {
                            try {
                                rcDescription.setPath(toRcProjPath);
                            }
                            catch (WriteAccessException writeAccessException) {}
                        }
                        ++i;
                    }
                    break;
                }
            }
            return proceed;
        }

        private ICProjectDescription getProjectDescription(IResource rc, boolean load) {
            IProject project = rc.getProject();
            ICProjectDescription des = (ICProjectDescription)this.fProjDesMap.get(project);
            if (des == null) {
                int flags = load ? 0 : 8;
                flags |= Integer.MIN_VALUE;
                des = ResourceChangeHandler.this.fMngr.getProjectDescription(project, flags |= 4);
                this.fProjDesMap.put(project, des);
            }
            return des;
        }

        public boolean handleResourceRemove(IResource rc) {
            boolean proceed = true;
            IProject project = rc.getProject();
            switch (rc.getType()) {
                case 4: {
                    ResourceChangeHandler.this.fMngr.setLoaddedDescription(project, null, true);
                    this.fRemovedProjSet.add(project);
                    proceed = false;
                    break;
                }
                case 1: 
                case 2: {
                    ICProjectDescription des;
                    if (!project.exists() || (des = this.getProjectDescription((IResource)project, true)) == null) break;
                    IPath rcProjPath = rc.getProjectRelativePath();
                    ICConfigurationDescription[] cfgDess = des.getConfigurations();
                    int i = 0;
                    while (i < cfgDess.length) {
                        ICResourceDescription rcDescription = cfgDess[i].getResourceDescription(rcProjPath, true);
                        if (rcDescription != null) {
                            try {
                                cfgDess[i].removeResourceDescription(rcDescription);
                            }
                            catch (WriteAccessException writeAccessException) {
                            }
                            catch (CoreException coreException) {}
                        }
                        ++i;
                    }
                    break;
                }
            }
            return proceed;
        }

        public void done() {
            Iterator iter = this.fProjDesMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (this.fRemovedProjSet.contains(entry.getKey())) {
                    iter.remove();
                    continue;
                }
                ICProjectDescription des = (ICProjectDescription)entry.getValue();
                if (des != null && des.isModified()) continue;
                iter.remove();
            }
            if (this.fProjDesMap.size() != 0) {
                ResourceChangeHandler.this.fMngr.runWspModification(new IWorkspaceRunnable(this){
                    final /* synthetic */ RcMoveHandler this$1;
                    {
                        this.this$1 = rcMoveHandler;
                    }

                    public void run(IProgressMonitor monitor) throws CoreException {
                        Iterator<Map.Entry<K, V>> iter = this.this$1.fProjDesMap.entrySet().iterator();
                        while (iter.hasNext()) {
                            Map.Entry<K, V> entry = iter.next();
                            IProject project = (IProject)entry.getKey();
                            if (!project.isOpen()) continue;
                            ICProjectDescription des = (ICProjectDescription)entry.getValue();
                            try {
                                RcMoveHandler.access$1((RcMoveHandler)this.this$1).fMngr.setProjectDescription(project, des);
                            }
                            catch (CoreException e) {
                                CCorePlugin.log(e);
                            }
                        }
                    }
                }, (IProgressMonitor)new NullProgressMonitor());
            }
        }

        static /* synthetic */ ResourceChangeHandler access$1(RcMoveHandler rcMoveHandler) {
            return rcMoveHandler.ResourceChangeHandler.this;
        }
    }
}

