/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import org.eclipse.cdt.core.settings.model.IModificationContext;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionManager;
import org.eclipse.cdt.internal.core.settings.model.ExceptionFactory;
import org.eclipse.cdt.internal.core.settings.model.SettingsModelMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public final class SettingsContext
implements IModificationContext {
    private IProjectDescription fEDes;
    private IProject fProject;
    private CProjectDescriptionManager.CompositeWorkspaceRunnable fRunnable;

    SettingsContext(IProject project) {
        this.fProject = project;
    }

    public IProject getProject() {
        return this.fProject;
    }

    IProjectDescription getEclipseProjectDescription(boolean create) throws CoreException {
        IProjectDescription eDes = this.fEDes;
        if (eDes == null && create) {
            if (this.fProject == null) {
                throw ExceptionFactory.createCoreException(SettingsModelMessages.getString("SettingsContext.0"));
            }
            eDes = this.fProject.getDescription();
        }
        return eDes;
    }

    public IProjectDescription getEclipseProjectDescription() throws CoreException {
        return this.getEclipseProjectDescription(true);
    }

    public void setEclipseProjectDescription(IProjectDescription des) throws CoreException {
        if (this.fEDes == null) {
            this.fEDes = des;
        } else if (this.fEDes != des) {
            throw ExceptionFactory.createCoreException(SettingsModelMessages.getString("SettingsContext.1"));
        }
    }

    CProjectDescriptionManager.CompositeWorkspaceRunnable getCompositeWorkspaceRunnable(boolean create) {
        if (this.fRunnable == null && create) {
            this.fRunnable = new CProjectDescriptionManager.CompositeWorkspaceRunnable(null);
        }
        return this.fRunnable;
    }

    public void addWorkspaceRunnable(IWorkspaceRunnable runnable) {
        this.getCompositeWorkspaceRunnable(true).add(runnable);
    }

    IWorkspaceRunnable createOperationRunnable() {
        CProjectDescriptionManager.CompositeWorkspaceRunnable result = new CProjectDescriptionManager.CompositeWorkspaceRunnable(null);
        IWorkspaceRunnable r = this.getSetEclipseProjectDescriptionRunnable();
        if (r != null) {
            result.add(r);
        }
        if ((r = this.getCompositeWorkspaceRunnable(false)) != null) {
            result.add(r);
        }
        return result.isEmpty() ? null : result;
    }

    private IWorkspaceRunnable getSetEclipseProjectDescriptionRunnable() {
        if (this.fEDes != null) {
            return new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    SettingsContext.this.fProject.setDescription(SettingsContext.this.fEDes, monitor);
                }
            };
        }
        return null;
    }
}

