/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core;

import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.internal.core.Option;

public final class OptionStringValue {
    private static final String ATTR_SRC_PATH = "srcPath";
    private static final String ATTR_SRC_ROOT_PATH = "srcRootPath";
    private static final String ATTR_SRC_PREFIX_MAPPING = "srcPrefixMapping";
    private String value;
    private String srcPath;
    private String srcRootPath;
    private String srcPrefixMapping;
    private boolean isBuiltIn;

    public OptionStringValue(ICStorageElement el) {
        this.isBuiltIn = el.getAttribute("builtIn") != null ? Boolean.valueOf(el.getAttribute("builtIn")) : false;
        this.value = el.getAttribute("value");
        this.srcPath = el.getAttribute(ATTR_SRC_PATH);
        this.srcRootPath = el.getAttribute(ATTR_SRC_ROOT_PATH);
        this.srcPrefixMapping = el.getAttribute(ATTR_SRC_PREFIX_MAPPING);
        if (this.value == null) {
            this.value = Option.EMPTY_STRING;
        }
    }

    public OptionStringValue(IManagedConfigElement el) {
        this.isBuiltIn = el.getAttribute("builtIn") != null ? Boolean.valueOf(el.getAttribute("builtIn")) : false;
        this.value = el.getAttribute("value");
        this.srcPath = el.getAttribute(ATTR_SRC_PATH);
        this.srcRootPath = el.getAttribute(ATTR_SRC_ROOT_PATH);
        this.srcPrefixMapping = el.getAttribute(ATTR_SRC_PREFIX_MAPPING);
        if (this.value == null) {
            this.value = Option.EMPTY_STRING;
        }
    }

    public OptionStringValue(OptionStringValue base) {
        this.isBuiltIn = base.isBuiltIn;
        this.value = base.value;
        this.srcPath = base.srcPath;
        this.srcRootPath = base.srcRootPath;
        this.srcPrefixMapping = base.srcPrefixMapping;
    }

    public OptionStringValue(String value) {
        this(value, false);
    }

    public OptionStringValue(String value, boolean isBuiltIn) {
        this(value, isBuiltIn, null, null, null);
    }

    public OptionStringValue(String value, boolean isBuiltIn, String srcPath, String srcRootPath, String srcPrefixMapping) {
        if (value == null) {
            value = Option.EMPTY_STRING;
        }
        this.isBuiltIn = isBuiltIn;
        this.value = value;
        this.srcPath = srcPath;
        this.srcRootPath = srcRootPath;
        this.srcPrefixMapping = srcPrefixMapping;
    }

    public void serialize(ICStorageElement el) {
        el.setAttribute("value", this.value);
        el.setAttribute("builtIn", Boolean.toString(this.isBuiltIn));
        if (this.srcPath != null) {
            el.setAttribute(ATTR_SRC_PATH, this.srcPath);
        }
        if (this.srcRootPath != null) {
            el.setAttribute(ATTR_SRC_ROOT_PATH, this.srcRootPath);
        }
        if (this.srcPrefixMapping != null) {
            el.setAttribute(ATTR_SRC_PREFIX_MAPPING, this.srcPrefixMapping);
        }
    }

    public boolean isBuiltIn() {
        return this.isBuiltIn;
    }

    public String getValue() {
        return this.value;
    }

    public String getSourceAttachmentPath() {
        return this.srcPath;
    }

    public String getSourceAttachmentRootPath() {
        return this.srcRootPath;
    }

    public String getSourceAttachmentPrefixMapping() {
        return this.srcPrefixMapping;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OptionStringValue)) {
            return false;
        }
        OptionStringValue other = (OptionStringValue)obj;
        if (this.isBuiltIn != other.isBuiltIn) {
            return false;
        }
        if (!CDataUtil.objectsEqual((Object)this.value, (Object)other.value)) {
            return false;
        }
        if (!CDataUtil.objectsEqual((Object)this.srcPath, (Object)other.srcPath)) {
            return false;
        }
        if (!CDataUtil.objectsEqual((Object)this.srcRootPath, (Object)other.srcRootPath)) {
            return false;
        }
        return CDataUtil.objectsEqual((Object)this.srcPrefixMapping, (Object)other.srcPrefixMapping);
    }

    public int hashCode() {
        return OptionStringValue.code(this.value);
    }

    private static int code(String str) {
        return str != null ? str.hashCode() : 0;
    }

    public String toString() {
        return "ov:" + this.value.toString();
    }
}

