/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.templateengine.processes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.cdt.core.templateengine.process.processes.Messages;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class ExcludeResources
extends ProcessRunner {
    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        String projectName = args[0].getSimpleValue();
        String configIdPattern = args[1].getSimpleValue();
        final String[] filePatterns = args[2].getSimpleArrayValue();
        String invertConfigMatching = args[3].getSimpleValue();
        boolean invert = Boolean.valueOf(invertConfigMatching);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        if (info == null) {
            throw new ProcessFailureException(Messages.getString((String)"ExcludeResources.0"));
        }
        IManagedProject managedProject = info.getManagedProject();
        IConfiguration[] allConfigs = managedProject.getConfigurations();
        ArrayList<IConfiguration> matchingConfigs = new ArrayList<IConfiguration>();
        int i = 0;
        while (i < allConfigs.length) {
            IConfiguration config = allConfigs[i];
            if (config.getId().matches(configIdPattern)) {
                matchingConfigs.add(config);
            }
            ++i;
        }
        if (invert) {
            ArrayList<IConfiguration> invertedConfigs = new ArrayList<IConfiguration>(Arrays.asList(allConfigs));
            invertedConfigs.removeAll(matchingConfigs);
            matchingConfigs = invertedConfigs;
        }
        final ArrayList<IConfiguration> configsToProcess = matchingConfigs;
        IResourceProxyVisitor visitor = new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy proxy) throws CoreException {
                IPath lPath = proxy.requestFullPath();
                if (proxy.getType() == 1) {
                    boolean isDerived = false;
                    IResource res = proxy.requestResource();
                    while (res != null) {
                        isDerived |= res.isDerived();
                        res = res.getParent();
                    }
                    if (!isDerived) {
                        Iterator i = configsToProcess.iterator();
                        block1: while (i.hasNext()) {
                            IConfiguration config = (IConfiguration)i.next();
                            IResourceConfiguration resourceConfig = config.getResourceConfiguration(lPath.toString());
                            int j = 0;
                            while (j < filePatterns.length) {
                                String filePattern = filePatterns[j];
                                if (lPath.toString().matches(filePattern)) {
                                    if (resourceConfig == null) {
                                        IFile file = (IFile)proxy.requestResource();
                                        resourceConfig = config.createResourceConfiguration(file);
                                    }
                                    if (resourceConfig == null) continue block1;
                                    resourceConfig.setExclude(true);
                                    continue block1;
                                }
                                ++j;
                            }
                        }
                    }
                }
                return true;
            }
        };
        try {
            project.accept(visitor, 2);
            if (info.isDirty()) {
                ManagedBuildManager.saveBuildInfo(project, true);
            }
        }
        catch (CoreException ce) {
            throw new ProcessFailureException((Throwable)ce);
        }
    }
}

