/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import java.util.ArrayList;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIValue;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariableDescriptor;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIArrayType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIBoolType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDICharType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIDerivedType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIDoubleType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIEnumType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIFloatType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIFunctionType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIIntType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDILongLongType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDILongType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIPointerType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIReferenceType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIShortType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIStructType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIWCharType;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CdiResources;
import org.eclipse.cdt.debug.mi.core.cdi.ExpressionManager;
import org.eclipse.cdt.debug.mi.core.cdi.Format;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.MemoryManager;
import org.eclipse.cdt.debug.mi.core.cdi.RegisterManager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.VariableManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.LocalVariableDescriptor;
import org.eclipse.cdt.debug.mi.core.cdi.model.StackFrame;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.cdi.model.Thread;
import org.eclipse.cdt.debug.mi.core.cdi.model.Value;
import org.eclipse.cdt.debug.mi.core.cdi.model.VariableDescriptor;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.ArrayValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.BoolValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.CharValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.DoubleValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.EnumValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.FloatValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.FunctionValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.IncompleteType;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.IntValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.LongLongValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.LongValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.PointerValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.ReferenceValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.ShortValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.StructValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.WCharValue;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIVarAssign;
import org.eclipse.cdt.debug.mi.core.command.MIVarCreate;
import org.eclipse.cdt.debug.mi.core.command.MIVarInfoExpression;
import org.eclipse.cdt.debug.mi.core.command.MIVarInfoType;
import org.eclipse.cdt.debug.mi.core.command.MIVarListChildren;
import org.eclipse.cdt.debug.mi.core.command.MIVarSetFormat;
import org.eclipse.cdt.debug.mi.core.command.MIVarShowAttributes;
import org.eclipse.cdt.debug.mi.core.event.MIVarChangedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIVar;
import org.eclipse.cdt.debug.mi.core.output.MIVarCreateInfo;
import org.eclipse.cdt.debug.mi.core.output.MIVarInfoExpressionInfo;
import org.eclipse.cdt.debug.mi.core.output.MIVarInfoTypeInfo;
import org.eclipse.cdt.debug.mi.core.output.MIVarListChildrenInfo;
import org.eclipse.cdt.debug.mi.core.output.MIVarShowAttributesInfo;

public abstract class Variable
extends VariableDescriptor
implements ICDIVariable {
    private static final ICDIVariable[] NO_CHILDREN = new ICDIVariable[0];
    protected MIVarCreate fVarCreateCMD;
    protected MIVar fMIVar;
    Value value;
    public ICDIVariable[] children = NO_CHILDREN;
    String editable = null;
    String language;
    boolean isFake = false;
    boolean isUpdated = true;
    private String hexAddress;

    public Variable(VariableDescriptor obj, MIVarCreate var) {
        super(obj);
        this.fVarCreateCMD = var;
    }

    public Variable(Target target, Thread thread, StackFrame frame, String n, String q, int pos, int depth, MIVar miVar) {
        super(target, thread, frame, n, q, pos, depth);
        this.fMIVar = miVar;
    }

    public void setUpdated(boolean update) {
        this.isUpdated = update;
    }

    public boolean isUpdated() {
        return this.isUpdated;
    }

    public void update() throws CDIException {
        Session session = (Session)this.getTarget().getSession();
        VariableManager mgr = session.getVariableManager();
        mgr.update(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MIVar getMIVar() throws CDIException {
        if (this.fMIVar != null) return this.fMIVar;
        if (this.fVarCreateCMD == null) {
            throw new CDIException("Incomplete initialization of variable");
        }
        try {
            MISession mi = ((Target)this.getTarget()).getMISession();
            MIVarCreateInfo info = null;
            MIVarCreate mIVarCreate = this.fVarCreateCMD;
            synchronized (mIVarCreate) {
                while ((info = this.fVarCreateCMD.getMIVarCreateInfo()) == null) {
                    try {
                        this.fVarCreateCMD.wait(mi.getCommandTimeout());
                        info = this.fVarCreateCMD.getMIVarCreateInfo();
                        if (info != null) continue;
                        throw new MIException(MIPlugin.getResourceString("src.MISession.Target_not_responding"));
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
            }
            this.fMIVar = info.getMIVar();
            return this.fMIVar;
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    private String getHexAddress() throws CDIException {
        if (this.hexAddress != null) {
            return this.hexAddress;
        }
        VariableManager vm = ((Session)((Target)this.getTarget()).getSession()).getVariableManager();
        String qualName = "&(" + this.getQualifiedName() + ")";
        LocalVariableDescriptor desc = new LocalVariableDescriptor((Target)this.getTarget(), (Thread)this.getThread(), (StackFrame)this.getStackFrame(), this.getName(), qualName, this.getPosition(), this.getStackDepth());
        Variable v = vm.createVariable(desc);
        v.setFormat(4);
        this.hexAddress = v.getValue().getValueString();
        return this.hexAddress;
    }

    public Variable getChild(String name) {
        int i = 0;
        while (i < this.children.length) {
            Variable variable = (Variable)this.children[i];
            try {
                if (name.equals(variable.getMIVar().getVarName())) {
                    return variable;
                }
                Variable grandChild = variable.getChild(name);
                if (grandChild != null) {
                    return grandChild;
                }
            }
            catch (CDIException cDIException) {}
            ++i;
        }
        return null;
    }

    String getLanguage() throws CDIException {
        if (this.language == null) {
            MISession mi = ((Target)this.getTarget()).getMISession();
            CommandFactory factory = mi.getCommandFactory();
            MIVarInfoExpression var = factory.createMIVarInfoExpression(this.getMIVar().getVarName());
            try {
                mi.postCommand(var);
                MIVarInfoExpressionInfo info = var.getMIVarInfoExpressionInfo();
                if (info == null) {
                    throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                }
                this.language = info.getLanguage();
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        return this.language == null ? "" : this.language;
    }

    boolean isCPPLanguage() throws CDIException {
        return this.getLanguage().equalsIgnoreCase("C++");
    }

    void setIsFake(boolean f) {
        this.isFake = f;
    }

    boolean isFake() {
        return this.isFake;
    }

    public ICDIVariable[] getChildren() throws CDIException {
        return this.getChildren(-1);
    }

    public ICDIVariable[] getChildren(int timeout) throws CDIException {
        this.children = NO_CHILDREN;
        MISession mi = ((Target)this.getTarget()).getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIVarListChildren var = factory.createMIVarListChildren(this.getMIVar().getVarName());
        try {
            if (timeout >= 0) {
                mi.postCommand(var, timeout);
            } else {
                mi.postCommand(var);
            }
            MIVarListChildrenInfo info = var.getMIVarListChildrenInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
            }
            MIVar[] vars = info.getMIVars();
            ArrayList<ICDIVariable> childrenList = new ArrayList<ICDIVariable>(vars.length);
            boolean cppFakeLayer = this.isCPPLanguage() && (!this.isFake() || this.isFake() && !this.isAccessQualifier(this.fName));
            ICDIType t = this.getType();
            boolean container = this.isStructureProvider(t);
            int i = 0;
            while (i < vars.length) {
                String prefix = String.valueOf('(') + this.getFullName() + ')';
                String childName = vars[i].getExp();
                String childFullName = String.valueOf(prefix) + '.' + childName;
                ICDIType childType = null;
                boolean childFake = false;
                if (cppFakeLayer && container) {
                    childFake = true;
                    childType = t;
                    childFullName = !this.isAccessQualifier(childName) ? String.valueOf('(') + childName + ')' + prefix : prefix;
                } else if (t instanceof ICDIArrayType) {
                    int index = this.castingIndex + i;
                    childFullName = String.valueOf(prefix) + "[" + index + "]";
                    childName = String.valueOf(this.getName()) + "[" + index + "]";
                } else if (t instanceof ICDIPointerType) {
                    childFullName = container ? String.valueOf(prefix) + "->" + childName : "*" + prefix;
                } else if (t instanceof ICDIReferenceType) {
                    childFullName = container ? String.valueOf(prefix) + "." + childName : prefix;
                } else {
                    boolean cfr_ignored_0 = t instanceof ICDIStructType;
                }
                Variable v = this.createVariable((Target)this.getTarget(), (Thread)this.getThread(), (StackFrame)this.getStackFrame(), childName, childFullName, this.getPosition(), this.getStackDepth(), vars[i]);
                if (childType != null) {
                    v.fType = childType;
                }
                v.setIsFake(childFake);
                if (childFake && this.isAccessQualifier(childName)) {
                    ICDIVariable[] grandchildren = v.getChildren(timeout);
                    int j = 0;
                    while (j < grandchildren.length) {
                        childrenList.add(grandchildren[j]);
                        ++j;
                    }
                } else {
                    childrenList.add(v);
                }
                ++i;
            }
            if (!childrenList.isEmpty()) {
                this.children = childrenList.toArray(new Variable[childrenList.size()]);
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        return this.children;
    }

    private boolean isStructureProvider(ICDIType t) {
        if (t instanceof ICDIStructType || t instanceof IncompleteType) {
            return true;
        }
        if (t instanceof ICDIPointerType || t instanceof ICDIReferenceType) {
            ICDIType type = ((ICDIDerivedType)t).getComponentType();
            return type instanceof ICDIStructType || type instanceof IncompleteType;
        }
        return false;
    }

    boolean isAccessQualifier(String foo) {
        return foo.equals("private") || foo.equals("public") || foo.equals("protected");
    }

    protected abstract Variable createVariable(Target var1, Thread var2, StackFrame var3, String var4, String var5, int var6, int var7, MIVar var8);

    public int getChildrenNumber() throws CDIException {
        return this.getMIVar().getNumChild();
    }

    public ICDIValue getValue() throws CDIException {
        if (this.value == null) {
            ICDIType t = this.getType();
            this.value = t instanceof ICDIBoolType ? new BoolValue(this) : (t instanceof ICDICharType ? new CharValue(this) : (t instanceof ICDIWCharType ? new WCharValue(this) : (t instanceof ICDIShortType ? new ShortValue(this) : (t instanceof ICDIIntType ? new IntValue(this) : (t instanceof ICDILongType ? new LongValue(this) : (t instanceof ICDILongLongType ? new LongLongValue(this) : (t instanceof ICDIEnumType ? new EnumValue(this) : (t instanceof ICDIFloatType ? new FloatValue(this) : (t instanceof ICDIDoubleType ? new DoubleValue(this) : (t instanceof ICDIFunctionType ? new FunctionValue(this) : (t instanceof ICDIPointerType ? new PointerValue(this) : (t instanceof ICDIReferenceType ? new ReferenceValue(this, this.getHexAddress()) : (t instanceof ICDIArrayType ? new ArrayValue(this, this.getHexAddress()) : (t instanceof ICDIStructType ? new StructValue(this) : new Value(this)))))))))))))));
        }
        return this.value;
    }

    public void setValue(ICDIValue value) throws CDIException {
        this.setValue(value.getValueString());
    }

    public void setValue(String expression) throws CDIException {
        MemoryManager memMgr;
        VariableManager varMgr;
        ExpressionManager expMgr;
        Target target = (Target)this.getTarget();
        MISession miSession = target.getMISession();
        CommandFactory factory = miSession.getCommandFactory();
        MIVarAssign var = factory.createMIVarAssign(this.getMIVar().getVarName(), expression);
        try {
            miSession.postCommand(var);
            MIInfo info = var.getMIInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        MIVarChangedEvent change = new MIVarChangedEvent(miSession, var.getToken(), this.getMIVar().getVarName());
        miSession.fireEvent(change);
        RegisterManager regMgr = ((Session)target.getSession()).getRegisterManager();
        if (regMgr.isAutoUpdate()) {
            regMgr.update(target);
        }
        if ((expMgr = ((Session)target.getSession()).getExpressionManager()).isAutoUpdate()) {
            expMgr.update(target);
        }
        if ((varMgr = ((Session)target.getSession()).getVariableManager()).isAutoUpdate()) {
            varMgr.update(target);
        }
        if ((memMgr = ((Session)target.getSession()).getMemoryManager()).isAutoUpdate()) {
            memMgr.update(target);
        }
    }

    public boolean isEditable() throws CDIException {
        if (this.editable == null) {
            MISession mi = ((Target)this.getTarget()).getMISession();
            CommandFactory factory = mi.getCommandFactory();
            MIVarShowAttributes var = factory.createMIVarShowAttributes(this.getMIVar().getVarName());
            try {
                mi.postCommand(var);
                MIVarShowAttributesInfo info = var.getMIVarShowAttributesInfo();
                if (info == null) {
                    throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                }
                this.editable = String.valueOf(info.isEditable());
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        return this.editable == null ? false : this.editable.equalsIgnoreCase("true");
    }

    public void setFormat(int format) throws CDIException {
        int fmt = Format.toMIFormat(format);
        MISession mi = ((Target)this.getTarget()).getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIVarSetFormat var = factory.createMIVarSetFormat(this.getMIVar().getVarName(), fmt);
        try {
            mi.postCommand(var);
            MIInfo info = var.getMIInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public boolean equals(ICDIVariable var) {
        if (var instanceof Variable) {
            Variable variable = (Variable)var;
            return this.equals(variable);
        }
        return super.equals((ICDIVariableDescriptor)var);
    }

    public boolean equals(Variable variable) {
        try {
            return this.getMIVar().getVarName().equals(variable.getMIVar().getVarName());
        }
        catch (CDIException cDIException) {
            return super.equals(variable);
        }
    }

    public void dispose() throws CDIException {
        ICDITarget target = this.getTarget();
        VariableManager varMgr = ((Session)target.getSession()).getVariableManager();
        varMgr.destroyVariable(this);
    }

    public String getTypeName() throws CDIException {
        if (this.fTypename == null) {
            this.fTypename = this.getMIVar().getType();
            if (this.fTypename == null || this.fTypename.length() == 0) {
                MISession mi = ((Target)this.getTarget()).getMISession();
                CommandFactory factory = mi.getCommandFactory();
                MIVarInfoType infoType = factory.createMIVarInfoType(this.getMIVar().getVarName());
                try {
                    mi.postCommand(infoType);
                    MIVarInfoTypeInfo info = infoType.getMIVarInfoTypeInfo();
                    if (info == null) {
                        throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                    }
                    this.fTypename = info.getType();
                }
                catch (MIException e) {
                    throw new MI2CDIException(e);
                }
            }
        }
        return this.fTypename;
    }

    public void setMIVarCreate(MIVarCreate miVar) {
        this.fVarCreateCMD = miVar;
    }
}

