/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.internal.ui;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.command.factories.CommandFactoryDescriptor;
import org.eclipse.cdt.debug.mi.internal.ui.MIUIMessages;
import org.eclipse.cdt.debug.mi.ui.IMILaunchConfigurationComponent;
import org.eclipse.cdt.debug.mi.ui.MIUIUtils;
import org.eclipse.cdt.debug.ui.AbstractCDebuggerPage;
import org.eclipse.cdt.utils.Platform;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class StandardGDBDebuggerPage
extends AbstractCDebuggerPage
implements Observer {
    private static final String DEFAULT_MI_VERSION = "mi";
    protected TabFolder fTabFolder;
    protected Text fGDBCommandText;
    protected Text fGDBInitText;
    protected Combo fCommandFactoryCombo;
    protected Combo fProtocolCombo;
    protected Button fVerboseModeButton;
    private IMILaunchConfigurationComponent fSolibBlock;
    private CommandFactoryDescriptor[] fCommandFactoryDescriptors;
    private boolean fIsInitializing = false;
    private static boolean gdb64ExistsIsCached = false;
    private static boolean cachedGdb64Exists;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(1808));
        this.fTabFolder = new TabFolder(comp, 0);
        this.fTabFolder.setLayoutData((Object)new GridData(1808));
        this.createTabs(this.fTabFolder);
        this.fTabFolder.setSelection(0);
        this.setControl((Control)parent);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, this.defaultGdbCommand((ILaunchConfiguration)configuration));
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_GDB_INIT, ".gdbinit");
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_COMMAND_FACTORY, MIPlugin.getDefault().getCommandFactoryManager().getDefaultDescriptor(this.getDebuggerIdentifier()).getIdentifier());
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_VERBOSE_MODE, false);
        if (this.fSolibBlock != null) {
            this.fSolibBlock.setDefaults(configuration);
        }
    }

    protected String defaultGdbCommand(ILaunchConfiguration configuration) {
        String gdbCommand = null;
        if (Platform.getOS().equals("linux") && Platform.getOSArch().equals("ppc64")) {
            if (!gdb64ExistsIsCached) {
                int interruptedRetryCount = 5;
                String[] cmd = new String[]{"gdb64", "--version"};
                gdb64ExistsIsCached = true;
                while (interruptedRetryCount >= 0) {
                    try {
                        Process unameProcess = Runtime.getRuntime().exec(cmd);
                        int exitStatus = unameProcess.waitFor();
                        cachedGdb64Exists = exitStatus == 0;
                        break;
                    }
                    catch (IOException iOException) {
                        cachedGdb64Exists = false;
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                        cachedGdb64Exists = false;
                        --interruptedRetryCount;
                    }
                }
            }
            gdbCommand = cachedGdb64Exists ? "gdb64" : "gdb";
        } else {
            gdbCommand = "gdb";
        }
        return gdbCommand;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean valid;
        boolean bl = valid = this.fGDBCommandText.getText().length() != 0;
        if (valid) {
            this.setErrorMessage(null);
            this.setMessage(null);
        } else {
            this.setErrorMessage(MIUIMessages.getString("StandardGDBDebuggerPage.0"));
            this.setMessage(null);
        }
        return valid;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.setInitializing(true);
        String gdbCommand = this.defaultGdbCommand(configuration);
        String gdbInit = ".gdbinit";
        try {
            gdbCommand = configuration.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, this.defaultGdbCommand(configuration));
        }
        catch (CoreException coreException) {}
        try {
            gdbInit = configuration.getAttribute(IMILaunchConfigurationConstants.ATTR_GDB_INIT, ".gdbinit");
        }
        catch (CoreException coreException) {}
        if (this.fSolibBlock != null) {
            this.fSolibBlock.initializeFrom(configuration);
        }
        this.fGDBCommandText.setText(gdbCommand);
        this.fGDBInitText.setText(gdbInit);
        String debuggerID = this.getDebuggerIdentifier();
        this.fCommandFactoryDescriptors = MIPlugin.getDefault().getCommandFactoryManager().getDescriptors(debuggerID);
        Arrays.sort(this.fCommandFactoryDescriptors, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                return ((CommandFactoryDescriptor)arg0).getName().compareTo(((CommandFactoryDescriptor)arg1).getName());
            }
        });
        String[] descLabels = new String[this.fCommandFactoryDescriptors.length];
        String commandFactoryId = MIPlugin.getCommandFactory((ILaunchConfiguration)configuration);
        int index = -1;
        int i = 0;
        while (i < this.fCommandFactoryDescriptors.length) {
            descLabels[i] = this.fCommandFactoryDescriptors[i].getName();
            if (this.fCommandFactoryDescriptors[i].getIdentifier().equals(commandFactoryId)) {
                index = i;
            }
            ++i;
        }
        this.fCommandFactoryCombo.setItems(descLabels);
        if (index < 0) {
            index = 0;
        }
        String[] miVersions = new String[]{};
        if (index < this.fCommandFactoryDescriptors.length) {
            this.fCommandFactoryCombo.select(index);
            miVersions = this.fCommandFactoryDescriptors[index].getMIVersions();
        }
        this.fProtocolCombo.setItems(miVersions);
        if (miVersions.length == 0) {
            miVersions = new String[]{DEFAULT_MI_VERSION};
        }
        String mi = DEFAULT_MI_VERSION;
        try {
            mi = configuration.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_PROTOCOL, DEFAULT_MI_VERSION);
        }
        catch (CoreException coreException) {}
        int miIndex = 0;
        int i2 = 0;
        while (i2 < miVersions.length) {
            if (miVersions[i2].equals(mi)) {
                miIndex = i2;
                break;
            }
            ++i2;
        }
        this.fProtocolCombo.select(miIndex);
        boolean verboseMode = false;
        try {
            verboseMode = configuration.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_VERBOSE_MODE, false);
        }
        catch (CoreException coreException) {}
        this.fVerboseModeButton.setSelection(verboseMode);
        Control[] changed = new Control[]{this.fCommandFactoryCombo, this.fProtocolCombo};
        ((Composite)this.getControl()).layout(changed);
        this.setInitializing(false);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String str = this.fGDBCommandText.getText();
        str.trim();
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, str);
        str = this.fGDBInitText.getText();
        str.trim();
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_GDB_INIT, str);
        str = this.fCommandFactoryCombo.getText();
        int index = this.fCommandFactoryCombo.indexOf(str);
        str = index < 0 ? "" : this.fCommandFactoryDescriptors[index].getIdentifier();
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_COMMAND_FACTORY, str);
        str = this.fProtocolCombo.getText();
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_PROTOCOL, str);
        if (this.fSolibBlock != null) {
            this.fSolibBlock.performApply(configuration);
        }
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_VERBOSE_MODE, this.fVerboseModeButton.getSelection());
    }

    public String getName() {
        return MIUIMessages.getString("StandardGDBDebuggerPage.1");
    }

    protected Shell getShell() {
        return super.getShell();
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }

    public void update(Observable o, Object arg) {
        if (!this.isInitializing()) {
            this.updateLaunchConfigurationDialog();
        }
    }

    public IMILaunchConfigurationComponent createSolibBlock(Composite parent) {
        IMILaunchConfigurationComponent block = MIUIUtils.createGDBSolibBlock(true, true);
        block.createControl(parent);
        return block;
    }

    public void createTabs(TabFolder tabFolder) {
        this.createMainTab(tabFolder);
        this.createSolibTab(tabFolder);
    }

    public void createMainTab(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(MIUIMessages.getString("StandardGDBDebuggerPage.2"));
        Composite comp = ControlFactory.createCompositeEx((Composite)tabFolder, (int)1, (int)1808);
        ((GridLayout)comp.getLayout()).makeColumnsEqualWidth = false;
        comp.setFont(tabFolder.getFont());
        tabItem.setControl((Control)comp);
        Composite subComp = ControlFactory.createCompositeEx((Composite)comp, (int)3, (int)768);
        ((GridLayout)subComp.getLayout()).makeColumnsEqualWidth = false;
        subComp.setFont(tabFolder.getFont());
        Label label = ControlFactory.createLabel((Composite)subComp, (String)MIUIMessages.getString("StandardGDBDebuggerPage.3"));
        GridData gd = new GridData();
        label.setLayoutData((Object)gd);
        this.fGDBCommandText = ControlFactory.createTextField((Composite)subComp, (int)2052);
        this.fGDBCommandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                if (!StandardGDBDebuggerPage.this.isInitializing()) {
                    StandardGDBDebuggerPage.this.updateLaunchConfigurationDialog();
                }
            }
        });
        Button button = this.createPushButton(subComp, MIUIMessages.getString("StandardGDBDebuggerPage.4"), null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                this.handleGDBButtonSelected();
                StandardGDBDebuggerPage.this.updateLaunchConfigurationDialog();
            }

            private void handleGDBButtonSelected() {
                String res;
                FileDialog dialog = new FileDialog(StandardGDBDebuggerPage.this.getShell(), 0);
                dialog.setText(MIUIMessages.getString("StandardGDBDebuggerPage.5"));
                String gdbCommand = StandardGDBDebuggerPage.this.fGDBCommandText.getText().trim();
                int lastSeparatorIndex = gdbCommand.lastIndexOf(File.separator);
                if (lastSeparatorIndex != -1) {
                    dialog.setFilterPath(gdbCommand.substring(0, lastSeparatorIndex));
                }
                if ((res = dialog.open()) == null) {
                    return;
                }
                StandardGDBDebuggerPage.this.fGDBCommandText.setText(res);
            }
        });
        label = ControlFactory.createLabel((Composite)subComp, (String)MIUIMessages.getString("StandardGDBDebuggerPage.6"));
        gd = new GridData();
        label.setLayoutData((Object)gd);
        this.fGDBInitText = ControlFactory.createTextField((Composite)subComp, (int)2052);
        gd = new GridData(768);
        this.fGDBInitText.setLayoutData((Object)gd);
        this.fGDBInitText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                if (!StandardGDBDebuggerPage.this.isInitializing()) {
                    StandardGDBDebuggerPage.this.updateLaunchConfigurationDialog();
                }
            }
        });
        button = this.createPushButton(subComp, MIUIMessages.getString("StandardGDBDebuggerPage.7"), null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                this.handleGDBInitButtonSelected();
                StandardGDBDebuggerPage.this.updateLaunchConfigurationDialog();
            }

            private void handleGDBInitButtonSelected() {
                String res;
                FileDialog dialog = new FileDialog(StandardGDBDebuggerPage.this.getShell(), 0);
                dialog.setText(MIUIMessages.getString("StandardGDBDebuggerPage.8"));
                String gdbCommand = StandardGDBDebuggerPage.this.fGDBInitText.getText().trim();
                int lastSeparatorIndex = gdbCommand.lastIndexOf(File.separator);
                if (lastSeparatorIndex != -1) {
                    dialog.setFilterPath(gdbCommand.substring(0, lastSeparatorIndex));
                }
                if ((res = dialog.open()) == null) {
                    return;
                }
                StandardGDBDebuggerPage.this.fGDBInitText.setText(res);
            }
        });
        label = ControlFactory.createLabel((Composite)subComp, (String)MIUIMessages.getString("StandardGDBDebuggerPage.9"), (int)200, (int)-1, (int)64);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.widthHint = 200;
        label.setLayoutData((Object)gd);
        Composite options = ControlFactory.createCompositeEx((Composite)subComp, (int)2, (int)768);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        options.setLayoutData((Object)gd);
        this.createCommandFactoryCombo(options);
        this.createProtocolCombo(options);
        this.createVerboseModeButton(subComp);
    }

    public void createSolibTab(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(MIUIMessages.getString("StandardGDBDebuggerPage.10"));
        Composite comp = ControlFactory.createCompositeEx((Composite)this.fTabFolder, (int)1, (int)1808);
        comp.setFont(tabFolder.getFont());
        tabItem.setControl((Control)comp);
        this.fSolibBlock = this.createSolibBlock(comp);
        if (this.fSolibBlock instanceof Observable) {
            ((Observable)((Object)this.fSolibBlock)).addObserver(this);
        }
    }

    public void dispose() {
        if (this.fSolibBlock != null) {
            if (this.fSolibBlock instanceof Observable) {
                ((Observable)((Object)this.fSolibBlock)).deleteObserver(this);
            }
            this.fSolibBlock.dispose();
        }
        super.dispose();
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    protected boolean isInitializing() {
        return this.fIsInitializing;
    }

    private void setInitializing(boolean isInitializing) {
        this.fIsInitializing = isInitializing;
    }

    protected void createCommandFactoryCombo(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(MIUIMessages.getString("StandardGDBDebuggerPage.12"));
        this.fCommandFactoryCombo = new Combo(parent, 12);
        this.fCommandFactoryCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (!StandardGDBDebuggerPage.this.isInitializing()) {
                    StandardGDBDebuggerPage.this.updateLaunchConfigurationDialog();
                }
            }

            public void widgetSelected(SelectionEvent e) {
                if (!StandardGDBDebuggerPage.this.isInitializing()) {
                    StandardGDBDebuggerPage.this.updateLaunchConfigurationDialog();
                }
            }
        });
    }

    protected void createProtocolCombo(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(MIUIMessages.getString("StandardGDBDebuggerPage.11"));
        this.fProtocolCombo = new Combo(parent, 12);
        this.fProtocolCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (!StandardGDBDebuggerPage.this.isInitializing()) {
                    StandardGDBDebuggerPage.this.updateLaunchConfigurationDialog();
                }
            }

            public void widgetSelected(SelectionEvent e) {
                if (!StandardGDBDebuggerPage.this.isInitializing()) {
                    StandardGDBDebuggerPage.this.updateLaunchConfigurationDialog();
                }
            }
        });
    }

    protected String getCurrentCommandFactoryID() {
        String name = this.fCommandFactoryCombo.getText();
        int i = 0;
        while (i < this.fCommandFactoryDescriptors.length) {
            if (this.fCommandFactoryDescriptors[i].getName().equals(name)) {
                return this.fCommandFactoryDescriptors[i].getIdentifier();
            }
            ++i;
        }
        return "";
    }

    protected void createVerboseModeButton(Composite parent) {
        this.fVerboseModeButton = this.createCheckButton(parent, MIUIMessages.getString("StandardGDBDebuggerPage.13"));
        this.fVerboseModeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (!StandardGDBDebuggerPage.this.isInitializing()) {
                    StandardGDBDebuggerPage.this.updateLaunchConfigurationDialog();
                }
            }

            public void widgetSelected(SelectionEvent e) {
                if (!StandardGDBDebuggerPage.this.isInitializing()) {
                    StandardGDBDebuggerPage.this.updateLaunchConfigurationDialog();
                }
            }
        });
    }
}

