/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.gdbjtag.core;

import java.io.File;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.gdbjtag.core.GDBJtagCommandFactory;
import org.eclipse.cdt.debug.mi.core.AbstractGDBCDIDebugger;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.command.CLICommand;
import org.eclipse.cdt.debug.mi.core.command.Command;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIGDBSetNewConsole;
import org.eclipse.cdt.debug.mi.core.command.MITargetDownload;
import org.eclipse.cdt.debug.mi.core.command.MITargetSelect;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;

public class GDBJtagDebugger
extends AbstractGDBCDIDebugger {
    public ICDISession createSession(ILaunch launch, File executable, IProgressMonitor monitor) throws CoreException {
        return super.createSession(launch, executable, monitor);
    }

    public ICDISession createDebuggerSession(ILaunch launch, IBinaryParser.IBinaryObject exe, IProgressMonitor monitor) throws CoreException {
        return super.createDebuggerSession(launch, exe, monitor);
    }

    protected CommandFactory getCommandFactory(ILaunchConfiguration config) throws CoreException {
        String miVersion = MIPlugin.getMIVersion((ILaunchConfiguration)config);
        return new GDBJtagCommandFactory(miVersion);
    }

    protected void doStartSession(ILaunch launch, Session session, IProgressMonitor monitor) throws CoreException {
        String imageFileName;
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        ICDITarget[] targets = session.getTargets();
        if (targets.length == 0 || !(targets[0] instanceof Target)) {
            return;
        }
        MISession miSession = ((Target)targets[0]).getMISession();
        this.getMISession(session);
        CommandFactory factory = miSession.getCommandFactory();
        try {
            MIGDBSetNewConsole newConsole = factory.createMIGDBSetNewConsole();
            miSession.postCommand((Command)newConsole);
            MIInfo info = newConsole.getMIInfo();
            if (info == null) {
                throw new MIException(MIPlugin.getResourceString((String)"src.common.No_answer"));
            }
        }
        catch (MIException mIException) {}
        boolean useRemote = config.getAttribute("org.eclipse.cdt.debug.gdbremote.core.useRemoteTarget", true);
        if (useRemote) {
            try {
                monitor.beginTask("Connecting to remote", 1);
                String ipAddress = config.getAttribute("org.eclipse.cdt.debug.gdbremote.core.ipAddress", "localhost");
                int portNumber = config.getAttribute("org.eclipse.cdt.debug.gdbremote.core.portNumber", 10000);
                String address = String.valueOf(ipAddress) + ":" + String.valueOf(portNumber);
                MITargetSelect targetSelect = factory.createMITargetSelect(new String[]{"remote", address});
                miSession.postCommand((Command)targetSelect);
                MIInfo info = targetSelect.getMIInfo();
                if (info == null) {
                    throw new MIException(MIPlugin.getResourceString((String)"src.common.No_answer"));
                }
            }
            catch (MIException mIException) {}
        }
        monitor.beginTask("Executing init commands", 1);
        this.executeGDBScript(config, "org.eclipse.cdt.debug.gdbremote.core.initCommands", miSession);
        boolean doLoad = config.getAttribute("org.eclipse.cdt.debug.gdbremote.core.loadImage", false);
        if (doLoad && (imageFileName = config.getAttribute("org.eclipse.cdt.debug.gdbremote.core.imageFileName", "")).length() > 0) {
            try {
                monitor.beginTask("Loading image", 1);
                imageFileName = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(imageFileName);
                MITargetDownload download = factory.createMITargetDownload(imageFileName);
                miSession.postCommand((Command)download, Integer.MAX_VALUE);
                MIInfo info = download.getMIInfo();
                if (info == null) {
                    throw new MIException(MIPlugin.getResourceString((String)"src.common.No_answer"));
                }
            }
            catch (MIException mIException) {}
        }
    }

    protected MISession getMISession(Session session) {
        ICDITarget[] targets = session.getTargets();
        if (targets.length == 0 || !(targets[0] instanceof Target)) {
            return null;
        }
        return ((Target)targets[0]).getMISession();
    }

    public void doRunSession(ILaunch launch, ICDISession session, IProgressMonitor monitor) throws CoreException {
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        ICDITarget[] targets = session.getTargets();
        if (targets.length == 0 || !(targets[0] instanceof Target)) {
            return;
        }
        MISession miSession = ((Target)targets[0]).getMISession();
        monitor.beginTask("Executing run commands", 1);
        this.executeGDBScript(config, "org.eclipse.cdt.debug.gdbremote.core.runCommands", miSession);
    }

    private void executeGDBScript(ILaunchConfiguration configuration, String attribute, MISession miSession) throws CoreException {
        String script = configuration.getAttribute(attribute, "");
        script = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(script);
        String[] commands = script.split("\\r?\\n");
        int j = 0;
        while (j < commands.length) {
            try {
                CLICommand cli = new CLICommand(commands[j]);
                miSession.postCommand((Command)cli, Integer.MAX_VALUE);
                MIInfo info = cli.getMIInfo();
                if (info == null) {
                    throw new MIException("Timeout");
                }
            }
            catch (MIException e) {
                MultiStatus status = new MultiStatus("org.eclipse.cdt.debug.gdbremote.core", 150, "Failed command", (Throwable)e);
                status.add((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbremote.core", 150, e == null ? "" : e.getLocalizedMessage(), (Throwable)e));
                CDebugCorePlugin.log((IStatus)status);
            }
            ++j;
        }
    }
}

