/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c99;

import java.util.Stack;
import org.eclipse.cdt.internal.core.dom.parser.c99.C99ExprEvaluator;

public class C99ExprEvaluatorAction {
    private static int HEXADECIMAL_BASE = 16;
    private static int OCTAL_BASE = 8;
    private final Stack valueStack = new Stack();
    private final C99ExprEvaluator parser;
    private boolean errorEncountered;
    public static final int op_amper = 1;
    public static final int op_star = 2;
    public static final int op_plus = 3;
    public static final int op_minus = 4;
    public static final int op_tilde = 5;
    public static final int op_not = 6;
    public static final int op_multiply = 7;
    public static final int op_divide = 8;
    public static final int op_modulo = 9;
    public static final int op_shiftLeft = 10;
    public static final int op_shiftRight = 11;
    public static final int op_lessThan = 12;
    public static final int op_greaterThan = 13;
    public static final int op_lessEqual = 14;
    public static final int op_greaterEqual = 15;
    public static final int op_equals = 16;
    public static final int op_notequals = 17;
    public static final int op_binaryAnd = 18;
    public static final int op_binaryXor = 19;
    public static final int op_binaryOr = 20;
    public static final int op_logicalAnd = 21;
    public static final int op_logicalOr = 22;
    private static final int MULTIPLIER = 256;

    public C99ExprEvaluatorAction(C99ExprEvaluator parser) {
        this.parser = parser;
        this.errorEncountered = false;
    }

    public Long result() {
        if (this.errorEncountered || this.valueStack.size() != 1) {
            return null;
        }
        return (Long)this.valueStack.peek();
    }

    protected void evalExpressionBinaryOperator(int op) {
        long result;
        if (this.errorEncountered) {
            return;
        }
        long y = (Long)this.valueStack.pop();
        long x = (Long)this.valueStack.pop();
        switch (op) {
            case 7: {
                result = x * y;
                break;
            }
            case 8: {
                if (y == 0L) {
                    this.errorEncountered = true;
                    return;
                }
                result = x / y;
                break;
            }
            case 9: {
                result = x % y;
                break;
            }
            case 3: {
                result = x + y;
                break;
            }
            case 4: {
                result = x - y;
                break;
            }
            case 10: {
                result = x << (int)y;
                break;
            }
            case 11: {
                result = x >> (int)y;
                break;
            }
            case 12: {
                result = x < y ? 1 : 0;
                break;
            }
            case 13: {
                result = x > y ? 1 : 0;
                break;
            }
            case 14: {
                result = x <= y ? 1 : 0;
                break;
            }
            case 15: {
                result = x >= y ? 1 : 0;
                break;
            }
            case 16: {
                result = x == y ? 1 : 0;
                break;
            }
            case 17: {
                result = x != y ? 1 : 0;
                break;
            }
            case 18: {
                result = x & y;
                break;
            }
            case 19: {
                result = x ^ y;
                break;
            }
            case 20: {
                result = x | y;
                break;
            }
            case 21: {
                result = x != 0L && y != 0L ? 1 : 0;
                break;
            }
            case 22: {
                result = x != 0L || y != 0L ? 1 : 0;
                break;
            }
            default: {
                this.errorEncountered = true;
                return;
            }
        }
        this.valueStack.push(new Long(result));
    }

    protected void evalExpressionUnaryOperator(int op) {
        long result;
        if (this.errorEncountered) {
            return;
        }
        long x = (Long)this.valueStack.pop();
        switch (op) {
            case 4: {
                result = -x;
                break;
            }
            case 5: {
                result = x ^ 0xFFFFFFFFFFFFFFFFL;
                break;
            }
            case 6: {
                result = x == 0L ? 1 : 0;
                break;
            }
            case 3: {
                result = x;
                break;
            }
            default: {
                this.errorEncountered = true;
                return;
            }
        }
        this.valueStack.push(new Long(result));
    }

    protected void evalExpressionConditional() {
        if (this.errorEncountered) {
            return;
        }
        Long x3 = (Long)this.valueStack.pop();
        Long x2 = (Long)this.valueStack.pop();
        Long x1 = (Long)this.valueStack.pop();
        this.valueStack.push(x1 != 0L ? x2 : x3);
    }

    protected void evalExpressionID() {
        if (this.errorEncountered) {
            return;
        }
        this.valueStack.push(new Long(0L));
    }

    protected void evalExpressionConstantInteger() {
        if (this.errorEncountered) {
            return;
        }
        String val = this.parser.getRightIToken().toString();
        long result = (val = C99ExprEvaluatorAction.removeIntegerSuffix(val)).startsWith("0x") ? Long.parseLong(val.substring(2), HEXADECIMAL_BASE) : (val.startsWith("0") ? Long.parseLong(val, OCTAL_BASE) : Long.parseLong(val));
        this.valueStack.push(new Long(result));
    }

    private static String removeIntegerSuffix(String val) {
        int i = val.length() - 1;
        while (i > 0) {
            char c = val.charAt(i);
            if (c != 'u' && c != 'U' && c != 'l' && c != 'L') break;
            --i;
        }
        return val.substring(0, i + 1);
    }

    protected void evalExpressionConstantChar() {
        String val;
        if (this.errorEncountered) {
            return;
        }
        val = val.substring((val = this.parser.getRightIToken().toString()).startsWith("L") ? 2 : 1, val.length() - 1);
        long result = 0L;
        char[] chars = val.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (i > 0) {
                result *= 256L;
            }
            if (chars[i] == '\\') {
                switch (chars[++i]) {
                    case '\'': {
                        result += 39L;
                        ++i;
                        break;
                    }
                    case '\"': {
                        result += 34L;
                        ++i;
                        break;
                    }
                    case '?': {
                        result += 63L;
                        ++i;
                        break;
                    }
                    case '\\': {
                        result += 92L;
                        ++i;
                        break;
                    }
                    case 'a': {
                        result += 7L;
                        ++i;
                        break;
                    }
                    case 'b': {
                        result += 8L;
                        ++i;
                        break;
                    }
                    case 'f': {
                        result += 12L;
                        ++i;
                        break;
                    }
                    case 'n': {
                        result += 10L;
                        ++i;
                        break;
                    }
                    case 'r': {
                        result += 13L;
                        ++i;
                        break;
                    }
                    case 't': {
                        result += 9L;
                        ++i;
                        break;
                    }
                    case 'v': {
                        result += 11L;
                        ++i;
                        break;
                    }
                    case 'U': 
                    case 'u': {
                        int end = ++i + 3;
                        if (end + 4 < chars.length && C99ExprEvaluatorAction.isHex(chars, end + 1, end + 4)) {
                            end += 4;
                        }
                        int length = end - i + 1;
                        result += Long.parseLong(new String(chars, i, length), HEXADECIMAL_BASE);
                        i += length;
                        break;
                    }
                    case 'x': {
                        ++i;
                        StringBuffer hexVal = new StringBuffer();
                        while (C99ExprEvaluatorAction.isHex(chars[i]) && i < chars.length) {
                            hexVal.append(chars[i]);
                            ++i;
                        }
                        result += Long.parseLong(hexVal.toString(), HEXADECIMAL_BASE);
                        break;
                    }
                    default: {
                        StringBuffer octalVal = new StringBuffer(3);
                        int j = 0;
                        while (j < 3 && C99ExprEvaluatorAction.isOctal(chars[i]) && i < chars.length) {
                            octalVal.append(chars[i]);
                            ++i;
                            ++j;
                        }
                        result += Long.parseLong(octalVal.toString(), HEXADECIMAL_BASE);
                        break;
                    }
                }
                continue;
            }
            result += (long)chars[i];
            ++i;
        }
        this.valueStack.push(new Long(result));
    }

    private static boolean isHex(char c) {
        return Character.digit(c, HEXADECIMAL_BASE) != -1;
    }

    private static boolean isHex(char[] chars, int start, int end) {
        int i = start;
        while (i <= end) {
            if (!C99ExprEvaluatorAction.isHex(chars[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isOctal(char c) {
        return Character.digit(c, OCTAL_BASE) != -1;
    }
}

