/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c99;

import org.eclipse.cdt.internal.core.dom.parser.c99.C99Lexer;

public class C99LexerKind {
    public static final char HT = '\t';
    public static final char LF = '\n';
    public static final char FF = '\f';
    public static final char CR = '\r';

    public static int getKind(C99Lexer lexer, int i) {
        int streamLength = lexer.getStreamLength();
        if (i >= streamLength) {
            return 98;
        }
        char[] inputChars = lexer.getInputChars();
        int c = inputChars[i];
        if (c == 63 && i + 2 < streamLength && inputChars[i + 1] == '?') {
            char thirdChar = inputChars[i + 2];
            if (thirdChar == '/') {
                lexer.setStreamIndex(i += 2);
                c = 92;
            } else {
                int kind;
                switch (thirdChar) {
                    default: {
                        return 81;
                    }
                    case '=': {
                        kind = 82;
                        break;
                    }
                    case '(': {
                        kind = 87;
                        break;
                    }
                    case ')': {
                        kind = 88;
                        break;
                    }
                    case '\'': {
                        kind = 93;
                        break;
                    }
                    case '<': {
                        kind = 89;
                        break;
                    }
                    case '>': {
                        kind = 90;
                        break;
                    }
                    case '!': {
                        kind = 80;
                        break;
                    }
                    case '-': {
                        kind = 91;
                    }
                }
                lexer.setStreamIndex(i + 2);
                return kind;
            }
        }
        if (c == 92) {
            int j = i + 1;
            while (j < streamLength && C99LexerKind.isWSChar(inputChars[j])) {
                ++j;
            }
            if (j < streamLength && inputChars[j] == '\n') {
                lexer.setStreamIndex(j + 1);
                return C99LexerKind.getKind(lexer, j + 1);
            }
            return 41;
        }
        return C99LexerKind.getKind((char)c);
    }

    private static final boolean isWSChar(char c) {
        return c == ' ' || c == '\r' || c == '\t' || c == '\f';
    }

    private static int getKind(char c) {
        switch (c) {
            case 'a': {
                return 18;
            }
            case 'A': {
                return 24;
            }
            case 'b': {
                return 19;
            }
            case 'B': {
                return 25;
            }
            case 'c': {
                return 22;
            }
            case 'C': {
                return 26;
            }
            case 'd': {
                return 23;
            }
            case 'D': {
                return 27;
            }
            case 'e': {
                return 16;
            }
            case 'E': {
                return 17;
            }
            case 'f': {
                return 12;
            }
            case 'F': {
                return 13;
            }
            case 'g': {
                return 44;
            }
            case 'G': {
                return 56;
            }
            case 'h': {
                return 45;
            }
            case 'H': {
                return 57;
            }
            case 'i': {
                return 46;
            }
            case 'I': {
                return 58;
            }
            case 'j': {
                return 47;
            }
            case 'J': {
                return 59;
            }
            case 'k': {
                return 48;
            }
            case 'K': {
                return 60;
            }
            case 'l': {
                return 14;
            }
            case 'L': {
                return 15;
            }
            case 'm': {
                return 49;
            }
            case 'M': {
                return 61;
            }
            case 'n': {
                return 34;
            }
            case 'N': {
                return 62;
            }
            case 'o': {
                return 50;
            }
            case 'O': {
                return 63;
            }
            case 'p': {
                return 30;
            }
            case 'P': {
                return 32;
            }
            case 'q': {
                return 51;
            }
            case 'Q': {
                return 64;
            }
            case 'r': {
                return 35;
            }
            case 'R': {
                return 65;
            }
            case 's': {
                return 52;
            }
            case 'S': {
                return 66;
            }
            case 't': {
                return 36;
            }
            case 'T': {
                return 67;
            }
            case 'u': {
                return 20;
            }
            case 'U': {
                return 21;
            }
            case 'v': {
                return 37;
            }
            case 'V': {
                return 68;
            }
            case 'w': {
                return 53;
            }
            case 'W': {
                return 69;
            }
            case 'x': {
                return 31;
            }
            case 'X': {
                return 38;
            }
            case 'y': {
                return 54;
            }
            case 'Y': {
                return 70;
            }
            case 'z': {
                return 55;
            }
            case 'Z': {
                return 71;
            }
            case '0': {
                return 1;
            }
            case '1': {
                return 2;
            }
            case '2': {
                return 3;
            }
            case '3': {
                return 4;
            }
            case '4': {
                return 5;
            }
            case '5': {
                return 6;
            }
            case '6': {
                return 7;
            }
            case '7': {
                return 8;
            }
            case '8': {
                return 9;
            }
            case '9': {
                return 10;
            }
            case '_': {
                return 72;
            }
            case '\\': {
                return 41;
            }
            case '.': {
                return 28;
            }
            case '<': {
                return 76;
            }
            case '>': {
                return 29;
            }
            case '+': {
                return 39;
            }
            case '-': {
                return 40;
            }
            case '/': {
                return 77;
            }
            case '*': {
                return 78;
            }
            case '(': {
                return 85;
            }
            case ')': {
                return 86;
            }
            case '=': {
                return 11;
            }
            case '[': {
                return 87;
            }
            case ']': {
                return 88;
            }
            case '{': {
                return 89;
            }
            case '}': {
                return 90;
            }
            case '&': {
                return 79;
            }
            case '~': {
                return 91;
            }
            case '!': {
                return 92;
            }
            case '%': {
                return 42;
            }
            case '^': {
                return 93;
            }
            case '|': {
                return 80;
            }
            case '?': {
                return 81;
            }
            case ':': {
                return 33;
            }
            case ';': {
                return 94;
            }
            case ',': {
                return 95;
            }
            case '#': {
                return 82;
            }
            case '\'': {
                return 83;
            }
            case '\"': {
                return 43;
            }
            case ' ': {
                return 73;
            }
            case '$': {
                return 84;
            }
            case '\t': {
                return 74;
            }
            case '\n': {
                return 99;
            }
            case '\f': {
                return 75;
            }
            case '\r': {
                return 97;
            }
        }
        if (c == '\uffff') {
            return 98;
        }
        return 96;
    }
}

