/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c99.preprocessor;

import java.util.Iterator;
import lpg.lpgjavaruntime.IToken;
import org.eclipse.cdt.internal.core.dom.parser.c99.preprocessor.C99Token;
import org.eclipse.cdt.internal.core.dom.parser.c99.preprocessor.Messages;
import org.eclipse.cdt.internal.core.dom.parser.c99.preprocessor.TokenList;

class MacroArgument {
    private final TokenList rawTokens;
    private final IProcessCallback processCallback;
    private TokenList processedTokens = null;

    public MacroArgument(TokenList tokens, IProcessCallback processor) {
        if (tokens == null) {
            throw new IllegalArgumentException(Messages.getString("MacroArgument.0"));
        }
        this.rawTokens = tokens;
        this.processCallback = processor;
    }

    public TokenList getRawTokens() {
        return this.rawTokens.shallowCopy();
    }

    public synchronized TokenList getProcessedTokens() {
        if (this.processCallback == null) {
            return this.rawTokens;
        }
        if (this.processedTokens == null) {
            this.processedTokens = this.processCallback.process(MacroArgument.cloneTokenList(this.rawTokens));
        }
        return this.processedTokens.shallowCopy();
    }

    public boolean isEmpty() {
        return this.rawTokens.isEmpty();
    }

    private static TokenList cloneTokenList(TokenList orig) {
        TokenList clone = new TokenList();
        Iterator iter = orig.iterator();
        while (iter.hasNext()) {
            IToken token = (IToken)iter.next();
            clone.add(new C99Token(token));
        }
        return clone;
    }

    public String toString() {
        return this.rawTokens.toString();
    }

    public static interface IProcessCallback {
        public TokenList process(TokenList var1);
    }
}

