/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c99.preprocessor;

import java.util.Iterator;
import java.util.LinkedList;
import lpg.lpgjavaruntime.IToken;

public class TokenList {
    private final LinkedList list = new LinkedList();

    public TokenList() {
    }

    public TokenList(IToken token) {
        this.add(token);
    }

    public void addFirst(IToken token) {
        this.list.addFirst(token);
    }

    public void add(IToken token) {
        this.list.add(token);
    }

    public IToken removeFirst() {
        return (IToken)this.list.removeFirst();
    }

    public IToken removeLast() {
        return (IToken)this.list.removeLast();
    }

    public IToken first() {
        return (IToken)this.list.getFirst();
    }

    public IToken last() {
        return (IToken)this.list.getLast();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public int size() {
        return this.list.size();
    }

    public Iterator iterator() {
        return this.list.iterator();
    }

    public TokenList shallowCopy() {
        TokenList newList = new TokenList();
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            newList.add((IToken)iter.next());
        }
        return newList;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Iterator iter = this.iterator();
        IToken prevToken = (IToken)iter.next();
        sb.append(prevToken.toString());
        while (iter.hasNext()) {
            IToken token = (IToken)iter.next();
            TokenList.addSpaceBetween(sb, prevToken, token);
            sb.append(token.toString());
            prevToken = token;
        }
        return sb.toString();
    }

    private static void addSpaceBetween(StringBuffer sb, IToken t1, IToken t2) {
        int numSpaces = t2.getStartOffset() - (t1.getEndOffset() + 1);
        int i = 0;
        while (i < numSpaces) {
            sb.append(' ');
            ++i;
        }
    }

    public int[] kindArray() {
        int[] kinds = new int[this.list.size()];
        int i = 0;
        while (i < kinds.length) {
            kinds[i] = ((IToken)this.list.get(i)).getKind();
            ++i;
        }
        return kinds;
    }
}

