/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.internal.core.Builder;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractCBuildPropertyTab;
import org.eclipse.cdt.managedbuilder.ui.properties.ManagedBuilderUIPlugin;
import org.eclipse.cdt.managedbuilder.ui.properties.Messages;
import org.eclipse.cdt.ui.newui.AbstractCPropertyTab;
import org.eclipse.cdt.ui.newui.TriButton;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class BuilderSettingsTab
extends AbstractCBuildPropertyTab {
    private TriButton b_useDefault;
    private Combo c_builderType;
    private Text t_buildCmd;
    private TriButton b_genMakefileAuto;
    private TriButton b_expandVars;
    private Text t_dir;
    private Button b_dirWsp;
    private Button b_dirFile;
    private Button b_dirVars;
    IBuilder bld;
    Configuration cfg;

    public void createControls(Composite parent) {
        super.createControls(parent);
        this.usercomp.setLayout((Layout)new GridLayout(1, false));
        Group g1 = this.setupGroup(this.usercomp, Messages.getString("BuilderSettingsTab.0"), 3, 768);
        this.setupLabel((Composite)g1, Messages.getString("BuilderSettingsTab.1"), 1, 1);
        this.c_builderType = new Combo((Composite)g1, 2060);
        this.setupControl((Control)this.c_builderType, 2, 768);
        this.c_builderType.add(Messages.getString("BuilderSettingsTab.2"));
        this.c_builderType.add(Messages.getString("BuilderSettingsTab.3"));
        this.c_builderType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BuilderSettingsTab.this.cfg.enableInternalBuilder(BuilderSettingsTab.this.c_builderType.getSelectionIndex() == 1);
                BuilderSettingsTab.this.updateButtons();
            }
        });
        this.b_useDefault = this.setupTri((Composite)g1, Messages.getString("BuilderSettingsTab.4"), 3, 1);
        this.setupLabel((Composite)g1, Messages.getString("BuilderSettingsTab.5"), 1, 1);
        this.t_buildCmd = this.setupBlock((Composite)g1, (Control)this.b_useDefault);
        this.t_buildCmd.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String fullCommand = BuilderSettingsTab.this.t_buildCmd.getText().trim();
                String buildCommand = BuilderSettingsTab.this.parseMakeCommand(fullCommand);
                String buildArgs = fullCommand.substring(buildCommand.length()).trim();
                if (!buildCommand.equals(BuilderSettingsTab.this.bld.getCommand()) || !buildArgs.equals(BuilderSettingsTab.this.bld.getArguments())) {
                    BuilderSettingsTab.this.bld.setCommand(buildCommand);
                    BuilderSettingsTab.this.bld.setArguments(buildArgs);
                }
            }
        });
        Group g2 = this.setupGroup(this.usercomp, Messages.getString("BuilderSettingsTab.6"), 2, 768);
        ((GridLayout)g2.getLayout()).makeColumnsEqualWidth = true;
        this.b_genMakefileAuto = this.setupTri((Composite)g2, Messages.getString("BuilderSettingsTab.7"), 1, 1);
        this.b_expandVars = this.setupTri((Composite)g2, Messages.getString("BuilderSettingsTab.8"), 1, 1);
        Group g5 = this.setupGroup(this.usercomp, Messages.getString("BuilderSettingsTab.21"), 2, 768);
        this.setupLabel((Composite)g5, Messages.getString("BuilderSettingsTab.22"), 1, 1);
        this.t_dir = this.setupText((Composite)g5, 1, 768);
        this.t_dir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BuilderSettingsTab.this.bld.setBuildPath(BuilderSettingsTab.this.t_dir.getText());
            }
        });
        Composite c = new Composite((Composite)g5, 0);
        this.setupControl((Control)c, 2, 768);
        GridLayout f = new GridLayout(4, false);
        c.setLayout((Layout)f);
        Label dummy = new Label(c, 0);
        dummy.setLayoutData((Object)new GridData(768));
        this.b_dirWsp = this.setupBottomButton(c, WORKSPACEBUTTON_NAME);
        this.b_dirFile = this.setupBottomButton(c, FILESYSTEMBUTTON_NAME);
        this.b_dirVars = this.setupBottomButton(c, VARIABLESBUTTON_NAME);
    }

    void setManagedBuild(boolean enable) {
        try {
            this.bld.setManagedBuildOn(enable);
            this.page.informPages(101, null);
            this.updateButtons();
        }
        catch (CoreException coreException) {}
    }

    protected void updateButtons() {
        this.bld = this.cfg.getEditableBuilder();
        this.b_genMakefileAuto.setEnabled(this.cfg.supportsBuild(true));
        this.b_genMakefileAuto.setSelection(this.bld.isManagedBuildOn());
        this.b_useDefault.setSelection(this.bld.isDefaultBuildCmd());
        this.c_builderType.select(this.cfg.isInternalBuilderEnabled() ? 1 : 0);
        this.c_builderType.setEnabled(this.cfg.canEnableInternalBuilder(true) && this.cfg.canEnableInternalBuilder(false));
        this.t_buildCmd.setText(this.getMC());
        if (!this.bld.canKeepEnvironmentVariablesInBuildfile()) {
            this.b_expandVars.setEnabled(false);
        } else {
            this.b_expandVars.setEnabled(true);
            this.b_expandVars.setSelection(!this.bld.keepEnvironmentVariablesInBuildfile());
        }
        this.t_dir.setText(this.bld.getBuildPath());
        boolean mbOn = this.bld.isManagedBuildOn();
        this.t_dir.setEnabled(!mbOn);
        this.b_dirVars.setEnabled(!mbOn);
        this.b_dirWsp.setEnabled(!mbOn);
        this.b_dirFile.setEnabled(!mbOn);
        boolean external = this.c_builderType.getSelectionIndex() == 0;
        this.b_useDefault.setEnabled(external);
        this.t_buildCmd.setEnabled(external);
        ((Control)this.t_buildCmd.getData()).setEnabled(external & !this.b_useDefault.getSelection());
        this.b_genMakefileAuto.setEnabled(external && this.cfg.supportsBuild(true));
        this.b_expandVars.setEnabled(external && this.b_genMakefileAuto.getSelection());
        if (external) {
            this.checkPressed((Control)this.b_useDefault);
        }
    }

    Button setupBottomButton(Composite c, String name) {
        Button b = new Button(c, 8);
        b.setText(name);
        GridData fd = new GridData(2);
        fd.minimumWidth = 120;
        b.setLayoutData((Object)fd);
        b.setData((Object)this.t_dir);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BuilderSettingsTab.this.buttonVarPressed(event);
            }
        });
        return b;
    }

    private Text setupBlock(Composite c, Control check) {
        Text t = this.setupText(c, 1, 768);
        Button b = this.setupButton(c, VARIABLESBUTTON_NAME, 1, 3);
        b.setData((Object)t);
        t.setData((Object)b);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BuilderSettingsTab.this.buttonVarPressed(event);
            }
        });
        if (check != null) {
            check.setData((Object)t);
        }
        return t;
    }

    private void buttonVarPressed(SelectionEvent e) {
        Widget b = e.widget;
        if (b == null || b.getData() == null) {
            return;
        }
        if (b.getData() instanceof Text) {
            String x = null;
            if (b.equals(this.b_dirWsp)) {
                x = BuilderSettingsTab.getWorkspaceDirDialog((Shell)this.usercomp.getShell(), (String)"");
                if (x != null) {
                    ((Text)b.getData()).setText(x);
                }
            } else if (b.equals(this.b_dirFile)) {
                x = BuilderSettingsTab.getFileSystemDirDialog((Shell)this.usercomp.getShell(), (String)"");
                if (x != null) {
                    ((Text)b.getData()).setText(x);
                }
            } else {
                x = AbstractCPropertyTab.getVariableDialog((Shell)this.usercomp.getShell(), (ICConfigurationDescription)this.getResDesc().getConfiguration());
                if (x != null) {
                    ((Text)b.getData()).insert(x);
                }
            }
        }
    }

    public void checkPressed(SelectionEvent e) {
        this.checkPressed((Control)e.widget);
        this.updateButtons();
    }

    private void checkPressed(Control b) {
        if (b == null) {
            return;
        }
        boolean val = false;
        if (b instanceof Button) {
            val = ((Button)b).getSelection();
        } else if (b instanceof TriButton) {
            val = ((TriButton)b).getSelection();
        }
        if (b.getData() instanceof Text) {
            Text t = (Text)b.getData();
            if (b == this.b_useDefault) {
                val = !val;
            }
            t.setEnabled(val);
            if (t.getData() != null && t.getData() instanceof Control) {
                Control c = (Control)t.getData();
                c.setEnabled(val);
            }
        }
        try {
            if (b == this.b_useDefault) {
                this.bld.setUseDefaultBuildCmd(!val);
            } else if (b == this.b_genMakefileAuto) {
                this.setManagedBuild(val);
            } else if (b == this.b_expandVars && this.bld.canKeepEnvironmentVariablesInBuildfile()) {
                this.bld.setKeepEnvironmentVariablesInBuildfile(!val);
            }
        }
        catch (CoreException coreException) {}
    }

    private String getMC() {
        String makeCommand = this.bld.getCommand();
        String makeArgs = this.bld.getArguments();
        if (makeArgs != null) {
            makeCommand = String.valueOf(makeCommand) + " " + makeArgs;
        }
        return makeCommand;
    }

    public void updateData(ICResourceDescription cfgd) {
        if (cfgd == null) {
            return;
        }
        IConfiguration icfg = this.getCfg(cfgd.getConfiguration());
        if (!(icfg instanceof Configuration)) {
            return;
        }
        this.cfg = (Configuration)icfg;
        this.updateButtons();
    }

    public void performApply(ICResourceDescription src, ICResourceDescription dst) {
        Configuration cfg01 = (Configuration)this.getCfg(src.getConfiguration());
        Configuration cfg02 = (Configuration)this.getCfg(dst.getConfiguration());
        cfg02.enableInternalBuilder(cfg01.isInternalBuilderEnabled());
        BuilderSettingsTab.copyBuilders(cfg01.getBuilder(), cfg02.getEditableBuilder());
    }

    static void copyBuilders(IBuilder b1, IBuilder b2) {
        try {
            b2.setUseDefaultBuildCmd(b1.isDefaultBuildCmd());
            if (!b1.isDefaultBuildCmd()) {
                b2.setCommand(b1.getCommand());
                b2.setArguments(b1.getArguments());
            } else {
                b2.setCommand(null);
                b2.setArguments(null);
            }
            b2.setStopOnError(b1.isStopOnError());
            b2.setParallelBuildOn(b1.isParallelBuildOn());
            b2.setParallelizationNum(b1.getParallelizationNum());
            if (b2.canKeepEnvironmentVariablesInBuildfile()) {
                b2.setKeepEnvironmentVariablesInBuildfile(b1.keepEnvironmentVariablesInBuildfile());
            }
            ((Builder)b2).setBuildPath(((Builder)b1).getBuildPathAttribute());
            b2.setAutoBuildEnable(b1.isAutoBuildEnable());
            b2.setBuildAttribute("org.eclipse.cdt.make.core.build.target.auto", b1.getBuildAttribute("org.eclipse.cdt.make.core.build.target.auto", ""));
            b2.setCleanBuildEnable(b1.isCleanBuildEnabled());
            b2.setBuildAttribute("org.eclipse.cdt.make.core.build.target.clean", b1.getBuildAttribute("org.eclipse.cdt.make.core.build.target.clean", ""));
            b2.setIncrementalBuildEnable(b1.isIncrementalBuildEnabled());
            b2.setBuildAttribute("org.eclipse.cdt.make.core.build.target.inc", b1.getBuildAttribute("org.eclipse.cdt.make.core.build.target.inc", ""));
            b2.setManagedBuildOn(b1.isManagedBuildOn());
        }
        catch (CoreException ex) {
            ManagedBuilderUIPlugin.log(ex);
        }
    }

    private String parseMakeCommand(String rawCommand) {
        String[] result = rawCommand.split("\\s");
        if (result != null && result.length > 0) {
            return result[0];
        }
        return rawCommand;
    }

    public boolean canBeVisible() {
        return this.page.isForProject() || this.page.isForPrefs();
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
    }

    protected void performDefaults() {
        BuilderSettingsTab.copyBuilders(this.bld.getSuperClass(), this.bld);
        this.updateData(this.getResDesc());
    }
}

