/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.cdtvariables.ICdtVariable;
import org.eclipse.cdt.core.cdtvariables.ICdtVariableManager;
import org.eclipse.cdt.core.cdtvariables.ICdtVariableStatus;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.internal.core.cdtvariables.CdtVariableManager;
import org.eclipse.cdt.internal.core.cdtvariables.EclipseVariablesVariableSupplier;
import org.eclipse.cdt.internal.core.cdtvariables.StorableCdtVariables;
import org.eclipse.cdt.internal.core.cdtvariables.UserDefinedVariableSupplier;
import org.eclipse.cdt.managedbuilder.ui.properties.Messages;
import org.eclipse.cdt.managedbuilder.ui.properties.NewVarDialog;
import org.eclipse.cdt.ui.newui.AbstractCPropertyTab;
import org.eclipse.cdt.ui.newui.CDTListComparator;
import org.eclipse.cdt.ui.newui.PrefPage_Abstract;
import org.eclipse.cdt.ui.newui.UIMessages;
import org.eclipse.cdt.utils.cdtvariables.CdtVariableResolver;
import org.eclipse.cdt.utils.envvar.EnvVarOperationProcessor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class CPropertyVarsTab
extends AbstractCPropertyTab {
    private static final String PREFIX = "MacrosBlock";
    private static final String LABEL = "MacrosBlock.label";
    private static final String HEADER = "MacrosBlock.label.header";
    private static final String HEADER_NAME = "MacrosBlock.label.header.name";
    private static final String HEADER_TYPE = "MacrosBlock.label.header.type";
    private static final String HEADER_VALUE = "MacrosBlock.label.header.value";
    private static final String TYPE = "MacrosBlock.label.type";
    private static final String TYPE_TEXT = "MacrosBlock.label.type.text";
    private static final String TYPE_TEXT_LIST = "MacrosBlock.label.type.text.list";
    private static final String TYPE_PATH_FILE = "MacrosBlock.label.type.path.file";
    private static final String TYPE_PATH_FILE_LIST = "MacrosBlock.label.type.path.file.list";
    private static final String TYPE_PATH_DIR = "MacrosBlock.label.type.path.dir";
    private static final String TYPE_PATH_DIR_LIST = "MacrosBlock.label.type.path.dir.list";
    private static final String TYPE_PATH_ANY = "MacrosBlock.label.type.path.any";
    private static final String TYPE_PATH_ANY_LIST = "MacrosBlock.label.type.path.any.list";
    private static final String DELETE_CONFIRM_TITLE = "MacrosBlock.label.delete.confirm.title";
    private static final String DELETE_CONFIRM_MESSAGE = "MacrosBlock.label.delete.confirm.message";
    private static final String DELETE_ALL_CONFIRM_TITLE = "MacrosBlock.label.delete.all.confirm.title";
    private static final String DELETE_ALL_CONFIRM_MESSAGE = "MacrosBlock.label.delete.all.confirm.message";
    private static final String VALUE = "MacrosBlock.label.value";
    private static final String VALUE_ECLIPSE_DYNAMIC = "MacrosBlock.label.value.eclipse.dynamic";
    private static final String VALUE_DELIMITER = " || ";
    private static final ICdtVariableManager mgr = CCorePlugin.getDefault().getCdtVariableManager();
    private static final UserDefinedVariableSupplier fUserSupplier = CdtVariableManager.fUserDefinedMacroSupplier;
    private ICConfigurationDescription cfgd = null;
    private StorableCdtVariables vars = null;
    private static final String[] fHiddenMacros = new String[]{"CWD", "PWD"};
    private boolean fShowSysMacros = false;
    private Set fIncorrectlyDefinedMacrosNames = new HashSet();
    private static final int CONTEXT = 3;
    private TableViewer tv;
    private Label fStatusLabel;
    private static final String[] fEditableTableColumnProps = new String[]{"editable name", "editable type", "editable value"};
    private static final String[] fTableColumnNames = new String[]{UIMessages.getString((String)"MacrosBlock.label.header.name"), UIMessages.getString((String)"MacrosBlock.label.header.type"), UIMessages.getString((String)"MacrosBlock.label.header.value")};
    private static final ColumnLayoutData[] fTableColumnLayouts = new ColumnLayoutData[]{new ColumnPixelData(100), new ColumnPixelData(100), new ColumnPixelData(250)};

    private void handleSelectionChanged(SelectionChangedEvent event) {
        this.updateButtons();
    }

    protected void updateButtons() {
        Object[] obs = ((IStructuredSelection)this.tv.getSelection()).toArray();
        boolean canEdit = false;
        boolean canDel = false;
        if (obs != null && obs.length > 0) {
            canEdit = obs.length == 1;
            int i = 0;
            while (i < obs.length) {
                if (obs[i] instanceof ICdtVariable && this.isUserVar((ICdtVariable)obs[i])) {
                    canDel = true;
                    break;
                }
                ++i;
            }
        }
        this.buttonSetEnabled(1, canEdit);
        this.buttonSetEnabled(2, canDel);
    }

    public void buttonPressed(int index) {
        switch (index) {
            case 0: {
                ICdtVariable macro;
                NewVarDialog dlg = new NewVarDialog(this.usercomp.getShell(), null, this.cfgd, mgr.getVariables(this.cfgd));
                if (dlg.open() != 0 || !this.canCreate(macro = dlg.getDefinedMacro())) break;
                if (this.cfgd != null) {
                    if (dlg.isForAllCfgs) {
                        ICConfigurationDescription[] cfgs = this.page.getCfgsEditable();
                        int k = 0;
                        while (k < cfgs.length) {
                            fUserSupplier.createMacro(macro, 3, (Object)cfgs[k]);
                            ++k;
                        }
                    } else {
                        fUserSupplier.createMacro(macro, 3, (Object)this.cfgd);
                    }
                } else if (this.vars != null) {
                    this.vars.createMacro(macro);
                }
                this.updateData();
                break;
            }
            case 1: {
                ICdtVariable macro;
                NewVarDialog dlg;
                ICdtVariable[] _vars = this.getSelectedUserMacros();
                if (_vars == null || _vars.length != 1 || (dlg = new NewVarDialog(this.usercomp.getShell(), _vars[0], this.cfgd, mgr.getVariables(this.cfgd))).open() != 0 || !this.canCreate(macro = dlg.getDefinedMacro())) break;
                if (this.cfgd != null) {
                    fUserSupplier.createMacro(macro, 3, (Object)this.cfgd);
                } else if (this.vars != null) {
                    this.vars.createMacro(macro);
                }
                this.updateData();
                break;
            }
            case 2: {
                ICdtVariable[] macros = this.getSelectedUserMacros();
                if (macros == null || macros.length <= 0 || !MessageDialog.openQuestion((Shell)this.usercomp.getShell(), (String)UIMessages.getString((String)DELETE_CONFIRM_TITLE), (String)UIMessages.getString((String)DELETE_CONFIRM_MESSAGE))) break;
                int i = 0;
                while (i < macros.length) {
                    if (this.cfgd != null) {
                        fUserSupplier.deleteMacro(macros[i].getName(), 3, (Object)this.cfgd);
                    } else if (this.vars != null) {
                        this.vars.deleteMacro(macros[i].getName());
                    }
                    ++i;
                }
                this.updateData();
            }
        }
    }

    private ICdtVariable[] getSelectedUserMacros() {
        if (this.tv == null) {
            return null;
        }
        List list = ((IStructuredSelection)this.tv.getSelection()).toList();
        return list.toArray(new ICdtVariable[list.size()]);
    }

    protected void performDefaults() {
        if (MessageDialog.openQuestion((Shell)this.usercomp.getShell(), (String)UIMessages.getString((String)DELETE_ALL_CONFIRM_TITLE), (String)UIMessages.getString((String)DELETE_ALL_CONFIRM_MESSAGE))) {
            if (this.cfgd != null) {
                fUserSupplier.deleteAll(3, (Object)this.cfgd);
            } else if (this.vars != null) {
                this.vars.deleteAll();
            }
            this.updateData();
        }
    }

    public void createControls(Composite parent) {
        super.createControls(parent);
        this.initButtons(new String[]{ADD_STR, EDIT_STR, DEL_STR});
        this.usercomp.setLayout((Layout)new GridLayout(1, false));
        this.createTableControl();
        final Button b = new Button(this.usercomp, 32);
        b.setFont(this.usercomp.getFont());
        b.setText(Messages.getString("CPropertyVarsTab.0"));
        b.setLayoutData((Object)new GridData(768));
        b.setSelection(this.fShowSysMacros);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CPropertyVarsTab.this.fShowSysMacros = b.getSelection();
                CPropertyVarsTab.this.updateData(CPropertyVarsTab.this.getResDesc());
            }
        });
        this.fStatusLabel = new Label(this.usercomp, 16384);
        this.fStatusLabel.setFont(this.usercomp.getFont());
        this.fStatusLabel.setText("");
        this.fStatusLabel.setLayoutData((Object)new GridData(1));
        this.fStatusLabel.setForeground(JFaceResources.getColorRegistry().get("ERROR_COLOR"));
    }

    private void createTableControl() {
        TableViewer tableViewer = new TableViewer(this.usercomp, 68354);
        Table table = tableViewer.getTable();
        TableLayout tableLayout = new TableLayout();
        int i = 0;
        while (i < fTableColumnNames.length) {
            tableLayout.addColumnData(fTableColumnLayouts[i]);
            TableColumn tc = new TableColumn(table, 0, i);
            tc.setResizable(CPropertyVarsTab.fTableColumnLayouts[i].resizable);
            tc.setText(fTableColumnNames[i]);
            ++i;
        }
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gd = new GridData(1808);
        tableViewer.getControl().setLayoutData((Object)gd);
        tableViewer.setContentProvider((IContentProvider)new MacroContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new MacroLabelProvider());
        tableViewer.setSorter(new ViewerSorter());
        tableViewer.setColumnProperties(fEditableTableColumnProps);
        this.tv = tableViewer;
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CPropertyVarsTab.this.handleSelectionChanged(event);
            }
        });
        tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!CPropertyVarsTab.this.tv.getSelection().isEmpty()) {
                    CPropertyVarsTab.this.buttonPressed(1);
                }
            }
        });
        table.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    CPropertyVarsTab.this.buttonPressed(2);
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        table.setLayoutData((Object)new GridData(1808));
    }

    private boolean canCreate(ICdtVariable v) {
        if (v == null) {
            return false;
        }
        String name = v.getName();
        if (name == null || (name = name.trim()).length() == 0) {
            return false;
        }
        if (fHiddenMacros != null) {
            int i = 0;
            while (i < fHiddenMacros.length) {
                if (fHiddenMacros[i].equals(EnvVarOperationProcessor.normalizeName((String)name))) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public void updateData(ICResourceDescription _cfgd) {
        if (_cfgd == null) {
            this.cfgd = null;
            if (this.vars == null) {
                this.vars = fUserSupplier.getWorkspaceVariablesCopy();
            }
        } else {
            this.cfgd = _cfgd.getConfiguration();
            this.vars = null;
        }
        this.updateData();
    }

    private void updateData() {
        if (this.tv == null) {
            return;
        }
        try {
            mgr.checkVariableIntegrity(this.cfgd);
            this.updateState(null);
        }
        catch (CdtVariableException e) {
            this.updateState(e);
        }
        ICdtVariable[] _vars = mgr.getVariables(this.cfgd);
        if (_vars == null) {
            return;
        }
        if (this.cfgd == null) {
            if (this.fShowSysMacros) {
                ArrayList<ICdtVariable> lst = new ArrayList<ICdtVariable>(_vars.length);
                ICdtVariable[] uvars = this.vars.getMacros();
                int i = 0;
                while (i < uvars.length) {
                    lst.add(uvars[i]);
                    int j = 0;
                    while (j < _vars.length) {
                        if (_vars[j] != null && _vars[j].getName().equals(uvars[i].getName())) {
                            _vars[j] = null;
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
                int j = 0;
                while (j < _vars.length) {
                    if (_vars[j] != null && !mgr.isUserVariable(_vars[j], null)) {
                        lst.add(_vars[j]);
                    }
                    ++j;
                }
                _vars = lst.toArray(new ICdtVariable[lst.size()]);
            } else {
                _vars = this.vars.getMacros();
            }
        }
        ArrayList<ICdtVariable> list = new ArrayList<ICdtVariable>(_vars.length);
        int i = 0;
        while (i < _vars.length) {
            if (_vars[i] != null && (this.fShowSysMacros || this.isUserVar(_vars[i]))) {
                list.add(_vars[i]);
            }
            ++i;
        }
        Collections.sort(list, CDTListComparator.getInstance());
        this.tv.setInput((Object)list.toArray(new ICdtVariable[list.size()]));
        this.updateButtons();
    }

    private void updateState(CdtVariableException e) {
        this.fIncorrectlyDefinedMacrosNames.clear();
        if (e != null) {
            this.fStatusLabel.setText(e.getMessage());
            this.fStatusLabel.setVisible(true);
            ICdtVariableStatus[] statuses = e.getVariableStatuses();
            int i = 0;
            while (i < statuses.length) {
                String name = statuses[i].getVariableName();
                if (name != null) {
                    this.fIncorrectlyDefinedMacrosNames.add(name);
                }
                ++i;
            }
        } else {
            this.fStatusLabel.setVisible(false);
        }
    }

    private boolean isUserVar(ICdtVariable v) {
        return this.cfgd != null ? mgr.isUserVariable(v, this.cfgd) : this.vars.contains(v);
    }

    private boolean isDynamic(ICdtVariable v) {
        EclipseVariablesVariableSupplier.EclipseVarMacro evar;
        return v instanceof EclipseVariablesVariableSupplier.EclipseVarMacro && (evar = (EclipseVariablesVariableSupplier.EclipseVarMacro)v).getVariable() instanceof IDynamicVariable;
    }

    private String getString(ICdtVariable v) {
        if (this.isDynamic(v)) {
            return UIMessages.getString((String)VALUE_ECLIPSE_DYNAMIC);
        }
        String value = "";
        try {
            value = CdtVariableResolver.isStringListVariable((int)v.getValueType()) ? mgr.convertStringListToString(v.getStringListValue(), VALUE_DELIMITER) : v.getStringValue();
        }
        catch (CdtVariableException cdtVariableException) {}
        return value;
    }

    public void performApply(ICResourceDescription src, ICResourceDescription dst) {
        if (this.cfgd != null) {
            ICdtVariable[] vs = fUserSupplier.getMacros(3, (Object)src.getConfiguration());
            fUserSupplier.setMacros(vs, 3, (Object)dst.getConfiguration());
        } else if (this.vars != null) {
            fUserSupplier.storeWorkspaceVariables(true);
        }
    }

    protected void performOK() {
        if (this.vars != null) {
            try {
                if (fUserSupplier.setWorkspaceVariables(this.vars) && this.page instanceof PrefPage_Abstract) {
                    PrefPage_Abstract.isChanged = true;
                }
            }
            catch (CoreException coreException) {}
        }
        this.vars = null;
        super.performOK();
    }

    protected void performCancel() {
        this.vars = null;
        super.performCancel();
    }

    public boolean canBeVisible() {
        return this.page.isForProject() || this.page.isForPrefs();
    }

    private class MacroContentProvider
    implements IStructuredContentProvider {
        private MacroContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return (Object[])inputElement;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class MacroLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IFontProvider,
    ITableFontProvider,
    IColorProvider {
        private MacroLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }

        public Font getFont(Object element) {
            return this.getFont(element, 0);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ICdtVariable var = (ICdtVariable)element;
            switch (columnIndex) {
                case 0: {
                    return var.getName();
                }
                case 1: {
                    switch (var.getValueType()) {
                        case 3: {
                            return UIMessages.getString((String)CPropertyVarsTab.TYPE_PATH_FILE);
                        }
                        case 4: {
                            return UIMessages.getString((String)CPropertyVarsTab.TYPE_PATH_FILE_LIST);
                        }
                        case 5: {
                            return UIMessages.getString((String)CPropertyVarsTab.TYPE_PATH_DIR);
                        }
                        case 6: {
                            return UIMessages.getString((String)CPropertyVarsTab.TYPE_PATH_DIR_LIST);
                        }
                        case 7: {
                            return UIMessages.getString((String)CPropertyVarsTab.TYPE_PATH_ANY);
                        }
                        case 8: {
                            return UIMessages.getString((String)CPropertyVarsTab.TYPE_PATH_ANY_LIST);
                        }
                        case 1: {
                            return UIMessages.getString((String)CPropertyVarsTab.TYPE_TEXT);
                        }
                        case 2: {
                            return UIMessages.getString((String)CPropertyVarsTab.TYPE_TEXT_LIST);
                        }
                    }
                    return "? " + var.getValueType();
                }
                case 2: {
                    return CPropertyVarsTab.this.getString(var);
                }
            }
            return "";
        }

        private Font getValueFont(ICdtVariable var) {
            Font font = null;
            if (CPropertyVarsTab.this.isUserVar(var)) {
                font = JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.dialogfont");
            }
            return font;
        }

        public Font getFont(Object element, int columnIndex) {
            ICdtVariable var = (ICdtVariable)element;
            switch (columnIndex) {
                case 0: 
                case 1: {
                    break;
                }
                case 2: {
                    return this.getValueFont(var);
                }
            }
            if (CPropertyVarsTab.this.isUserVar(var)) {
                return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
            }
            return null;
        }

        public Color getForeground(Object element) {
            if (CPropertyVarsTab.this.fIncorrectlyDefinedMacrosNames.contains(((ICdtVariable)element).getName())) {
                return JFaceResources.getColorRegistry().get("ERROR_COLOR");
            }
            return null;
        }
    }
}

