/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFileInfo;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractCBuildPropertyTab;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildListComparator;
import org.eclipse.cdt.managedbuilder.ui.properties.Messages;
import org.eclipse.cdt.managedbuilder.ui.properties.ToolSelectionDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ToolChainEditTab
extends AbstractCBuildPropertyTab {
    private static final String NO_TC = Messages.getString("StdProjectTypeHandler.0");
    private static final IToolChain[] r_tcs = ManagedBuildManager.getRealToolChains();
    private static final IBuilder[] r_bs = ManagedBuildManager.getRealBuilders();
    private static final ITool[] r_tools = ManagedBuildManager.getRealTools();
    private Text text;
    private Button b_dispCompatible;
    private Combo c_toolchain;
    private Combo c_builder;
    private Combo c_tool;
    private IBuilder[] v_bs;
    private IToolChain[] v_tcs;
    private ITool[] v_tools;
    private IConfiguration cfg;
    private IResourceInfo ri;

    public void createControls(Composite parent) {
        super.createControls(parent);
        this.usercomp.setLayout((Layout)new GridLayout(2, false));
        this.b_dispCompatible = this.setupCheck(this.usercomp, Messages.getString("ToolChainEditTab.0"), 2, 1);
        this.b_dispCompatible.setSelection(true);
        this.setupLabel(this.usercomp, Messages.getString("ToolChainEditTab.1"), 2, 1);
        this.c_toolchain = new Combo(this.usercomp, 2060);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.c_toolchain.setLayoutData((Object)gd);
        this.c_toolchain.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ToolChainEditTab.this.modifyToolchain();
            }
        });
        this.c_toolchain.setEnabled(!this.page.isForFile());
        this.setupLabel(this.usercomp, Messages.getString("ToolChainEditTab.2"), 2, 1);
        this.c_builder = new Combo(this.usercomp, 2060);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.c_builder.setLayoutData((Object)gd);
        this.c_builder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ToolChainEditTab.this.modifyBuilder();
            }
        });
        this.c_builder.setEnabled(this.page.isForProject());
        if (this.page.isForFile()) {
            Group g = this.setupGroup(this.usercomp, Messages.getString("ToolChainEditTab.5"), 2, 1808);
            this.c_tool = new Combo((Composite)g, 2060);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.c_tool.setLayoutData((Object)gd);
            this.c_tool.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ToolChainEditTab.this.saveToolSelected();
                }
            });
        } else {
            Group g = this.setupGroup(this.usercomp, Messages.getString("ToolChainEditTab.3"), 2, 1808);
            this.text = new Text((Composite)g, 2890);
            gd = new GridData(1808);
            gd.grabExcessHorizontalSpace = true;
            this.text.setLayoutData((Object)gd);
            Button button_edit = new Button((Composite)g, 8);
            GridData gdb = new GridData(4);
            gdb.grabExcessHorizontalSpace = false;
            gdb.horizontalAlignment = 4;
            gdb.widthHint = 80;
            button_edit.setLayoutData((Object)gdb);
            button_edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ToolChainEditTab.this.modifyTools();
                }
            });
            button_edit.setLayoutData((Object)new GridData(3));
            button_edit.setText(Messages.getString("ToolChainEditTab.4"));
        }
    }

    public void updateData(ICResourceDescription rcfg) {
        this.cfg = this.getCfg(rcfg.getConfiguration());
        this.ri = this.cfg.getResourceInfo(rcfg.getPath(), false);
        this.updateData();
    }

    private void updateData() {
        this.v_tcs = new IToolChain[r_tcs.length];
        this.v_bs = new IBuilder[r_bs.length];
        this.v_tools = new ITool[r_tools.length];
        IToolChain tc = null;
        if (this.ri instanceof IFolderInfo) {
            tc = ManagedBuildManager.getRealToolChain((IToolChain)((IFolderInfo)this.ri).getToolChain());
        }
        int cnt = 0;
        int pos = -1;
        this.c_toolchain.removeAll();
        int i = 0;
        while (i < r_tcs.length) {
            if (!(r_tcs[i].isSystemObject() || this.b_dispCompatible.getSelection() && this.ri instanceof IFolderInfo && !((IFolderInfo)this.ri).isToolChainCompatible(r_tcs[i]))) {
                this.c_toolchain.add(r_tcs[i].getUniqueRealName());
                this.v_tcs[cnt] = r_tcs[i];
                if (r_tcs[i].equals(tc)) {
                    pos = cnt;
                }
                ++cnt;
            }
            ++i;
        }
        if (!this.b_dispCompatible.getSelection() && !this.cfg.getBuilder().isManagedBuildOn()) {
            this.c_toolchain.add(NO_TC);
        }
        if (pos != -1) {
            this.c_toolchain.select(pos);
            this.c_builder.setEnabled(true);
        } else {
            if (this.cfg.getBuilder().isManagedBuildOn()) {
                this.c_toolchain.setText("");
            } else {
                this.c_toolchain.select(this.c_toolchain.getItemCount() - 1);
            }
            this.c_builder.setEnabled(false);
        }
        IBuilder b = ManagedBuildManager.getRealBuilder((IBuilder)this.cfg.getBuilder());
        cnt = 0;
        pos = -1;
        this.c_builder.removeAll();
        int i2 = 0;
        while (i2 < r_bs.length) {
            if (!(r_bs[i2].isSystemObject() || this.b_dispCompatible.getSelection() && !this.cfg.isBuilderCompatible(r_bs[i2]))) {
                this.c_builder.add(r_bs[i2].getUniqueRealName());
                this.v_bs[cnt] = r_bs[i2];
                if (r_bs[i2].equals(b)) {
                    pos = cnt;
                }
                ++cnt;
            }
            ++i2;
        }
        if (pos != -1) {
            this.c_builder.select(pos);
        } else {
            this.c_builder.setText("");
        }
        cnt = 0;
        i2 = 0;
        while (i2 < r_tools.length) {
            if (!r_tools[i2].isSystemObject()) {
                this.v_tools[cnt++] = r_tools[i2];
            }
            ++i2;
        }
        ITool[] tmp = new ITool[cnt];
        System.arraycopy(this.v_tools, 0, tmp, 0, cnt);
        Arrays.sort(tmp, BuildListComparator.getInstance());
        this.v_tools = tmp;
        if (this.page.isForFile()) {
            int i3;
            this.c_tool.removeAll();
            ITool[] tools = this.ri.getTools();
            ITool curr = null;
            ITool real = null;
            if (tools != null && tools.length > 0) {
                i3 = 0;
                while (i3 < tools.length) {
                    if (tools[i3] != null && !tools[i3].getCustomBuildStep()) {
                        curr = tools[i3];
                        real = ManagedBuildManager.getRealTool((ITool)curr);
                        break;
                    }
                    ++i3;
                }
            }
            pos = curr == null ? this.v_tools.length : -1;
            i3 = 0;
            while (i3 < this.v_tools.length) {
                if (pos == -1 && real.matches(this.v_tools[i3])) {
                    pos = i3;
                    this.c_tool.add(curr.getUniqueRealName());
                } else {
                    this.c_tool.add(this.v_tools[i3].getUniqueRealName());
                }
                ++i3;
            }
            this.c_tool.add(Messages.getString("ToolChainEditTab.6"));
            this.c_tool.select(pos);
        } else {
            String s = "";
            ITool[] tools = this.ri.getTools();
            int i4 = 0;
            while (i4 < tools.length) {
                s = String.valueOf(s) + tools[i4].getUniqueRealName() + "\n";
                ++i4;
            }
            this.text.setText(s);
        }
    }

    public void checkPressed(SelectionEvent e) {
        this.updateData();
    }

    public void performApply(ICResourceDescription src, ICResourceDescription dst) {
        IConfiguration cfg1 = this.getCfg(src.getConfiguration());
        IConfiguration cfg2 = this.getCfg(dst.getConfiguration());
        IBuilder b = cfg1.getBuilder();
        cfg2.changeBuilder(b, ManagedBuildManager.calculateChildId((String)b.getId(), null), b.getUniqueRealName());
        IResourceInfo ri1 = cfg1.getResourceInfo(src.getPath(), false);
        IResourceInfo ri2 = cfg2.getResourceInfo(dst.getPath(), false);
        if (ri1 instanceof IFolderInfo && ri2 instanceof IFolderInfo) {
            IFolderInfo fi1 = (IFolderInfo)ri1;
            IFolderInfo fi2 = (IFolderInfo)ri2;
            IToolChain tc = fi1.getToolChain();
            ITool[] tools1 = fi1.getTools();
            ITool[] tools2 = fi2.getTools();
            try {
                fi2.changeToolChain(tc, ManagedBuildManager.calculateChildId((String)tc.getId(), null), tc.getUniqueRealName());
                fi2.modifyToolChain(tools2, tools1);
            }
            catch (BuildException buildException) {}
        } else if (ri1 instanceof IFileInfo && ri2 instanceof IFileInfo) {
            ((IFileInfo)ri2).setTools(ri1.getTools());
        }
    }

    protected void performDefaults() {
        this.updateData();
    }

    protected void updateButtons() {
    }

    private void saveToolSelected() {
        int pos = this.c_tool.getSelectionIndex();
        ITool[] oldTools = this.ri.getTools();
        if (oldTools != null && oldTools.length > 0) {
            if (pos == this.c_tool.getItemCount() - 1) {
                ArrayList<ITool> newTools = new ArrayList<ITool>(oldTools.length);
                int i = 0;
                while (i < oldTools.length) {
                    if (oldTools[i].getCustomBuildStep()) {
                        newTools.add(oldTools[i]);
                    }
                    ++i;
                }
                ((IFileInfo)this.ri).setTools(newTools.toArray(new ITool[newTools.size()]));
            } else {
                int i = 0;
                while (i < oldTools.length) {
                    if (!oldTools[i].getCustomBuildStep()) {
                        if (!oldTools[i].matches(this.v_tools[pos])) {
                            oldTools[i] = this.v_tools[pos];
                            ((IFileInfo)this.ri).setTools(oldTools);
                        }
                        break;
                    }
                    ++i;
                }
            }
        } else if (pos == this.c_tool.getItemCount() - 1) {
            ((IFileInfo)this.ri).setTools(new ITool[0]);
        } else {
            ((IFileInfo)this.ri).setTools(new ITool[]{this.v_tools[pos]});
        }
    }

    private void modifyTools() {
        ToolSelectionDialog d = new ToolSelectionDialog(this.usercomp.getShell());
        d.all = this.v_tools;
        d.fi = (IFolderInfo)this.ri;
        int result = d.open();
        if (result == 0 && (d.removed.size() > 0 || d.added.size() > 0)) {
            try {
                ((IFolderInfo)this.ri).modifyToolChain(d.removed.toArray(new ITool[d.removed.size()]), d.added.toArray(new ITool[d.added.size()]));
            }
            catch (BuildException buildException) {}
            this.updateData();
        }
    }

    private void modifyToolchain() {
        if (this.ri instanceof IFolderInfo) {
            int x = this.c_toolchain.getSelectionIndex();
            try {
                if (NO_TC.equals(this.c_toolchain.getItem(x))) {
                    ((IFolderInfo)this.ri).changeToolChain(null, null, null);
                } else {
                    IToolChain tc = this.v_tcs[x];
                    if (tc == null) {
                        return;
                    }
                    ((IFolderInfo)this.ri).changeToolChain(tc, ManagedBuildManager.calculateChildId((String)tc.getId(), null), tc.getUniqueRealName());
                }
            }
            catch (BuildException buildException) {}
            this.updateData();
        }
    }

    private void modifyBuilder() {
        int x = this.c_builder.getSelectionIndex();
        IBuilder b = this.v_bs[x];
        this.cfg.changeBuilder(b, ManagedBuildManager.calculateChildId((String)b.getId(), null), b.getUniqueRealName());
        this.updateData();
    }
}

