/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IModificationStatus;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.ui.properties.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ToolSelectionDialog
extends Dialog {
    private static final String EMPTY_STR = "";
    private static final int COL_WIDTH = 300;
    private Table t1;
    private Table t2;
    private CLabel errorLabel;
    public ITool[] all;
    public ITool[] used;
    public IFolderInfo fi;
    ArrayList added;
    ArrayList removed;
    ArrayList left;
    ArrayList right;
    Font boldFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
    Color red;

    public ToolSelectionDialog(Shell shell) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("ToolSelectionDialog.0"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout(3, false));
        GridData gd = new GridData(768);
        gd.heightHint = 300;
        composite.setLayoutData((Object)gd);
        this.added = new ArrayList();
        this.removed = new ArrayList();
        this.left = new ArrayList();
        this.right = new ArrayList();
        this.t1 = new Table(composite, 2816);
        this.t1.setLayoutData((Object)new GridData(1808));
        this.t1.setHeaderVisible(true);
        this.t1.setLinesVisible(true);
        TableColumn col = new TableColumn(this.t1, 0);
        col.setText(Messages.getString("ToolSelectionDialog.1"));
        col.setWidth(300);
        Composite c2 = new Composite(composite, 2048);
        c2.setLayoutData((Object)new GridData(1040));
        this.t2 = new Table(composite, 2816);
        this.t2.setLayoutData((Object)new GridData(1808));
        this.t2.setHeaderVisible(true);
        this.t2.setLinesVisible(true);
        col = new TableColumn(this.t2, 0);
        col.setText(Messages.getString("ToolSelectionDialog.2"));
        col.setWidth(300);
        Display display = composite.getDisplay();
        this.red = display.getSystemColor(3);
        c2.setLayout((Layout)new GridLayout(1, false));
        Button b1 = new Button(c2, 8);
        b1.setText(Messages.getString("ToolSelectionDialog.12"));
        b1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int x = ToolSelectionDialog.this.t1.getSelectionIndex();
                ITool tool = (ITool)ToolSelectionDialog.this.t1.getItem(x).getData();
                ToolSelectionDialog.this.left.remove(tool);
                ToolSelectionDialog.this.right.add(tool);
                ToolSelectionDialog.this.updateData(true);
            }
        });
        b1.setLayoutData((Object)new GridData(4, 1, true, false));
        Button b2 = new Button(c2, 8);
        b2.setText(Messages.getString("ToolSelectionDialog.13"));
        b2.setLayoutData((Object)new GridData(768));
        b2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int x = ToolSelectionDialog.this.t2.getSelectionIndex();
                ITool tool = (ITool)ToolSelectionDialog.this.t2.getItem(x).getData();
                ToolSelectionDialog.this.right.remove(tool);
                ToolSelectionDialog.this.left.add(ManagedBuildManager.getRealTool((ITool)tool));
                ToolSelectionDialog.this.updateData(true);
            }
        });
        b2.setLayoutData((Object)new GridData(4, 1, true, false));
        this.errorLabel = new CLabel(composite, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.errorLabel.setLayoutData((Object)gd);
        this.errorLabel.setForeground(this.red);
        this.used = this.fi.getTools();
        int i = 0;
        while (i < this.used.length) {
            this.right.add(this.used[i]);
            int j = 0;
            while (j < this.all.length) {
                if (this.all[j] != null && this.all[j].matches(this.used[i])) {
                    this.all[j] = null;
                }
                ++j;
            }
            ++i;
        }
        int j = 0;
        while (j < this.all.length) {
            if (this.all[j] != null) {
                this.left.add(this.all[j]);
            }
            ++j;
        }
        this.updateData(false);
        return composite;
    }

    private void add(ITool tool, Table table, boolean bold) {
        TableItem ti = new TableItem(table, 0);
        ti.setText(tool.getUniqueRealName());
        if (bold) {
            ti.setFont(this.boldFont);
        }
        ti.setData((Object)tool);
    }

    private void updateData(boolean check) {
        int i;
        boolean exists;
        ITool t;
        this.removed.clear();
        this.added.clear();
        this.t1.removeAll();
        this.t2.removeAll();
        Iterator it = this.left.iterator();
        while (it.hasNext()) {
            t = (ITool)it.next();
            exists = false;
            i = 0;
            while (i < this.all.length) {
                if (this.all[i] != null && t.matches(this.all[i])) {
                    exists = true;
                    break;
                }
                ++i;
            }
            if (!exists) {
                this.removed.add(t);
            }
            this.add(t, this.t1, !exists);
        }
        it = this.right.iterator();
        while (it.hasNext()) {
            t = (ITool)it.next();
            exists = false;
            i = 0;
            while (i < this.used.length) {
                if (t.matches(this.used[i])) {
                    exists = true;
                    break;
                }
                ++i;
            }
            if (!exists) {
                this.added.add(t);
            }
            this.add(t, this.t2, !exists);
        }
        IModificationStatus st = this.fi.getToolChainModificationStatus(this.removed.toArray(new ITool[this.removed.size()]), this.added.toArray(new ITool[this.added.size()]));
        if (st.isOK()) {
            this.errorLabel.setText(EMPTY_STR);
            if (this.getButton(0) != null) {
                this.getButton(0).setEnabled(true);
            }
        } else {
            int i2;
            ITool t2;
            TableItem ti;
            int k;
            ITool[][] tools;
            int c = st.getCode();
            String s = EMPTY_STR;
            if ((c & 1) != 0) {
                s = String.valueOf(s) + Messages.getString("ToolSelectionDialog.7");
                tools = st.getToolsConflicts();
                k = 0;
                while (k < this.t2.getItemCount()) {
                    ti = this.t2.getItem(k);
                    t2 = (ITool)ti.getData();
                    i2 = 0;
                    block5: while (i2 < tools.length) {
                        int j = 0;
                        while (j < tools[i2].length) {
                            if (t2.matches(tools[i2][j])) {
                                ti.setForeground(this.red);
                                break block5;
                            }
                            ++j;
                        }
                        ++i2;
                    }
                    ++k;
                }
            }
            if ((c & 0x10) != 0) {
                s = String.valueOf(s) + Messages.getString("ToolSelectionDialog.8");
                tools = st.getNonManagedBuildTools();
                k = 0;
                while (k < this.t2.getItemCount()) {
                    ti = this.t2.getItem(k);
                    t2 = (ITool)ti.getData();
                    i2 = 0;
                    while (i2 < tools.length) {
                        if (t2.matches((ITool)tools[i2])) {
                            ti.setForeground(this.red);
                            break;
                        }
                        ++i2;
                    }
                    ++k;
                }
            }
            if ((c & 8) != 0) {
                s = String.valueOf(s) + Messages.getString("ToolSelectionDialog.9");
            }
            if ((c & 2) != 0) {
                s = String.valueOf(s) + Messages.getString("ToolSelectionDialog.10");
            }
            if ((c & 4) != 0) {
                s = String.valueOf(s) + Messages.getString("ToolSelectionDialog.11");
            }
            this.errorLabel.setText(s);
            if (this.getButton(0) != null) {
                this.getButton(0).setEnabled(false);
            }
        }
    }
}

