/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.wizards;

import java.util.ArrayList;
import java.util.TreeSet;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.ui.properties.ManagedBuilderUIImages;
import org.eclipse.cdt.managedbuilder.ui.wizards.CfgHolder;
import org.eclipse.cdt.managedbuilder.ui.wizards.MBSCustomPageManager;
import org.eclipse.cdt.managedbuilder.ui.wizards.MBSWizardHandler;
import org.eclipse.cdt.ui.newui.CDTPrefUtil;
import org.eclipse.cdt.ui.newui.UIMessages;
import org.eclipse.cdt.ui.wizards.CDTCommonProjectWizard;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class CDTConfigWizardPage
extends WizardPage {
    public static final String PAGE_ID = "org.eclipse.cdt.managedbuilder.ui.wizard.CConfigWizardPage";
    private static final Image IMG = ManagedBuilderUIImages.get(ManagedBuilderUIImages.IMG_BUILD_CONFIG);
    private static final String TITLE = UIMessages.getString((String)"CConfigWizardPage.0");
    private static final String MESSAGE = UIMessages.getString((String)"CConfigWizardPage.1");
    private static final String COMMENT = UIMessages.getString((String)"CConfigWizardPage.12");
    private static final String EMPTY_STR = "";
    private Table table;
    private CheckboxTableViewer tv;
    private Label l_projtype;
    private Label l_chains;
    private Composite parent;
    private String propertyId;
    private String errorMessage = null;
    private String message = MESSAGE;
    public boolean isVisible = false;
    private MBSWizardHandler handler;
    public boolean pagesLoaded = false;

    public CDTConfigWizardPage(MBSWizardHandler h) {
        super(UIMessages.getString((String)"CDTConfigWizardPage.0"));
        this.setPageComplete(false);
        this.handler = h;
        this.setWizard(h.getWizard());
    }

    void addCustomPages() {
        if (this.pagesLoaded) {
            return;
        }
        this.pagesLoaded = true;
        if (!(this.getWizard() instanceof CDTCommonProjectWizard)) {
            return;
        }
        CDTCommonProjectWizard wz = (CDTCommonProjectWizard)this.getWizard();
        IWizardPage p = this.getWizard().getStartingPage();
        MBSCustomPageManager.init();
        MBSCustomPageManager.addStockPage(p, "org.eclipse.cdt.managedbuilder.ui.wizard.NewModelProjectWizardPage");
        MBSCustomPageManager.addStockPage((IWizardPage)this, PAGE_ID);
        this.setCustomPagesFilter(wz);
        try {
            MBSCustomPageManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        IWizardPage[] customPages = MBSCustomPageManager.getCustomPages();
        if (customPages != null) {
            int k = 0;
            while (k < customPages.length) {
                wz.addPage(customPages[k]);
                ++k;
            }
        }
    }

    public CfgHolder[] getCfgItems(boolean getDefault) {
        CfgHolder[] its;
        if (getDefault || this.table == null) {
            its = CDTConfigWizardPage.getDefaultCfgs(this.handler);
        } else {
            ArrayList<Object> out = new ArrayList<Object>(this.table.getItemCount());
            TableItem[] tis = this.table.getItems();
            int i = 0;
            while (i < tis.length) {
                if (tis[i].getChecked()) {
                    out.add(tis[i].getData());
                }
                ++i;
            }
            its = out.toArray(new CfgHolder[out.size()]);
        }
        return its;
    }

    public void createControl(Composite p) {
        this.parent = new Composite(p, 0);
        this.parent.setLayoutData((Object)new GridData(1808));
        this.parent.setLayout((Layout)new GridLayout(3, false));
        this.setupLabel(this.parent, UIMessages.getString((String)"CConfigWizardPage.4"), 1, 1);
        this.l_projtype = this.setupLabel(this.parent, EMPTY_STR, 2, 768);
        this.setupLabel(this.parent, UIMessages.getString((String)"CConfigWizardPage.5"), 1, 1);
        this.l_chains = this.setupLabel(this.parent, EMPTY_STR, 2, 768);
        this.setupLabel(this.parent, UIMessages.getString((String)"CConfigWizardPage.6"), 3, 1);
        this.table = new Table(this.parent, 2080);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.table.setLayoutData((Object)gd);
        this.tv = new CheckboxTableViewer(this.table);
        this.tv.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tv.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return element == null ? CDTConfigWizardPage.EMPTY_STR : ((CfgHolder)element).getName();
            }

            public Image getImage(Object element) {
                return IMG;
            }
        });
        this.tv.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                CDTConfigWizardPage.this.setPageComplete(CDTConfigWizardPage.this.isCustomPageComplete());
                CDTConfigWizardPage.this.update();
            }
        });
        Composite c = new Composite(this.parent, 0);
        c.setLayoutData((Object)new GridData(1040));
        c.setLayout((Layout)new GridLayout(1, false));
        Button b1 = new Button(c, 8);
        b1.setText(UIMessages.getString((String)"CConfigWizardPage.7"));
        b1.setLayoutData((Object)new GridData(768));
        b1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CDTConfigWizardPage.this.tv.setAllChecked(true);
                CDTConfigWizardPage.this.setPageComplete(CDTConfigWizardPage.this.isCustomPageComplete());
                CDTConfigWizardPage.this.update();
            }
        });
        Button b2 = new Button(c, 8);
        b2.setText(UIMessages.getString((String)"CConfigWizardPage.8"));
        b2.setLayoutData((Object)new GridData(768));
        b2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CDTConfigWizardPage.this.tv.setAllChecked(false);
                CDTConfigWizardPage.this.setPageComplete(CDTConfigWizardPage.this.isCustomPageComplete());
                CDTConfigWizardPage.this.update();
            }
        });
        new Label(c, 0).setLayoutData((Object)new GridData(1808));
        Button b3 = new Button(c, 8);
        b3.setText(UIMessages.getString((String)"CConfigWizardPage.13"));
        b3.setLayoutData((Object)new GridData(768));
        b3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CDTConfigWizardPage.this.advancedDialog();
            }
        });
        Group gr = new Group(this.parent, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        gr.setLayoutData((Object)gd);
        gr.setLayout((Layout)new FillLayout());
        Label lb = new Label((Composite)gr, 0);
        lb.setText(COMMENT);
    }

    public static CfgHolder[] getDefaultCfgs(MBSWizardHandler handler) {
        IToolChain[] tcs = handler.getSelectedToolChains();
        String id = handler.getPropertyId();
        IProjectType pt = handler.getProjectType();
        ArrayList<CfgHolder> out = new ArrayList<CfgHolder>(tcs.length * 2);
        int i = 0;
        while (i < tcs.length) {
            CfgHolder[] cfgs = null;
            cfgs = id != null ? CfgHolder.cfgs2items(ManagedBuildManager.getExtensionConfigurations((IToolChain)tcs[i], (String)"org.eclipse.cdt.build.core.buildArtefactType", (String)id)) : (pt != null ? CfgHolder.cfgs2items(ManagedBuildManager.getExtensionConfigurations((IToolChain)tcs[i], (IProjectType)pt)) : new CfgHolder[]{new CfgHolder(tcs[i], null)});
            if (cfgs == null) {
                return null;
            }
            int j = 0;
            while (j < cfgs.length) {
                if (!(cfgs[j].isSystem() || handler.supportedOnly() && !cfgs[j].isSupported())) {
                    out.add(cfgs[j]);
                }
                ++j;
            }
            ++i;
        }
        return out.toArray(new CfgHolder[out.size()]);
    }

    public boolean isCustomPageComplete() {
        if (!this.isVisible) {
            return true;
        }
        if (this.table.getItemCount() == 0) {
            this.message = this.errorMessage = UIMessages.getString((String)"CConfigWizardPage.10");
            return false;
        }
        if (this.tv.getCheckedElements().length == 0) {
            this.message = this.errorMessage = UIMessages.getString((String)"CConfigWizardPage.11");
            return false;
        }
        this.errorMessage = null;
        this.message = MESSAGE;
        return true;
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
        if (visible && this.handler != null) {
            this.tv.setInput((Object)CfgHolder.unique(CDTConfigWizardPage.getDefaultCfgs(this.handler)));
            this.tv.setAllChecked(true);
            String s = EMPTY_STR;
            IToolChain[] tc = this.handler.getSelectedToolChains();
            int i = 0;
            while (i < tc.length) {
                s = String.valueOf(s) + (tc[i] == null ? EMPTY_STR : tc[i].getName());
                if (i < tc.length - 1) {
                    s = String.valueOf(s) + ", ";
                }
                ++i;
            }
            this.l_chains.setText(s);
            this.l_projtype.setText(this.handler.getName());
            this.setPageComplete(this.isCustomPageComplete());
        }
        this.parent.setVisible(visible);
        if (visible) {
            this.update();
        }
    }

    private Label setupLabel(Composite c, String name, int span, int mode) {
        Label l = new Label(c, 0);
        l.setText(name);
        GridData gd = new GridData(mode);
        gd.horizontalSpan = span;
        l.setLayoutData((Object)gd);
        Composite p = l.getParent();
        l.setFont(p.getFont());
        return l;
    }

    public String getName() {
        return TITLE;
    }

    public void dispose() {
    }

    public Control getControl() {
        return this.parent;
    }

    public String getDescription() {
        return null;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getMessage() {
        return this.message;
    }

    public String getTitle() {
        return TITLE;
    }

    public void performHelp() {
    }

    public void setDescription(String description) {
    }

    public void setImageDescriptor(ImageDescriptor image) {
    }

    public void setTitle(String _title) {
    }

    protected void update() {
        this.getWizard().getContainer().updateButtons();
        this.getWizard().getContainer().updateMessage();
        this.getWizard().getContainer().updateTitleBar();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void advancedDialog() {
        if (!(this.getWizard() instanceof CDTCommonProjectWizard)) return;
        CDTCommonProjectWizard nmWizard = (CDTCommonProjectWizard)this.getWizard();
        IProject newProject = nmWizard.getProject(true, false);
        if (newProject == null) return;
        boolean oldManage = CDTPrefUtil.getBool((String)"properties.manage.config.disable");
        CDTPrefUtil.setBool((String)"properties.manage.config.disable", (boolean)true);
        try {
            PreferencesUtil.createPropertyDialogOn((Shell)this.getWizard().getContainer().getShell(), (IAdaptable)newProject, (String)this.propertyId, null, null).open();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            CDTPrefUtil.setBool((String)"properties.manage.config.disable", (boolean)oldManage);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        CDTPrefUtil.setBool((String)"properties.manage.config.disable", (boolean)oldManage);
    }

    public IWizardPage getNextPage() {
        this.addCustomPages();
        return MBSCustomPageManager.getNextPage(PAGE_ID);
    }

    private void setCustomPagesFilter(CDTCommonProjectWizard wz) {
        String[] natures = wz.getNatures();
        if (natures == null || natures.length == 0) {
            MBSCustomPageManager.addPageProperty("org.eclipse.cdt.managedbuilder.ui.wizard.platformPage", "nature", null);
        } else if (natures.length == 1) {
            MBSCustomPageManager.addPageProperty("org.eclipse.cdt.managedbuilder.ui.wizard.platformPage", "nature", natures[0]);
        } else {
            TreeSet<String> x = new TreeSet<String>();
            int i = 0;
            while (i < natures.length) {
                x.add(natures[i]);
                ++i;
            }
            MBSCustomPageManager.addPageProperty("org.eclipse.cdt.managedbuilder.ui.wizard.platformPage", "nature", x);
        }
        if (this.handler.getProjectType() != null) {
            MBSCustomPageManager.addPageProperty("org.eclipse.cdt.managedbuilder.ui.wizard.platformPage", "projectType", this.handler.getProjectType().getId());
        } else {
            MBSCustomPageManager.addPageProperty("org.eclipse.cdt.managedbuilder.ui.wizard.platformPage", "projectType", null);
        }
        IToolChain[] tcs = this.handler.getSelectedToolChains();
        int n = tcs == null ? 0 : tcs.length;
        TreeSet<IToolChain> x = new TreeSet<IToolChain>();
        int i = 0;
        while (i < n) {
            x.add(tcs[i]);
            ++i;
        }
        MBSCustomPageManager.addPageProperty("org.eclipse.cdt.managedbuilder.ui.wizard.platformPage", "toolchain", x);
    }
}

