/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.wizards;

import java.util.ArrayList;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.ui.newui.UIMessages;

public class CfgHolder {
    private static final String DELIMITER = "_with_";
    private String name;
    private IConfiguration cfg;
    private IToolChain tc;

    public CfgHolder(IToolChain _tc, IConfiguration _cfg) {
        this.tc = _tc;
        this.cfg = _cfg;
        this.name = this.cfg == null ? (this.tc == null ? UIMessages.getString((String)"StdProjectTypeHandler.2") : this.tc.getName()) : this.cfg.getName();
    }

    public boolean isSystem() {
        if (this.cfg == null) {
            return false;
        }
        return this.cfg.isSystemObject();
    }

    public boolean isSupported() {
        if (this.cfg == null) {
            return true;
        }
        return this.cfg.isSupported();
    }

    public static boolean hasDoubles(CfgHolder[] its) {
        int i = 0;
        while (i < its.length) {
            String s = its[i].name;
            int j = 0;
            while (j < its.length) {
                if (i != j && s.equals(its[j].name)) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public static CfgHolder[] cfgs2items(IConfiguration[] cfgs) {
        CfgHolder[] its = new CfgHolder[cfgs.length];
        int i = 0;
        while (i < cfgs.length) {
            its[i] = new CfgHolder(cfgs[i].getToolChain(), cfgs[i]);
            ++i;
        }
        return its;
    }

    public static CfgHolder[] unique(CfgHolder[] its) {
        int k;
        if (CfgHolder.hasDoubles(its)) {
            k = 0;
            while (k < its.length) {
                its[k].name = String.valueOf(its[k].name) + DELIMITER + its[k].cfg.getToolChain().getName();
                ++k;
            }
        }
        if (CfgHolder.hasDoubles(its)) {
            k = 0;
            while (k < its.length) {
                its[k].name = String.valueOf(its[k].name) + k;
                ++k;
            }
        }
        return its;
    }

    public static IConfiguration[] items2cfgs(CfgHolder[] its) {
        ArrayList<IConfiguration> lst = new ArrayList<IConfiguration>(its.length);
        int i = 0;
        while (i < its.length) {
            if (its[i].cfg != null) {
                lst.add(its[i].cfg);
            }
            ++i;
        }
        return lst.toArray(new IConfiguration[lst.size()]);
    }

    public Object getConfiguration() {
        return this.cfg;
    }

    public String getName() {
        return this.name;
    }

    public Object getToolChain() {
        return this.tc;
    }
}

