/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.navigator;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.internal.ui.cview.CViewContentProvider;
import org.eclipse.cdt.ui.CElementContentProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.IPipelinedTreeContentProvider;
import org.eclipse.ui.navigator.PipelinedShapeModification;
import org.eclipse.ui.navigator.PipelinedViewerUpdate;

public class CNavigatorContentProvider
extends CViewContentProvider
implements IPipelinedTreeContentProvider {
    private static final String PROJECT_EXPLORER_ID = "org.eclipse.ui.navigator.ProjectExplorer";
    private static String LINKING_ENABLED = "CommonNavigator.LINKING_ENABLED";
    static String LINKING_ENABLED_DELAYED = String.valueOf(LINKING_ENABLED) + ".delayed";
    private Object fRealInput;
    private IPropertyChangeListener fPropertyChangeListener;
    private boolean fLinkingEnabledDelayed;
    static /* synthetic */ Class class$0;

    public void init(ICommonContentExtensionSite commonContentExtensionSite) {
        IMemento memento = commonContentExtensionSite.getMemento();
        this.restoreState(memento);
        this.fPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                boolean refreshViewer = false;
                String property = event.getProperty();
                Object newValue = event.getNewValue();
                if (property.equals("org.eclipse.cdt.ui.editor.CUChildren")) {
                    boolean showCUChildren = newValue instanceof Boolean ? (Boolean)newValue : false;
                    CNavigatorContentProvider.this.setProvideMembers(showCUChildren);
                    refreshViewer = true;
                } else if (property.equals("org.eclipse.cdt.ui.cview.groupincludes")) {
                    boolean groupIncludes = newValue instanceof Boolean ? (Boolean)newValue : false;
                    CNavigatorContentProvider.this.setIncludesGrouping(groupIncludes);
                    refreshViewer = true;
                }
                if (refreshViewer && CNavigatorContentProvider.this.getViewer() != null) {
                    CNavigatorContentProvider.this.getViewer().refresh();
                }
            }
        };
        CUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.fPropertyChangeListener);
    }

    public void dispose() {
        CUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.fPropertyChangeListener);
        super.dispose();
    }

    public void restoreState(IMemento memento) {
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        boolean showCUChildren = store.getBoolean("org.eclipse.cdt.ui.editor.CUChildren");
        boolean groupIncludes = store.getBoolean("org.eclipse.cdt.ui.cview.groupincludes");
        if (memento != null) {
            Integer value;
            String mementoValue = memento.getString("org.eclipse.cdt.ui.editor.CUChildren");
            if (mementoValue != null) {
                showCUChildren = Boolean.valueOf(mementoValue);
            }
            if ((mementoValue = memento.getString("org.eclipse.cdt.ui.cview.groupincludes")) != null) {
                groupIncludes = Boolean.valueOf(mementoValue);
            }
            this.fLinkingEnabledDelayed = (value = memento.getInteger(LINKING_ENABLED_DELAYED)) != null && value != 0;
        }
        this.setProvideMembers(showCUChildren);
        this.setIncludesGrouping(groupIncludes);
        this.setProvideWorkingCopy(true);
    }

    public void saveState(IMemento memento) {
        if (memento != null) {
            memento.putString("org.eclipse.cdt.ui.editor.CUChildren", String.valueOf(this.getProvideMembers()));
            memento.putString("org.eclipse.cdt.ui.cview.groupincludes", String.valueOf(this.areIncludesGroup()));
            Integer linkingEnabled = memento.getInteger(LINKING_ENABLED);
            if (linkingEnabled != null && linkingEnabled != 0) {
                memento.putInteger(LINKING_ENABLED, 0);
                memento.putInteger(LINKING_ENABLED_DELAYED, linkingEnabled.intValue());
            } else {
                memento.putInteger(LINKING_ENABLED_DELAYED, 0);
            }
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fRealInput = newInput;
        super.inputChanged(viewer, oldInput, this.findInputElement(newInput));
        this.workaroundForBug186344();
    }

    private void workaroundForBug186344() {
        if (this.fLinkingEnabledDelayed) {
            this.fLinkingEnabledDelayed = false;
            IViewPart viewPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(PROJECT_EXPLORER_ID);
            if (viewPart instanceof CommonNavigator) {
                final CommonNavigator cn = (CommonNavigator)viewPart;
                viewPart.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        cn.setLinkingEnabled(true);
                    }
                });
            }
        }
    }

    private Object findInputElement(Object newInput) {
        if (newInput instanceof IWorkspaceRoot) {
            return CoreModel.create((IWorkspaceRoot)((IWorkspaceRoot)newInput));
        }
        return newInput;
    }

    public Object getParent(Object element) {
        Object parent = super.getParent(element);
        if (parent instanceof ICModel) {
            return this.getViewerInput() != null ? this.fRealInput : parent;
        }
        if (parent instanceof ICProject) {
            return ((ICProject)parent).getProject();
        }
        return parent;
    }

    protected Object getViewerInput() {
        return this.fInput;
    }

    protected Viewer getViewer() {
        return this.fViewer;
    }

    public Object[] getElements(Object parent) {
        if (parent instanceof IWorkspaceRoot) {
            return ((IWorkspaceRoot)parent).getProjects();
        }
        if (parent instanceof IProject) {
            return super.getChildren(CoreModel.getDefault().create((IProject)parent));
        }
        return super.getElements(parent);
    }

    public Object[] getChildren(Object element) {
        if (element instanceof IWorkspaceRoot) {
            return ((IWorkspaceRoot)element).getProjects();
        }
        if (element instanceof IProject) {
            return super.getChildren(CoreModel.getDefault().create((IProject)element));
        }
        Object[] children = super.getChildren(element);
        return children;
    }

    public void getPipelinedChildren(Object parent, Set currentChildren) {
        this.customizeCElements(this.getChildren(parent), currentChildren);
    }

    public void getPipelinedElements(Object input, Set currentElements) {
        this.customizeCElements(this.getElements(input), currentElements);
    }

    private void customizeCElements(Object[] cChildren, Set proposedChildren) {
        Object element;
        List<Object> elementList = Arrays.asList(cChildren);
        Iterator iter = proposedChildren.iterator();
        while (iter.hasNext()) {
            int i;
            element = iter.next();
            IResource resource = null;
            if (element instanceof IResource) {
                resource = (IResource)element;
            } else if (element instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)element;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                resource = (IResource)iAdaptable.getAdapter((Class)clazz);
            }
            if (resource == null || (i = elementList.indexOf(resource)) < 0) continue;
            cChildren[i] = null;
        }
        int i = 0;
        while (i < cChildren.length) {
            element = cChildren[i];
            if (element instanceof ICElement) {
                ICElement cElement = (ICElement)element;
                IResource resource = cElement.getResource();
                if (resource != null) {
                    proposedChildren.remove(resource);
                }
                proposedChildren.add(element);
            } else if (element != null) {
                proposedChildren.add(element);
            }
            ++i;
        }
    }

    public Object getPipelinedParent(Object object, Object suggestedParent) {
        return this.getParent(object);
    }

    public PipelinedShapeModification interceptAdd(PipelinedShapeModification addModification) {
        if (addModification.getParent() instanceof ICProject && this.fRealInput instanceof IWorkspaceRoot) {
            addModification.setParent((Object)((ICProject)addModification.getParent()).getProject());
        }
        this.convertToCElements(addModification);
        return addModification;
    }

    public boolean interceptRefresh(PipelinedViewerUpdate refreshSynchronization) {
        return this.convertToCElements(refreshSynchronization.getRefreshTargets());
    }

    public PipelinedShapeModification interceptRemove(PipelinedShapeModification removeModification) {
        this.convertToCElements(removeModification.getChildren());
        return removeModification;
    }

    public boolean interceptUpdate(PipelinedViewerUpdate updateSynchronization) {
        return this.convertToCElements(updateSynchronization.getRefreshTargets());
    }

    private boolean convertToCElements(PipelinedShapeModification modification) {
        ICElement element;
        IContainer container;
        IProject project;
        Object parent = modification.getParent();
        if (parent instanceof IContainer && (project = (container = (IContainer)parent).getProject()) != null && CoreModel.hasCNature((IProject)project) && (element = CoreModel.getDefault().create((IResource)container)) != null) {
            if (!(element instanceof ICModel) && !(element instanceof ICProject)) {
                modification.setParent((Object)element);
            }
            return this.convertToCElements(modification.getChildren());
        }
        return false;
    }

    private boolean convertToCElements(Set currentChildren) {
        LinkedHashSet<ICElement> convertedChildren = new LinkedHashSet<ICElement>();
        Iterator iter = currentChildren.iterator();
        while (iter.hasNext()) {
            ICElement newChild;
            IResource resource;
            Object child = iter.next();
            if (!(child instanceof IFile) && !(child instanceof IFolder) || !(resource = (IResource)child).isAccessible() || !CoreModel.hasCNature((IProject)resource.getProject()) || (newChild = CoreModel.getDefault().create(resource)) == null) continue;
            iter.remove();
            convertedChildren.add(newChild);
        }
        if (!convertedChildren.isEmpty()) {
            currentChildren.addAll(convertedChildren);
            return true;
        }
        return false;
    }

    protected void postContainerRefresh(IParent container, ICProject cproject) {
        this.postRefreshable(new CElementContentProvider.RefreshContainer(this, container, cproject.getProject()));
    }

    protected void postRefresh(Object element) {
        if (element instanceof ICModel) {
            super.postRefresh(this.fRealInput);
        } else if (element instanceof ICProject && this.fRealInput instanceof IWorkspaceRoot) {
            super.postRefresh(((ICProject)element).getProject());
        } else {
            super.postRefresh(element);
        }
    }

    protected void postAdd(Object parent, Object element) {
        if (parent instanceof ICModel) {
            super.postAdd(this.fRealInput, element);
        } else if (parent instanceof ICProject && this.fRealInput instanceof IWorkspaceRoot) {
            super.postAdd(((ICProject)parent).getProject(), element);
        } else {
            super.postAdd(parent, element);
        }
    }

    protected void postRemove(Object element) {
        this.postRefresh(this.internalGetParent(element));
    }

    protected void postProjectStateChanged(Object element) {
        if (element instanceof ICModel) {
            super.postProjectStateChanged(this.fRealInput);
        } else if (element instanceof ICProject) {
            super.postProjectStateChanged(((ICProject)element).getProject());
        } else {
            super.postProjectStateChanged(element);
        }
    }
}

