/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search.actions;

import java.text.MessageFormat;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.internal.ui.util.StatusLineHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class SelectionParseAction
extends Action {
    protected static final String CSEARCH_OPERATION_NO_NAMES_SELECTED_MESSAGE = "CSearchOperation.noNamesSelected.message";
    protected static final String CSEARCH_OPERATION_OPERATION_UNAVAILABLE_MESSAGE = "CSearchOperation.operationUnavailable.message";
    protected static final String CSEARCH_OPERATION_NO_DEFINITION_MESSAGE = "CSearchOperation.noDefinitionFound.message";
    protected static final String CSEARCH_OPERATION_NO_DECLARATION_MESSAGE = "CSearchOperation.noDeclarationFound.message";
    protected IWorkbenchSite fSite;
    protected CEditor fEditor;

    public SelectionParseAction() {
    }

    public SelectionParseAction(CEditor editor) {
        this.fEditor = editor;
        this.fSite = editor.getSite();
    }

    public SelectionParseAction(IWorkbenchSite site) {
        this.fSite = site;
    }

    public IWorkbenchSite getSite() {
        return this.fSite;
    }

    protected void showStatusLineMessage(String message) {
        StatusLineHandler.showStatusLineMessage(this.fSite, message);
    }

    protected void clearStatusLine() {
        StatusLineHandler.clearStatusLine(this.fSite);
    }

    public ITextSelection getSelection(int fPos) {
        return SelectionParseAction.selectWord(fPos, (ITextEditor)this.fEditor);
    }

    public static ITextSelection selectWord(int fPos, ITextEditor editor) {
        IDocument doc;
        IDocumentProvider prov = editor != null ? editor.getDocumentProvider() : null;
        IDocument iDocument = doc = prov != null ? prov.getDocument((Object)editor.getEditorInput()) : null;
        if (doc == null) {
            return null;
        }
        int pos = fPos;
        int fStartPos = 0;
        int fEndPos = 0;
        int nonJavaStart = -1;
        int nonJavaEnd = -1;
        String selectedWord = null;
        try {
            char c;
            while (pos >= 0) {
                c = doc.getChar(pos);
                if (nonJavaStart == -1 && !Character.isJavaIdentifierPart(c)) {
                    nonJavaStart = pos + 1;
                }
                if (Character.isWhitespace(c)) break;
                --pos;
            }
            fStartPos = pos + 1;
            pos = fPos;
            int length = doc.getLength();
            while (pos < length) {
                c = doc.getChar(pos);
                if (nonJavaEnd == -1 && !Character.isJavaIdentifierPart(c)) {
                    nonJavaEnd = pos;
                }
                if (Character.isWhitespace(c)) break;
                ++pos;
            }
            fEndPos = pos;
            selectedWord = doc.get(fStartPos, fEndPos - fStartPos);
        }
        catch (BadLocationException badLocationException) {}
        if (selectedWord != null && selectedWord.indexOf(126) >= 0 && fPos - 2 >= fStartPos + selectedWord.lastIndexOf(new String(Keywords.cpCOLONCOLON))) {
            int tildePos = selectedWord.indexOf(126);
            int actualStart = fStartPos + tildePos;
            int length = 0;
            char[] lastSegment = selectedWord.substring(tildePos).toCharArray();
            int i = 1;
            while (i < lastSegment.length) {
                char temp = lastSegment[i];
                if (!Character.isJavaIdentifierPart(temp)) {
                    length = i;
                    break;
                }
                ++i;
            }
            if (fPos >= actualStart + length) {
                return new TextSelection(doc, nonJavaStart, length);
            }
            return new TextSelection(doc, actualStart, length);
        }
        return new TextSelection(doc, nonJavaStart, nonJavaEnd - nonJavaStart);
    }

    protected ITextSelection getSelection(ITextSelection textSelection) {
        if (textSelection == null) {
            return null;
        }
        if (textSelection.getLength() == 0) {
            return this.getSelection(textSelection.getOffset());
        }
        return textSelection;
    }

    protected ISelection getSelection() {
        ISelection sel = null;
        if (this.fSite != null && this.fSite.getSelectionProvider() != null) {
            sel = this.fSite.getSelectionProvider().getSelection();
        }
        return sel;
    }

    protected ITextSelection getSelectedStringFromEditor() {
        ISelection selection = this.getSelection();
        if (selection == null || !(selection instanceof ITextSelection)) {
            return null;
        }
        return this.getSelection((ITextSelection)selection);
    }

    protected void open(IName name) throws CoreException {
        this.clearStatusLine();
        IASTFileLocation fileloc = name.getFileLocation();
        if (fileloc == null) {
            this.reportSymbolLookupFailure(new String(name.toCharArray()));
            return;
        }
        Path path = new Path(fileloc.getFileName());
        int currentOffset = fileloc.getNodeOffset();
        int currentLength = fileloc.getNodeLength();
        this.open((IPath)path, currentOffset, currentLength);
    }

    protected void open(IPath path, int currentOffset, int currentLength) throws CoreException {
        this.clearStatusLine();
        IEditorPart editor = EditorUtility.openInEditor(path, this.fEditor.getInputCElement());
        if (editor instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)editor;
            textEditor.selectAndReveal(currentOffset, currentLength);
        } else {
            this.reportSourceFileOpenFailure(path);
        }
    }

    public void update() {
        this.setEnabled(this.getSelectedStringFromEditor() != null);
    }

    protected void reportSourceFileOpenFailure(IPath path) {
        this.showStatusLineMessage(MessageFormat.format(CSearchMessages.getString("SelectionParseAction.FileOpenFailure.format"), path.toOSString()));
    }

    protected void reportSelectionMatchFailure() {
        this.showStatusLineMessage(CSearchMessages.getString("SelectionParseAction.SelectedTextNotSymbol.message"));
    }

    protected void reportSymbolLookupFailure(String symbol) {
        this.showStatusLineMessage(MessageFormat.format(CSearchMessages.getString("SelectionParseAction.SymbolNotFoundInIndex.format"), symbol));
    }

    protected void reportIncludeLookupFailure(String filename) {
        this.showStatusLineMessage(MessageFormat.format(CSearchMessages.getString("SelectionParseAction.IncludeNotFound.format"), filename));
    }
}

