/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import org.eclipse.cdt.internal.ui.text.BufferedDocumentScanner;
import org.eclipse.cdt.ui.text.ICPartitions;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public final class FastCPartitionScanner
implements IPartitionTokenScanner,
ICPartitions {
    private static final int CCODE = 0;
    private static final int SINGLE_LINE_COMMENT = 1;
    private static final int MULTI_LINE_COMMENT = 2;
    private static final int CHARACTER = 3;
    private static final int STRING = 4;
    private static final int PREPROCESSOR = 5;
    private static final int PREPROCESSOR_MULTI_LINE_COMMENT = 6;
    private static final int NONE = 0;
    private static final int BACKSLASH = 1;
    private static final int SLASH = 2;
    private static final int SLASH_STAR = 3;
    private static final int STAR = 4;
    private static final int CARRIAGE_RETURN = 5;
    private static final int BACKSLASH_CR = 6;
    private final BufferedDocumentScanner fScanner = new BufferedDocumentScanner(1000);
    private int fTokenOffset;
    private int fTokenLength;
    private int fState;
    private int fLast;
    private int fPrefixLength;
    private boolean fFirstCharOnLine = true;
    private boolean fEmulate = false;
    private int fCCodeOffset;
    private int fCCodeLength;
    private final IToken[] fTokens = new IToken[]{new Token(null), new Token((Object)"__c_singleline_comment"), new Token((Object)"__c_multiline_comment"), new Token((Object)"__c_character"), new Token((Object)"__c_string"), new Token((Object)"__c_preprocessor"), new Token((Object)"__c_preprocessor")};

    public FastCPartitionScanner(boolean emulate) {
        this.fEmulate = emulate;
    }

    public FastCPartitionScanner() {
        this(false);
    }

    public IToken nextToken() {
        if (this.fEmulate) {
            if (this.fCCodeOffset != -1 && this.fTokenOffset + this.fTokenLength != this.fCCodeOffset + this.fCCodeLength) {
                this.fTokenOffset += this.fTokenLength;
                return this.fTokens[0];
            }
            this.fCCodeOffset = -1;
            this.fCCodeLength = 0;
        }
        this.fTokenOffset += this.fTokenLength;
        this.fTokenLength = this.fPrefixLength;
        block65: while (true) {
            int ch = this.fScanner.read();
            boolean isFirstCharOnLine = this.fFirstCharOnLine;
            if (this.fFirstCharOnLine && ch != 32 && ch != 9) {
                this.fFirstCharOnLine = false;
            }
            block0 : switch (ch) {
                case -1: {
                    if (this.fTokenLength > 0) {
                        this.fLast = 0;
                        return this.preFix(this.fState, 0, 0, 0);
                    }
                    this.fLast = 0;
                    this.fPrefixLength = 0;
                    return Token.EOF;
                }
                case 13: {
                    this.fFirstCharOnLine = true;
                    if (!this.fEmulate && this.fLast == 1) {
                        this.fLast = 6;
                        ++this.fTokenLength;
                        continue block65;
                    }
                    if (!this.fEmulate && this.fLast != 5) {
                        this.fLast = 5;
                        ++this.fTokenLength;
                        continue block65;
                    }
                    switch (this.fState) {
                        case 1: 
                        case 3: 
                        case 4: 
                        case 5: {
                            if (this.fTokenLength > 0) {
                                IToken token = this.fTokens[this.fState];
                                if (this.fEmulate) {
                                    ++this.fTokenLength;
                                    this.fLast = 0;
                                    this.fPrefixLength = 0;
                                } else {
                                    this.fLast = 5;
                                    this.fPrefixLength = 1;
                                }
                                this.fState = 0;
                                return token;
                            }
                            this.consume();
                            continue block65;
                        }
                    }
                    this.consume();
                    continue block65;
                }
                case 92: {
                    if (this.fLast != 1) break;
                    this.consume();
                    continue block65;
                }
                case 10: {
                    this.fFirstCharOnLine = true;
                    switch (this.fState) {
                        case 1: 
                        case 3: 
                        case 4: 
                        case 5: {
                            if (this.fLast == 1 || this.fLast == 6) break;
                            return this.postFix(this.fState);
                        }
                    }
                    this.consume();
                    continue block65;
                }
                default: {
                    if (this.fEmulate || this.fLast != 5) break;
                    switch (this.fState) {
                        case 1: 
                        case 3: 
                        case 4: 
                        case 5: {
                            int newState;
                            int last;
                            switch (ch) {
                                case 47: {
                                    last = 2;
                                    newState = 0;
                                    break;
                                }
                                case 42: {
                                    last = 4;
                                    newState = 0;
                                    break;
                                }
                                case 39: {
                                    last = 0;
                                    newState = 3;
                                    break;
                                }
                                case 34: {
                                    last = 0;
                                    newState = 4;
                                    break;
                                }
                                case 13: {
                                    last = 5;
                                    newState = 0;
                                    break;
                                }
                                case 92: {
                                    last = 1;
                                    newState = 0;
                                    break;
                                }
                                case 35: {
                                    last = 0;
                                    newState = 5;
                                    break;
                                }
                                default: {
                                    last = 0;
                                    newState = 0;
                                }
                            }
                            this.fLast = 0;
                            return this.preFix(this.fState, newState, last, 1);
                        }
                        case 0: {
                            if (ch != 35 || !isFirstCharOnLine) break block0;
                            this.fLast = 0;
                            int column = this.fScanner.getColumn() - 1;
                            this.fTokenLength -= column;
                            if (this.fTokenLength > 0) {
                                return this.preFix(this.fState, 5, 0, column + 1);
                            }
                            this.preFix(this.fState, 5, 0, column + 1);
                            this.fTokenOffset += this.fTokenLength;
                            this.fTokenLength = this.fPrefixLength;
                            break block0;
                        }
                    }
                }
            }
            block25 : switch (this.fState) {
                case 0: {
                    switch (ch) {
                        case 47: {
                            if (this.fLast == 2) {
                                if (this.fTokenLength - FastCPartitionScanner.getLastLength(this.fLast) > 0) {
                                    return this.preFix(0, 1, 0, 2);
                                }
                                this.preFix(0, 1, 0, 2);
                                this.fTokenOffset += this.fTokenLength;
                                this.fTokenLength = this.fPrefixLength;
                                break;
                            }
                            ++this.fTokenLength;
                            this.fLast = 2;
                            break;
                        }
                        case 42: {
                            if (this.fLast == 2) {
                                if (this.fTokenLength - FastCPartitionScanner.getLastLength(this.fLast) > 0) {
                                    return this.preFix(0, 2, 3, 2);
                                }
                                this.preFix(0, 2, 3, 2);
                                this.fTokenOffset += this.fTokenLength;
                                this.fTokenLength = this.fPrefixLength;
                                break;
                            }
                            this.consume();
                            break;
                        }
                        case 39: {
                            this.fLast = 0;
                            if (this.fTokenLength > 0) {
                                return this.preFix(0, 3, 0, 1);
                            }
                            this.preFix(0, 3, 0, 1);
                            this.fTokenOffset += this.fTokenLength;
                            this.fTokenLength = this.fPrefixLength;
                            break;
                        }
                        case 34: {
                            this.fLast = 0;
                            if (this.fTokenLength > 0) {
                                return this.preFix(0, 4, 0, 1);
                            }
                            this.preFix(0, 4, 0, 1);
                            this.fTokenOffset += this.fTokenLength;
                            this.fTokenLength = this.fPrefixLength;
                            break;
                        }
                        case 35: {
                            if (!this.fEmulate && isFirstCharOnLine) {
                                int column = this.fScanner.getColumn() - 1;
                                this.fTokenLength -= column;
                                if (this.fTokenLength > 0) {
                                    return this.preFix(this.fState, 5, 0, column + 1);
                                }
                                this.preFix(this.fState, 5, 0, column + 1);
                                this.fTokenOffset += this.fTokenLength;
                                this.fTokenLength = this.fPrefixLength;
                                break;
                            }
                        }
                        default: {
                            this.consume();
                            break;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (ch) {
                        case 92: {
                            this.fLast = this.fLast == 1 ? 0 : 1;
                            ++this.fTokenLength;
                            break;
                        }
                        default: {
                            this.consume();
                            break;
                        }
                    }
                    break;
                }
                case 5: {
                    switch (ch) {
                        case 92: {
                            this.fLast = this.fLast == 1 ? 0 : 1;
                            ++this.fTokenLength;
                            break;
                        }
                        case 47: {
                            if (this.fLast == 2) {
                                this.consume();
                                break;
                            }
                            ++this.fTokenLength;
                            this.fLast = 2;
                            break;
                        }
                        case 42: {
                            if (this.fLast == 2) {
                                this.fState = 6;
                                this.consume();
                                break;
                            }
                            this.consume();
                            break;
                        }
                        default: {
                            this.consume();
                            break;
                        }
                    }
                    break;
                }
                case 6: {
                    switch (ch) {
                        case 42: {
                            ++this.fTokenLength;
                            this.fLast = 4;
                            break;
                        }
                        case 47: {
                            if (this.fLast == 4) {
                                this.fState = 5;
                            }
                            this.consume();
                            break;
                        }
                        default: {
                            this.consume();
                            break;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (ch) {
                        case 42: {
                            ++this.fTokenLength;
                            this.fLast = 4;
                            break;
                        }
                        case 47: {
                            if (this.fLast == 4) {
                                return this.postFix(2);
                            }
                            this.consume();
                            break;
                        }
                        default: {
                            this.consume();
                            break;
                        }
                    }
                    break;
                }
                case 4: {
                    switch (ch) {
                        case 92: {
                            this.fLast = this.fLast == 1 ? 0 : 1;
                            ++this.fTokenLength;
                            break;
                        }
                        case 34: {
                            if (this.fLast != 1) {
                                return this.postFix(4);
                            }
                            this.consume();
                            break;
                        }
                        default: {
                            this.consume();
                            break;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (ch) {
                        case 92: {
                            this.fLast = this.fLast == 1 ? 0 : 1;
                            ++this.fTokenLength;
                            break block25;
                        }
                        case 39: {
                            if (this.fLast != 1) {
                                return this.postFix(3);
                            }
                            this.consume();
                            break block25;
                        }
                        default: {
                            this.consume();
                        }
                    }
                }
            }
        }
    }

    private static final int getLastLength(int last) {
        switch (last) {
            default: {
                return -1;
            }
            case 0: {
                return 0;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                return 1;
            }
            case 3: 
            case 6: 
        }
        return 2;
    }

    private final void consume() {
        ++this.fTokenLength;
        this.fLast = 0;
    }

    private final IToken postFix(int state) {
        ++this.fTokenLength;
        this.fLast = 0;
        this.fState = 0;
        this.fPrefixLength = 0;
        return this.fTokens[state];
    }

    private final IToken preFix(int state, int newState, int last, int prefixLength) {
        if (this.fEmulate && state == 0 && this.fTokenLength - FastCPartitionScanner.getLastLength(this.fLast) > 0) {
            this.fTokenLength -= FastCPartitionScanner.getLastLength(this.fLast);
            this.fCCodeOffset = this.fTokenOffset;
            this.fCCodeLength = this.fTokenLength;
            this.fTokenLength = 1;
            this.fState = newState;
            this.fPrefixLength = prefixLength;
            this.fLast = last;
            return this.fTokens[state];
        }
        this.fTokenLength -= FastCPartitionScanner.getLastLength(this.fLast);
        this.fLast = last;
        this.fPrefixLength = prefixLength;
        IToken token = this.fTokens[state];
        this.fState = newState;
        return token;
    }

    private static int getState(String contentType) {
        if (contentType == null) {
            return 0;
        }
        if (contentType.equals("__c_singleline_comment")) {
            return 1;
        }
        if (contentType.equals("__c_multiline_comment")) {
            return 2;
        }
        if (contentType.equals("__c_string")) {
            return 4;
        }
        if (contentType.equals("__c_character")) {
            return 3;
        }
        if (contentType.equals("__c_preprocessor")) {
            return 5;
        }
        return 0;
    }

    public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset) {
        this.fScanner.setRange(document, offset, length);
        this.fTokenOffset = partitionOffset;
        this.fTokenLength = 0;
        this.fPrefixLength = offset - partitionOffset;
        this.fLast = 0;
        this.fState = offset == partitionOffset ? 0 : FastCPartitionScanner.getState(contentType);
        try {
            int column = this.fScanner.getColumn();
            this.fFirstCharOnLine = column == 0 || document.get(offset - column, column).trim().length() == 0;
        }
        catch (BadLocationException badLocationException) {
            this.fFirstCharOnLine = true;
        }
        if (this.fEmulate) {
            this.fCCodeOffset = -1;
            this.fCCodeLength = 0;
        }
    }

    public void setRange(IDocument document, int offset, int length) {
        this.fScanner.setRange(document, offset, length);
        this.fTokenOffset = offset;
        this.fTokenLength = 0;
        this.fPrefixLength = 0;
        this.fLast = 0;
        this.fState = 0;
        try {
            int column = this.fScanner.getColumn();
            this.fFirstCharOnLine = column == 0 || document.get(offset - column, column).trim().length() == 0;
        }
        catch (BadLocationException badLocationException) {
            this.fFirstCharOnLine = true;
        }
        if (this.fEmulate) {
            this.fCCodeOffset = -1;
            this.fCCodeLength = 0;
        }
    }

    public int getTokenLength() {
        return this.fTokenLength;
    }

    public int getTokenOffset() {
        return this.fTokenOffset;
    }
}

