/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.contentassist;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.internal.ui.preferences.ProposalFilterPreferencesUtil;
import org.eclipse.cdt.internal.ui.text.CParameterListValidator;
import org.eclipse.cdt.internal.ui.text.contentassist.CContentAssistInvocationContext;
import org.eclipse.cdt.internal.ui.text.contentassist.ContentAssistProcessor;
import org.eclipse.cdt.internal.ui.text.contentassist.DefaultProposalFilter;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.ICCompletionProposal;
import org.eclipse.cdt.ui.text.contentassist.ContentAssistInvocationContext;
import org.eclipse.cdt.ui.text.contentassist.IProposalFilter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;

public class CContentAssistProcessor
extends ContentAssistProcessor {
    private static final int IDX_AFTERDASH = 0;
    private static final int IDX_AFTERCOLON = 1;
    private static final int IDX_AFTEROTHER = 2;
    private static final int IDX_ALL = 3;
    private IContextInformationValidator fValidator;
    private final IEditorPart fEditor;
    private char[][] fCompletionAutoActivationCharacters;
    private ISourceViewer fViewer;

    public CContentAssistProcessor(IEditorPart editor, ISourceViewer viewer, ContentAssistant assistant, String partition) {
        super(assistant, partition);
        this.fEditor = editor;
        this.fViewer = viewer;
    }

    public IContextInformationValidator getContextInformationValidator() {
        if (this.fValidator == null) {
            this.fValidator = new CParameterListValidator();
        }
        return this.fValidator;
    }

    protected List filterAndSortProposals(List proposals, IProgressMonitor monitor, ContentAssistInvocationContext context) {
        IProposalFilter filter = this.getCompletionFilter();
        ICCompletionProposal[] proposalsInput = new ICCompletionProposal[proposals.size()];
        int i = 0;
        Iterator iterator = proposals.iterator();
        while (iterator.hasNext()) {
            ICompletionProposal proposal = (ICompletionProposal)iterator.next();
            proposalsInput[i++] = proposal instanceof ICCompletionProposal ? (ICCompletionProposal)proposal : new CCompletionProposalWrapper(proposal);
        }
        ICCompletionProposal[] proposalsFiltered = filter.filterProposals(proposalsInput);
        ArrayList<ICompletionProposal> filteredList = new ArrayList<ICompletionProposal>(proposalsFiltered.length);
        int j = 0;
        while (j < proposalsFiltered.length) {
            ICCompletionProposal proposal = proposalsFiltered[j];
            if (proposal instanceof CCompletionProposalWrapper) {
                filteredList.add(((CCompletionProposalWrapper)proposal).unwrap());
            } else {
                filteredList.add(proposal);
            }
            ++j;
        }
        return filteredList;
    }

    private IProposalFilter getCompletionFilter() {
        IProposalFilter filter = null;
        try {
            Object contribObject;
            IConfigurationElement filterElement = ProposalFilterPreferencesUtil.getPreferredFilterElement();
            if (filterElement != null && (contribObject = filterElement.createExecutableExtension("class")) instanceof IProposalFilter) {
                filter = (IProposalFilter)contribObject;
            }
        }
        catch (InvalidRegistryObjectException e) {
            CUIPlugin.getDefault().log(e);
        }
        catch (CoreException e) {
            CUIPlugin.getDefault().log(e);
        }
        if (filter == null) {
            filter = new DefaultProposalFilter();
        }
        return filter;
    }

    protected List filterAndSortContextInformation(List contexts, IProgressMonitor monitor) {
        return contexts;
    }

    protected ContentAssistInvocationContext createContext(ITextViewer viewer, int offset, boolean isCompletion) {
        return new CContentAssistInvocationContext(viewer, offset, this.fEditor, isCompletion);
    }

    public void setCompletionProposalAutoActivationCharacters(char[] activationSet) {
        if (activationSet == null) {
            this.fCompletionAutoActivationCharacters = null;
        } else {
            int len = activationSet.length;
            StringBuffer afterDash = new StringBuffer(len);
            StringBuffer afterColon = new StringBuffer(len);
            StringBuffer afterOther = new StringBuffer(len);
            int i = 0;
            while (i < activationSet.length) {
                char c = activationSet[i];
                switch (c) {
                    case ':': {
                        afterColon.append(c);
                        break;
                    }
                    case '>': {
                        afterDash.append(c);
                        break;
                    }
                    default: {
                        afterDash.append(c);
                        afterColon.append(c);
                        afterOther.append(c);
                    }
                }
                ++i;
            }
            this.fCompletionAutoActivationCharacters = new char[4][];
            this.fCompletionAutoActivationCharacters[0] = afterDash.toString().toCharArray();
            this.fCompletionAutoActivationCharacters[1] = afterColon.toString().toCharArray();
            this.fCompletionAutoActivationCharacters[2] = afterOther.toString().toCharArray();
            this.fCompletionAutoActivationCharacters[3] = activationSet;
        }
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        if (this.fCompletionAutoActivationCharacters == null) {
            return null;
        }
        if (this.fViewer != null) {
            int prevChar = 0;
            try {
                IDocument doc = this.fViewer.getDocument();
                if (doc != null) {
                    prevChar = doc.getChar(this.fViewer.getSelectedRange().x - 1);
                }
            }
            catch (BadLocationException badLocationException) {}
            switch (prevChar) {
                case 58: {
                    return this.fCompletionAutoActivationCharacters[1];
                }
                case 45: {
                    return this.fCompletionAutoActivationCharacters[0];
                }
            }
            return this.fCompletionAutoActivationCharacters[2];
        }
        return this.fCompletionAutoActivationCharacters[3];
    }

    private static class CCompletionProposalWrapper
    implements ICCompletionProposal {
        private ICompletionProposal fWrappedProposal;

        public CCompletionProposalWrapper(ICompletionProposal proposal) {
            this.fWrappedProposal = proposal;
        }

        public String getIdString() {
            return this.fWrappedProposal.getDisplayString();
        }

        public int getRelevance() {
            return -1;
        }

        public void apply(IDocument document) {
            throw new UnsupportedOperationException();
        }

        public String getAdditionalProposalInfo() {
            return this.fWrappedProposal.getAdditionalProposalInfo();
        }

        public IContextInformation getContextInformation() {
            return this.fWrappedProposal.getContextInformation();
        }

        public String getDisplayString() {
            return this.fWrappedProposal.getDisplayString();
        }

        public Image getImage() {
            return this.fWrappedProposal.getImage();
        }

        public Point getSelection(IDocument document) {
            return this.fWrappedProposal.getSelection(document);
        }

        public ICompletionProposal unwrap() {
            return this.fWrappedProposal;
        }
    }
}

