/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.typehierarchy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.typehierarchy.THGraphEdge;

class THGraphNode {
    private List fOutgoing = Collections.EMPTY_LIST;
    private List fIncoming = Collections.EMPTY_LIST;
    private ICElement fElement;
    private ICElement[] fMembers = null;

    THGraphNode(ICElement element) {
        this.fElement = element;
    }

    void startEdge(THGraphEdge outgoing) {
        this.fOutgoing = this.addElement(this.fOutgoing, outgoing);
    }

    void endEdge(THGraphEdge incoming) {
        this.fIncoming = this.addElement(this.fIncoming, incoming);
    }

    ICElement getElement() {
        return this.fElement;
    }

    private List addElement(List list, Object elem) {
        switch (list.size()) {
            case 0: {
                return Collections.singletonList(elem);
            }
            case 1: {
                list = new ArrayList<Object>(list);
                list.add(elem);
                return list;
            }
        }
        list.add(elem);
        return list;
    }

    List getOutgoing() {
        return this.fOutgoing;
    }

    List getIncoming() {
        return this.fIncoming;
    }

    public void setMembers(ICElement[] array) {
        this.fMembers = array;
    }

    public ICElement[] getMembers(boolean addInherited) {
        if (!addInherited) {
            return this.fMembers;
        }
        ArrayList list = new ArrayList();
        this.collectMembers(new HashSet(), list);
        return list.toArray(new ICElement[list.size()]);
    }

    private void collectMembers(HashSet visited, List list) {
        if (visited.add(this)) {
            if (this.fMembers != null) {
                list.addAll(Arrays.asList(this.fMembers));
            }
            List bases = this.getOutgoing();
            Iterator iterator = bases.iterator();
            while (iterator.hasNext()) {
                THGraphEdge edge = (THGraphEdge)iterator.next();
                edge.getEndNode().collectMembers(visited, list);
            }
        }
    }
}

