/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.viewsupport;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.editor.CContentOutlinePage;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.views.contentoutline.ContentOutline;

public class CDTContextActivator
implements IWindowListener,
IPartListener2 {
    private static CDTContextActivator sInstance = new CDTContextActivator();
    private Map fActivationPerOutline = new HashMap();
    private Map fActivationPerNavigator = new HashMap();
    private Collection fWindows = new HashSet();
    static /* synthetic */ Class class$0;

    private CDTContextActivator() {
    }

    public static CDTContextActivator getInstance() {
        return sInstance;
    }

    public void install() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            IWorkbenchPartReference part;
            IWorkbenchPage activePage;
            workbench.addWindowListener((IWindowListener)this);
            IWorkbenchWindow[] wnds = workbench.getWorkbenchWindows();
            int i = 0;
            while (i < wnds.length) {
                IWorkbenchWindow window = wnds[i];
                this.register(window);
                ++i;
            }
            IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (ww != null && (activePage = ww.getActivePage()) != null && (part = activePage.getActivePartReference()) != null) {
                this.partActivated(part);
            }
        }
    }

    public void uninstall() {
        Iterator<Object> iterator = this.fWindows.iterator();
        while (iterator.hasNext()) {
            IWorkbenchWindow window = (IWorkbenchWindow)iterator.next();
            this.unregister(window);
        }
        iterator = this.fActivationPerNavigator.values().iterator();
        while (iterator.hasNext()) {
            SelectionListener l = (SelectionListener)iterator.next();
            l.uninstall();
        }
    }

    private void register(IWorkbenchWindow wnd) {
        wnd.getPartService().addPartListener((IPartListener2)this);
        this.fWindows.add(wnd);
    }

    private void unregister(IWorkbenchWindow wnd) {
        wnd.getPartService().removePartListener((IPartListener2)this);
        this.fWindows.remove(wnd);
    }

    public void windowOpened(IWorkbenchWindow window) {
        this.register(window);
    }

    public void windowClosed(IWorkbenchWindow window) {
        this.unregister(window);
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    private void onContentOutlineClosed(ContentOutline outline) {
        this.fActivationPerOutline.remove(outline);
    }

    private void onContentOutlineActivated(ContentOutline outline) {
        IPage page = outline.getCurrentPage();
        if (page instanceof CContentOutlinePage) {
            if (!this.fActivationPerOutline.containsKey(outline)) {
                IViewSite iViewSite = outline.getViewSite();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.contexts.IContextService");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                IContextService ctxtService = (IContextService)iViewSite.getService((Class)clazz);
                IContextActivation activateContext = ctxtService.activateContext("org.eclipse.cdt.ui.cViewScope");
                this.fActivationPerOutline.put(outline, activateContext);
            }
        } else {
            IContextActivation activation = (IContextActivation)this.fActivationPerOutline.remove(outline);
            if (activation != null) {
                IViewSite iViewSite = outline.getViewSite();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.contexts.IContextService");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                IContextService ctxtService = (IContextService)iViewSite.getService((Class)clazz);
                ctxtService.deactivateContext(activation);
            }
        }
    }

    private void onCommonNavigatorActivated(CommonNavigator part) {
        SelectionListener l = (SelectionListener)this.fActivationPerNavigator.get(part);
        if (l == null) {
            l = new SelectionListener(part.getSite());
            this.fActivationPerNavigator.put(part, l);
        }
    }

    private void onCommonNavigatorClosed(CommonNavigator part) {
        this.fActivationPerNavigator.remove(part);
    }

    public void partActivated(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (part instanceof ContentOutline) {
            this.onContentOutlineActivated((ContentOutline)part);
        } else if (part instanceof CommonNavigator) {
            this.onCommonNavigatorActivated((CommonNavigator)part);
        }
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (part instanceof ContentOutline) {
            this.onContentOutlineClosed((ContentOutline)part);
        } else if (part instanceof CommonNavigator) {
            this.onCommonNavigatorClosed((CommonNavigator)part);
        }
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    private static class SelectionListener
    implements ISelectionChangedListener {
        private IWorkbenchPartSite fSite;
        private IContextService fCtxService;
        private IContextActivation fActivation;

        public SelectionListener(IWorkbenchPartSite site) {
            this.fSite = site;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.contexts.IContextService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.fCtxService = (IContextService)this.fSite.getService((Class)clazz);
            ISelectionProvider sp = site.getSelectionProvider();
            if (sp != null && this.fCtxService != null) {
                sp.addSelectionChangedListener((ISelectionChangedListener)this);
                this.onNewSelection(sp.getSelection());
            }
        }

        public void uninstall() {
            ISelectionProvider sp = this.fSite.getSelectionProvider();
            if (sp != null && this.fCtxService != null) {
                this.onNewSelection(null);
                sp.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.onNewSelection(event.getSelection());
        }

        private void onNewSelection(ISelection selection) {
            boolean isRelevant = false;
            if (selection instanceof IStructuredSelection && !selection.isEmpty() && ((IStructuredSelection)selection).getFirstElement() instanceof ICElement) {
                isRelevant = true;
            }
            if (isRelevant) {
                if (this.fActivation == null) {
                    this.fActivation = this.fCtxService.activateContext("org.eclipse.cdt.ui.cViewScope");
                }
            } else if (this.fActivation != null) {
                this.fCtxService.deactivateContext(this.fActivation);
                this.fActivation = null;
            }
        }
    }
}

