/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.actions;

import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.internal.ui.cview.IncludeRefContainer;
import org.eclipse.cdt.internal.ui.cview.IncludeReferenceProxy;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.actions.ChangeConfigAction;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class ChangeBuildConfigActionBase {
    protected HashSet fProjects = new HashSet();
    static /* synthetic */ Class class$0;

    protected void fillMenu(Menu menu) {
        if (menu == null) {
            return;
        }
        MenuItem[] items = menu.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].dispose();
            ++i;
        }
        TreeSet<String> configNames = new TreeSet<String>();
        Iterator projIter = this.fProjects.iterator();
        String sCurrentConfig = null;
        boolean bCurrentConfig = true;
        while (projIter.hasNext()) {
            ICConfigurationDescription[] cfgDescs = this.getCfgs((IProject)projIter.next());
            String sActiveConfig = null;
            int i2 = 0;
            while (i2 < cfgDescs.length) {
                configNames.add(cfgDescs[i2].getName());
                if (cfgDescs[i2].isActive()) {
                    sActiveConfig = cfgDescs[i2].getName();
                }
                ++i2;
            }
            if (!bCurrentConfig) continue;
            if (sCurrentConfig == null) {
                sCurrentConfig = sActiveConfig;
                continue;
            }
            if (sCurrentConfig.equals(sActiveConfig)) continue;
            bCurrentConfig = false;
        }
        Iterator confIter = configNames.iterator();
        int accel = 0;
        while (confIter.hasNext()) {
            String sName = (String)confIter.next();
            String sDesc = null;
            projIter = this.fProjects.iterator();
            boolean commonName = true;
            boolean commonDesc = true;
            boolean firstProj = true;
            while (projIter.hasNext()) {
                ICConfigurationDescription[] cfgDescs = this.getCfgs((IProject)projIter.next());
                int i3 = 0;
                while (i3 < cfgDescs.length) {
                    if (cfgDescs[i3].getName().equals(sName)) {
                        String sNewDesc = cfgDescs[i3].getDescription();
                        if (sNewDesc != null && sNewDesc.length() == 0) {
                            sNewDesc = null;
                        }
                        if (!commonDesc) break;
                        if (firstProj) {
                            sDesc = sNewDesc;
                            firstProj = false;
                            break;
                        }
                        if ((sNewDesc != null || sDesc == null) && (sNewDesc == null || sNewDesc.equals(sDesc))) break;
                        commonDesc = false;
                        break;
                    }
                    ++i3;
                }
                if (i3 != cfgDescs.length) continue;
                commonName = false;
                break;
            }
            if (!commonName) continue;
            StringBuffer builder = new StringBuffer(sName);
            if (commonDesc) {
                if (sDesc != null) {
                    builder.append(" (");
                    builder.append(sDesc);
                    builder.append(")");
                }
            } else {
                builder.append(" (...)");
            }
            IAction action = this.makeAction(sName, builder, accel);
            if (bCurrentConfig && sCurrentConfig.equals(sName)) {
                action.setChecked(true);
            }
            ActionContributionItem item = new ActionContributionItem(action);
            item.fill(menu, -1);
            ++accel;
        }
    }

    protected IAction makeAction(String sName, StringBuffer builder, int accel) {
        return new ChangeConfigAction(this.fProjects, sName, builder.toString(), accel + 1);
    }

    protected void onSelectionChanged(IAction action, ISelection selection) {
        this.fProjects.clear();
        boolean badObject = false;
        if (selection != null) {
            IWorkbenchPart part;
            IWorkbenchPage page;
            IWorkbenchWindow window;
            if (selection instanceof IStructuredSelection) {
                Iterator iter = ((IStructuredSelection)selection).iterator();
                while (iter.hasNext()) {
                    ICProject fCProject;
                    IncludeRefContainer irc;
                    Object selItem = iter.next();
                    IProject project = null;
                    if (selItem instanceof ICElement) {
                        ICProject cproject = ((ICElement)selItem).getCProject();
                        if (cproject != null) {
                            project = cproject.getProject();
                        }
                    } else if (selItem instanceof IResource) {
                        project = ((IResource)selItem).getProject();
                    } else if (selItem instanceof IncludeRefContainer) {
                        ICProject fCProject2 = ((IncludeRefContainer)((Object)selItem)).getCProject();
                        if (fCProject2 != null) {
                            project = fCProject2.getProject();
                        }
                    } else if (selItem instanceof IncludeReferenceProxy && (irc = ((IncludeReferenceProxy)((Object)selItem)).getIncludeRefContainer()) != null && (fCProject = irc.getCProject()) != null) {
                        project = fCProject.getProject();
                    }
                    if (project != null) {
                        if (!CoreModel.getDefault().isNewStyleProject(project)) {
                            project = null;
                        } else {
                            ICConfigurationDescription[] tmp = this.getCfgs(project);
                            if (tmp == null || tmp.length == 0) {
                                project = null;
                            }
                        }
                    }
                    if (project != null) {
                        this.fProjects.add(project);
                        continue;
                    }
                    badObject = true;
                    break;
                }
            } else if (selection instanceof ITextSelection && (window = CUIPlugin.getActiveWorkbenchWindow()) != null && window != null && (page = window.getActivePage()) != null && (part = page.getActivePart()) instanceof IEditorPart) {
                IResource resource;
                IEditorPart epart = (IEditorPart)part;
                IEditorInput iEditorInput = epart.getEditorInput();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((resource = (IResource)iEditorInput.getAdapter((Class)clazz)) != null) {
                    IProject project = resource.getProject();
                    boolean bl = badObject = project == null || !CoreModel.getDefault().isNewStyleProject(project);
                    if (!badObject) {
                        this.fProjects.add(project);
                    }
                }
            }
        }
        boolean enable = false;
        if (!badObject && !this.fProjects.isEmpty()) {
            Iterator iter = this.fProjects.iterator();
            ICConfigurationDescription[] firstConfigs = this.getCfgs((IProject)iter.next());
            int i = 0;
            while (i < firstConfigs.length) {
                boolean common = true;
                Iterator iter2 = this.fProjects.iterator();
                while (iter2.hasNext()) {
                    ICConfigurationDescription[] currentConfigs = this.getCfgs((IProject)iter2.next());
                    int j = 0;
                    while (j < currentConfigs.length) {
                        if (firstConfigs[i].getName().equals(currentConfigs[j].getName())) break;
                        ++j;
                    }
                    if (j != currentConfigs.length) continue;
                    common = false;
                    break;
                }
                if (common) {
                    enable = true;
                    break;
                }
                ++i;
            }
        }
        action.setEnabled(enable);
    }

    private ICConfigurationDescription[] getCfgs(IProject prj) {
        ICProjectDescription prjd = CoreModel.getDefault().getProjectDescription(prj, false);
        if (prjd == null) {
            return null;
        }
        ICConfigurationDescription[] tmp = prjd.getConfigurations();
        if (tmp == null) {
            return null;
        }
        return prjd.getConfigurations();
    }
}

