/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.newui;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICFolderDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.newui.CDTListComparator;
import org.eclipse.cdt.ui.newui.CDTPrefUtil;
import org.eclipse.cdt.ui.newui.CDTPropertyManager;
import org.eclipse.cdt.ui.newui.ConfigMultiSelectionDialog;
import org.eclipse.cdt.ui.newui.ICPropertyProvider;
import org.eclipse.cdt.ui.newui.ICPropertyTab;
import org.eclipse.cdt.ui.newui.IConfigManager;
import org.eclipse.cdt.ui.newui.ManageConfigSelector;
import org.eclipse.cdt.ui.newui.UIMessages;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.dialogs.PropertyPage;

public abstract class AbstractPage
extends PropertyPage
implements IWorkbenchPropertyPage,
IPreferencePageContainer,
ICPropertyProvider {
    private static ICResourceDescription resd = null;
    private static ICConfigurationDescription[] cfgDescs = null;
    private static ICConfigurationDescription[] multiCfgs = null;
    private static int cfgIndex = -1;
    private static final String EXTENSION_POINT_ID = "org.eclipse.cdt.ui.cPropertyTab";
    public static final String ELEMENT_NAME = "tab";
    public static final String CLASS_NAME = "class";
    public static final String PARENT_NAME = "parent";
    public static final String IMAGE_NAME = "icon";
    public static final String TIP_NAME = "tooltip";
    public static final String TEXT_NAME = "name";
    public static final String WEIGHT_NAME = "weight";
    private static final Object NOT_NULL = new Object();
    public static final String EMPTY_STR = "";
    private static final int SAVE_MODE_OK = 1;
    private static final int SAVE_MODE_APPLY = 2;
    private static final int SAVE_MODE_APPLYOK = 3;
    private Combo configSelector;
    private Button manageButton;
    private Button excludeFromBuildCheck;
    protected boolean noContentOnPage = false;
    protected boolean displayedConfig = false;
    protected IResource internalElement = null;
    protected boolean isProject = false;
    protected boolean isFolder = false;
    protected boolean isFile = false;
    protected boolean isMulti = false;
    protected TabFolder folder;
    protected ArrayList itabs = new ArrayList();
    protected ICPropertyTab currentTab;
    private boolean isNewOpening = true;

    public AbstractPage() {
        if (CDTPropertyManager.getPagesCount() == 0) {
            cfgDescs = null;
            cfgIndex = -1;
        }
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = 1;
        compositeLayout.marginHeight = 0;
        compositeLayout.marginWidth = 0;
        composite.setLayout((Layout)compositeLayout);
        String s = null;
        if (!this.checkElement()) {
            s = UIMessages.getString("AbstractPage.0");
        } else {
            if (!this.isApplicable()) {
                return null;
            }
            if (!this.isCDTProject(this.getProject())) {
                s = UIMessages.getString("AbstractPage.2");
            }
        }
        if (s == null) {
            this.contentForCDT(composite);
            return composite;
        }
        Label label = new Label(composite, 16384);
        label.setText(s);
        label.setFont(composite.getFont());
        this.noContentOnPage = true;
        this.noDefaultAndApplyButton();
        return composite;
    }

    protected void contentForCDT(Composite composite) {
        Group configGroup = ControlFactory.createGroup(composite, EMPTY_STR, 1);
        GridData gd = new GridData(256);
        gd.grabExcessHorizontalSpace = true;
        configGroup.setLayoutData((Object)gd);
        GridLayout ff = new GridLayout(3, false);
        configGroup.setLayout((Layout)ff);
        Label configLabel = new Label((Composite)configGroup, 0);
        configLabel.setText(UIMessages.getString("AbstractPage.6"));
        configLabel.setLayoutData((Object)new GridData(1));
        this.configSelector = new Combo((Composite)configGroup, 12);
        this.configSelector.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                AbstractPage.this.handleConfigSelection();
            }
        });
        gd = new GridData(4);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.configSelector.setLayoutData((Object)gd);
        if (!CDTPrefUtil.getBool("properties.manage.config.disable")) {
            this.manageButton = new Button((Composite)configGroup, 8);
            this.manageButton.setText(UIMessages.getString("AbstractPage.12"));
            gd = new GridData(3);
            gd.minimumWidth = 150;
            this.manageButton.setLayoutData((Object)gd);
            this.manageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IProject[] obs = new IProject[]{AbstractPage.this.getProject()};
                    IConfigManager cm = ManageConfigSelector.getManager(obs);
                    if (cm != null && cm.manage(obs, false)) {
                        cfgDescs = null;
                        AbstractPage.this.populateConfigurations();
                    }
                }
            });
        } else {
            new Label((Composite)configGroup, 0).setLayoutData((Object)new GridData(3));
        }
        if (this.isForFolder() || this.isForFile()) {
            this.excludeFromBuildCheck = new Button((Composite)configGroup, 32);
            this.excludeFromBuildCheck.setText(UIMessages.getString("AbstractPage.7"));
            gd = new GridData(768);
            gd.horizontalSpan = 3;
            this.excludeFromBuildCheck.setLayoutData((Object)gd);
            this.excludeFromBuildCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractPage.this.getResDesc().setExcluded(AbstractPage.this.excludeFromBuildCheck.getSelection());
                }
            });
        }
        this.populateConfigurations();
        if (this.excludeFromBuildCheck != null) {
            this.excludeFromBuildCheck.setSelection(this.getResDesc().isExcluded());
        }
        this.createWidgets(composite);
    }

    public void createWidgets(Composite c) {
        Composite comp = new Composite(c, 0);
        comp.setLayoutData((Object)new GridData(1808));
        this.itabs.clear();
        if (!this.isSingle()) {
            comp.setLayout((Layout)new FillLayout());
            this.folder = new TabFolder(comp, 0);
        }
        this.loadExtensionsSynchronized(comp);
        if (this.folder != null) {
            this.folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ICPropertyTab newTab;
                    if (AbstractPage.this.folder.getSelection().length > 0 && (newTab = (ICPropertyTab)AbstractPage.this.folder.getSelection()[0].getData()) != null && AbstractPage.this.currentTab != newTab) {
                        if (AbstractPage.this.currentTab != null) {
                            AbstractPage.this.currentTab.handleTabEvent(5, null);
                        }
                        AbstractPage.this.currentTab = newTab;
                        AbstractPage.this.currentTab.handleTabEvent(5, NOT_NULL);
                    }
                }
            });
            if (this.folder.getItemCount() > 0) {
                this.folder.setSelection(0);
            }
        }
    }

    public IProject getProject() {
        IAdaptable element = this.getElement();
        if (element != null) {
            if (element instanceof IFile || element instanceof IProject || element instanceof IFolder) {
                IResource f = (IResource)element;
                return f.getProject();
            }
            if (element instanceof ICProject) {
                return ((ICProject)element).getProject();
            }
        }
        return null;
    }

    private void handleConfigSelection() {
        this.isMulti = false;
        if (this.configSelector.getItemCount() == 0) {
            return;
        }
        int selectionIndex = this.configSelector.getSelectionIndex();
        if (selectionIndex == -1) {
            return;
        }
        if (selectionIndex >= cfgDescs.length) {
            if (selectionIndex - cfgDescs.length == 0) {
                multiCfgs = cfgDescs;
            } else {
                ICConfigurationDescription[] mcfgs = ConfigMultiSelectionDialog.select(cfgDescs);
                if (mcfgs == null || mcfgs.length == 0) {
                    if (cfgIndex >= cfgDescs.length) {
                        cfgIndex = 0;
                        this.configSelector.select(0);
                        this.cfgChanged(cfgDescs[0]);
                    } else {
                        this.configSelector.select(cfgIndex);
                    }
                    return;
                }
                multiCfgs = mcfgs;
            }
            this.isMulti = true;
            this.cfgChanged(multiCfgs[0]);
            return;
        }
        String id1 = this.getResDesc() == null ? null : this.getResDesc().getId();
        cfgIndex = selectionIndex;
        ICConfigurationDescription newConfig = cfgDescs[selectionIndex];
        String id2 = newConfig.getId();
        if (id2 != null && !id2.equals(id1)) {
            this.cfgChanged(newConfig);
        }
    }

    public boolean performCancel() {
        if (!this.noContentOnPage && this.displayedConfig) {
            this.forEach(2);
        }
        CDTPropertyManager.performCancel(this);
        return true;
    }

    public void performDefaults() {
        if (!this.noContentOnPage && this.displayedConfig) {
            this.forEach(3);
        }
    }

    public void performApply() {
        this.performSave(2);
    }

    public boolean performOk() {
        File f = CUIPlugin.getDefault().getStateLocation().append("apply_mode").toFile();
        if (f.exists()) {
            return this.performSave(3);
        }
        return this.performSave(1);
    }

    private boolean performSave(int mode) {
        final int finalMode = mode;
        if (this.noContentOnPage || !this.displayedConfig) {
            return true;
        }
        if ((mode == 1 || mode == 3) && CDTPropertyManager.isSaveDone()) {
            return true;
        }
        final boolean needs = mode != 1;
        final ICProjectDescription local_prjd = needs ? CoreModel.getDefault().getProjectDescription(this.getProject()) : null;
        ICConfigurationDescription c = needs ? local_prjd.getConfigurationById(resd.getConfiguration().getId()) : null;
        final ICResourceDescription local_cfgd = needs ? this.getResDesc(c) : null;
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            private void sendOK() {
                int j = 0;
                while (j < CDTPropertyManager.getPagesCount()) {
                    Object p = CDTPropertyManager.getPage(j);
                    if (p != null && p instanceof AbstractPage) {
                        AbstractPage ap = (AbstractPage)p;
                        if (ap.displayedConfig) {
                            ap.forEach(0, null);
                        }
                    }
                    ++j;
                }
            }

            public void run(IProgressMonitor monitor) {
                switch (finalMode) {
                    case 3: {
                        this.sendOK();
                        ICConfigurationDescription[] olds = CDTPropertyManager.getProjectDescription(AbstractPage.this, AbstractPage.this.getProject()).getConfigurations();
                        int i = 0;
                        while (i < olds.length) {
                            resd = AbstractPage.this.getResDesc(olds[i]);
                            ICResourceDescription r = AbstractPage.this.getResDesc(local_prjd.getConfigurationById(olds[i].getId()));
                            int j = 0;
                            while (j < CDTPropertyManager.getPagesCount()) {
                                Object p = CDTPropertyManager.getPage(j);
                                if (p != null && p instanceof AbstractPage) {
                                    AbstractPage ap = (AbstractPage)p;
                                    if (ap.displayedConfig) {
                                        ap.forEach(4, resd);
                                        ap.forEach(1, r);
                                    }
                                }
                                ++j;
                            }
                            ++i;
                        }
                        break;
                    }
                    case 2: {
                        AbstractPage.this.forEach(1, local_cfgd);
                        break;
                    }
                    case 1: {
                        this.sendOK();
                    }
                }
                try {
                    if (needs) {
                        CoreModel.getDefault().setProjectDescription(AbstractPage.this.getProject(), local_prjd);
                    } else {
                        CDTPropertyManager.performOk(AbstractPage.this);
                    }
                }
                catch (CoreException e) {
                    CUIPlugin.getDefault().logErrorMessage(String.valueOf(UIMessages.getString("AbstractPage.11")) + e.getLocalizedMessage());
                }
                AbstractPage.updateViews(AbstractPage.this.internalElement);
            }
        };
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(runnable);
        try {
            new ProgressMonitorDialog(this.getShell()).run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            Throwable e1 = e.getTargetException();
            CUIPlugin.errorDialog(this.getShell(), UIMessages.getString("AbstractPage.8"), UIMessages.getString("AbstractPage.9"), e1, true);
            return false;
        }
        catch (InterruptedException interruptedException) {}
        return true;
    }

    private void populateConfigurations() {
        if (this.configSelector == null) {
            return;
        }
        if (cfgDescs == null) {
            cfgDescs = CDTPropertyManager.getProjectDescription(this, this.getProject()).getConfigurations();
            if (cfgDescs == null || cfgDescs.length == 0) {
                return;
            }
            Arrays.sort(cfgDescs, CDTListComparator.getInstance());
        } else {
            CDTPropertyManager.getProjectDescription(this, this.getProject());
        }
        this.configSelector.removeAll();
        int i = 0;
        while (i < cfgDescs.length) {
            this.configSelector.add(cfgDescs[i].getName());
            if (cfgIndex == -1 && cfgDescs[i].isActive()) {
                cfgIndex = i;
            }
            ++i;
        }
        if (CDTPrefUtil.getBool("properties.multi.config.enable")) {
            if (cfgDescs.length > 1) {
                this.configSelector.add(UIMessages.getString("AbstractPage.4"));
            }
            if (cfgDescs.length > 2) {
                this.configSelector.add(UIMessages.getString("AbstractPage.5"));
            }
        }
        this.configSelector.select(cfgIndex);
        this.handleConfigSelection();
    }

    public void updateButtons() {
    }

    public void updateMessage() {
    }

    public void updateTitle() {
    }

    public void updateContainer() {
    }

    public boolean isValid() {
        this.updateContainer();
        return super.isValid();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.handleResize(true);
            this.displayedConfig = true;
            if (this.excludeFromBuildCheck != null && resd != null) {
                this.excludeFromBuildCheck.setSelection(resd.isExcluded());
            }
            if (this.configSelector != null) {
                this.configSelector.select(cfgIndex == -1 ? 0 : cfgIndex);
                this.handleConfigSelection();
            }
        }
        if (this.itabs.size() < 1) {
            return;
        }
        if (this.currentTab == null && this.folder.getItemCount() > 0) {
            Object ob = this.folder.getItem(0).getData();
            this.currentTab = (ICPropertyTab)ob;
        }
        if (this.currentTab != null) {
            this.currentTab.handleTabEvent(5, visible ? NOT_NULL : null);
        }
    }

    protected void handleResize(boolean visible) {
        int saveMode;
        if (visible && !this.isNewOpening) {
            return;
        }
        if (visible) {
            this.isNewOpening = false;
        }
        if ((saveMode = CDTPrefUtil.getInt("properties.save.position")) == 2) {
            return;
        }
        if (this.internalElement == null && !this.checkElement()) {
            return;
        }
        IProject prj = this.getProject();
        if (prj == null) {
            return;
        }
        QualifiedName WIDTH = new QualifiedName(prj.getName(), ".property.page.width");
        QualifiedName HEIGHT = new QualifiedName(prj.getName(), ".property.page.height");
        QualifiedName XKEY = new QualifiedName(prj.getName(), ".property.page.x");
        QualifiedName YKEY = new QualifiedName(prj.getName(), ".property.page.y");
        Rectangle r = this.getShell().getBounds();
        try {
            if (visible) {
                String w = prj.getPersistentProperty(WIDTH);
                String h = prj.getPersistentProperty(HEIGHT);
                if (w != null) {
                    r.width = Integer.parseInt(w);
                }
                if (h != null) {
                    r.height = Integer.parseInt(h);
                }
                if (saveMode == 3) {
                    String x = prj.getPersistentProperty(XKEY);
                    String y = prj.getPersistentProperty(YKEY);
                    if (x != null) {
                        r.x = Integer.parseInt(x);
                    }
                    if (y != null) {
                        r.y = Integer.parseInt(y);
                    }
                }
                this.getShell().setBounds(r);
            } else {
                prj.setPersistentProperty(WIDTH, String.valueOf(r.width));
                prj.setPersistentProperty(HEIGHT, String.valueOf(r.height));
                prj.setPersistentProperty(XKEY, String.valueOf(r.x));
                prj.setPersistentProperty(YKEY, String.valueOf(r.y));
            }
        }
        catch (CoreException coreException) {}
    }

    public IPreferenceStore getPreferenceStore() {
        return CUIPlugin.getDefault().getPreferenceStore();
    }

    public Preferences getPreferences() {
        return CUIPlugin.getDefault().getPluginPreferences();
    }

    public void enableConfigSelection(boolean enable) {
        if (this.configSelector != null) {
            this.configSelector.setEnabled(enable);
        }
        if (this.manageButton != null) {
            this.manageButton.setEnabled(enable);
        }
    }

    public ICConfigurationDescription[] getCfgsReadOnly(IProject p) {
        ICProjectDescription prjd = CoreModel.getDefault().getProjectDescription(p, false);
        if (prjd != null) {
            return prjd.getConfigurations();
        }
        return null;
    }

    public ICConfigurationDescription[] getCfgsEditable() {
        return cfgDescs;
    }

    public static boolean isCDTPrj(IProject p) {
        ICProjectDescription prjd = CoreModel.getDefault().getProjectDescription(p, false);
        if (prjd == null) {
            return false;
        }
        ICConfigurationDescription[] cfgs = prjd.getConfigurations();
        return cfgs != null && cfgs.length > 0;
    }

    public boolean isCDTProject(IProject p) {
        return AbstractPage.isCDTPrj(p);
    }

    public ICResourceDescription getResDesc() {
        if (resd == null) {
            if (cfgDescs == null) {
                this.populateConfigurations();
                if (cfgDescs == null || cfgDescs.length == 0) {
                    return null;
                }
            }
            resd = this.getResDesc(cfgDescs[cfgIndex]);
        }
        return resd;
    }

    public ICResourceDescription getResDesc(ICConfigurationDescription cf) {
        IAdaptable ad = this.getElement();
        if (this.isForProject()) {
            return cf.getRootFolderDescription();
        }
        Object out = null;
        IResource res = (IResource)ad;
        IPath p = res.getProjectRelativePath();
        if ((this.isForFolder() || this.isForFile()) && !p.equals((Object)(out = cf.getResourceDescription(p, false)).getPath())) {
            try {
                out = this.isForFolder() ? cf.createFolderDescription(p, (ICFolderDescription)out) : cf.createFileDescription(p, out);
            }
            catch (CoreException e) {
                System.out.println(String.valueOf(UIMessages.getString("AbstractPage.10")) + p.toOSString() + "\n" + e.getLocalizedMessage());
            }
        }
        return out;
    }

    protected void cfgChanged(ICConfigurationDescription _cfgd) {
        resd = this.getResDesc(_cfgd);
        if (this.excludeFromBuildCheck != null) {
            this.excludeFromBuildCheck.setEnabled(resd.canExclude(!resd.isExcluded()));
            this.excludeFromBuildCheck.setSelection(resd.isExcluded());
        }
        int x = CDTPropertyManager.getPagesCount();
        int i = 0;
        while (i < x) {
            Object p = CDTPropertyManager.getPage(i);
            if (p != null && p instanceof AbstractPage) {
                AbstractPage ap = (AbstractPage)p;
                if (ap.displayedConfig) {
                    ap.forEach(4, this.getResDesc());
                }
            }
            ++i;
        }
    }

    public void dispose() {
        if (this.displayedConfig) {
            this.forEach(6);
        }
        if (!this.isNewOpening) {
            this.handleResize(false);
        }
        this.isNewOpening = true;
        if (CDTPropertyManager.getPagesCount() == 0) {
            resd = null;
            cfgDescs = null;
            multiCfgs = null;
        }
    }

    protected abstract boolean isSingle();

    protected void forEach(int m) {
        this.forEach(m, null);
    }

    protected void forEach(int m, Object pars) {
        Iterator it = this.itabs.iterator();
        while (it.hasNext()) {
            InternalTab tab = (InternalTab)it.next();
            if (tab == null) continue;
            tab.tab.handleTabEvent(m, pars);
        }
    }

    public static String getWeight(IConfigurationElement e) {
        String s = e.getAttribute(WEIGHT_NAME);
        return s == null ? EMPTY_STR : s;
    }

    private synchronized void loadExtensionsSynchronized(Composite parent) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_ID);
        if (extensionPoint == null) {
            return;
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        if (extensions == null) {
            return;
        }
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            Arrays.sort(elements, CDTListComparator.getInstance());
            int k = 0;
            while (k < elements.length) {
                if (elements[k].getName().equals(ELEMENT_NAME)) {
                    if (this.loadTab(elements[k], parent)) {
                        return;
                    }
                } else {
                    System.out.println(String.valueOf(UIMessages.getString("AbstractPage.13")) + elements[k].getName());
                }
                ++k;
            }
            ++i;
        }
    }

    private boolean loadTab(IConfigurationElement element, Composite parent) {
        if (!this.getClass().getName().equals(element.getAttribute(PARENT_NAME))) {
            return false;
        }
        ICPropertyTab page = null;
        try {
            page = (ICPropertyTab)element.createExecutableExtension(CLASS_NAME);
        }
        catch (CoreException e) {
            System.out.println(String.valueOf(UIMessages.getString("AbstractPage.14")) + e.getLocalizedMessage());
            return false;
        }
        if (page == null) {
            return false;
        }
        Image _img = this.getIcon(element);
        if (_img != null) {
            page.handleTabEvent(7, _img);
        }
        if (this.isSingle()) {
            page.createControls(parent, this);
            InternalTab itab = new InternalTab(parent, EMPTY_STR, null, page, null);
            this.itabs.add(itab);
            this.currentTab = page;
            return true;
        }
        String _name = element.getAttribute(TEXT_NAME);
        String _tip = element.getAttribute(TIP_NAME);
        Composite _comp = new Composite((Composite)this.folder, 0);
        page.createControls(_comp, this);
        InternalTab itab = new InternalTab(_comp, _name, _img, page, _tip);
        itab.createOn(this.folder);
        this.itabs.add(itab);
        return false;
    }

    private Image getIcon(IConfigurationElement config) {
        ImageDescriptor idesc = null;
        try {
            String iconName = config.getAttribute(IMAGE_NAME);
            if (iconName != null) {
                URL pluginInstallUrl = Platform.getBundle((String)config.getDeclaringExtension().getContributor().getName()).getEntry("/");
                idesc = ImageDescriptor.createFromURL((URL)new URL(pluginInstallUrl, iconName));
            }
        }
        catch (MalformedURLException malformedURLException) {}
        return idesc == null ? null : idesc.createImage();
    }

    public void informAll(int code, Object data) {
        int i = 0;
        while (i < CDTPropertyManager.getPagesCount()) {
            Object p = CDTPropertyManager.getPage(i);
            if (p != null && p instanceof AbstractPage) {
                AbstractPage ap = (AbstractPage)p;
                ap.forEach(code, data);
            }
            ++i;
        }
    }

    public void informPages(int code, Object data) {
        int i = 0;
        while (i < CDTPropertyManager.getPagesCount()) {
            Object p = CDTPropertyManager.getPage(i);
            if (p != null && p instanceof AbstractPage) {
                AbstractPage ap = (AbstractPage)p;
                ap.handleMessage(code, data);
            }
            ++i;
        }
    }

    public void handleMessage(int code, Object data) {
        switch (code) {
            case 101: {
                if (this.folder == null) {
                    if (this.itabs == null || this.itabs.size() == 0) {
                        return;
                    }
                    ICPropertyTab t = ((InternalTab)this.itabs.get((int)0)).tab;
                    if (!t.canBeVisible()) {
                        t.handleTabEvent(5, null);
                    }
                }
                boolean willAdd = false;
                TabItem[] ts = this.folder.getItems();
                int x = this.folder.getSelectionIndex();
                String currHeader = x == -1 ? null : ts[x].getText();
                int i = 0;
                while (i < this.itabs.size()) {
                    InternalTab itab = (InternalTab)this.itabs.get(i);
                    TabItem ti = null;
                    int j = 0;
                    while (j < ts.length) {
                        if (!ts[j].isDisposed() && ts[j].getData() == itab.tab) {
                            ti = ts[j];
                            break;
                        }
                        ++j;
                    }
                    if (itab.tab.canBeVisible()) {
                        if (ti == null) {
                            willAdd = true;
                            break;
                        }
                    } else if (ti != null) {
                        ti.dispose();
                    }
                    ++i;
                }
                if (!willAdd) break;
                int j = 0;
                while (j < ts.length) {
                    if (ts[j] != null && !ts[j].isDisposed()) {
                        ts[j].dispose();
                    }
                    ++j;
                }
                TabItem ti = null;
                int i2 = 0;
                while (i2 < this.itabs.size()) {
                    InternalTab itab = (InternalTab)this.itabs.get(i2);
                    if (itab.tab.canBeVisible()) {
                        TabItem currTI = itab.createOn(this.folder);
                        if (currHeader != null && currHeader.equals(itab.text)) {
                            ti = currTI;
                        }
                    }
                    ++i2;
                }
                if (ti == null) break;
                this.folder.setSelection(ti);
            }
        }
    }

    protected boolean checkElement() {
        IAdaptable el = super.getElement();
        if (el instanceof ICElement) {
            this.internalElement = ((ICElement)el).getResource();
        } else if (el instanceof IResource) {
            this.internalElement = (IResource)el;
        }
        if (this.internalElement == null) {
            return false;
        }
        this.isProject = this.internalElement instanceof IProject;
        this.isFolder = this.internalElement instanceof IFolder;
        this.isFile = this.internalElement instanceof IFile;
        return true;
    }

    public IAdaptable getElement() {
        if (this.internalElement == null && !this.checkElement()) {
            throw new NullPointerException(UIMessages.getString("AbstractPage.15"));
        }
        return this.internalElement;
    }

    public boolean isForProject() {
        return this.isProject;
    }

    public boolean isForFolder() {
        return this.isFolder;
    }

    public boolean isForFile() {
        return this.isFile;
    }

    public boolean isForPrefs() {
        return false;
    }

    public boolean isMultiCfg() {
        return this.isMulti;
    }

    public ICConfigurationDescription[] getMultiCfg() {
        return this.isMulti ? multiCfgs : null;
    }

    public boolean isApplicable() {
        if (this.internalElement == null && !this.checkElement()) {
            return false;
        }
        if (this.isForFile()) {
            return true;
        }
        return true;
    }

    public static void updateViews(IResource res) {
        if (res == null) {
            return;
        }
        IViewReference[] refs = CUIPlugin.getActiveWorkbenchWindow().getActivePage().getViewReferences();
        int k = 0;
        while (k < refs.length) {
            IWorkbenchPart part = refs[k].getPart(false);
            if (part != null && part instanceof IPropertyChangeListener) {
                ((IPropertyChangeListener)part).propertyChange(new PropertyChangeEvent((Object)res, "org.eclipse.cdt.ui.editor.CUChildren", null, null));
            }
            ++k;
        }
    }

    protected class InternalTab {
        Composite comp;
        String text;
        String tip;
        Image image;
        ICPropertyTab tab;

        InternalTab(Composite _comp, String _text, Image _image, ICPropertyTab _tab, String _tip) {
            this.comp = _comp;
            this.text = _text;
            this.image = _image;
            this.tab = _tab;
            this.tip = _tip;
        }

        public TabItem createOn(TabFolder f) {
            if (this.tab.canBeVisible()) {
                TabItem ti = new TabItem(f, 0);
                ti.setText(this.text);
                if (this.tip != null) {
                    ti.setToolTipText(this.tip);
                }
                if (this.image != null) {
                    ti.setImage(this.image);
                }
                ti.setControl((Control)this.comp);
                ti.setData((Object)this.tab);
                return ti;
            }
            return null;
        }
    }
}

