/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.newui;

import java.util.Arrays;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.newui.CDTListComparator;
import org.eclipse.cdt.ui.newui.CDTPropertyManager;
import org.eclipse.cdt.ui.newui.INewCfgDialog;
import org.eclipse.cdt.ui.newui.NewConfigurationDialog;
import org.eclipse.cdt.ui.newui.RenameConfigurationDialog;
import org.eclipse.cdt.ui.newui.UIMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class ManageConfigDialog
extends Dialog {
    private static final String EXTENSION_POINT_ID = "org.eclipse.cdt.ui.newCfgDialog";
    public static final String ELEMENT_NAME = "dialog";
    public static final String CLASS_NAME = "class";
    public static final String TITLE_NAME = "title";
    public static final String ID_NAME = "mbs_id";
    private static final String CMN_PREFIX = "BuildPropertyCommon";
    private static final String CMN_LABEL = "BuildPropertyCommon.label";
    private static final String NEW = "BuildPropertyCommon.label.new";
    private static final String REMOVE = "BuildPropertyCommon.label.remove";
    private static final String PREFIX = "ManageConfig";
    private static final String LABEL = "ManageConfig.label";
    private static final String RENAME = "ManageConfig.label.rename";
    private static final String NEW_CONF_DLG = "ManageConfig.label.new.config.dialog";
    private static final String RENAME_CONF_DLG = "ManageConfig.label.rename.config.dialog";
    private ICProjectDescription des;
    private IProject prj;
    private String title;
    private String mbs_id;
    protected Table table;
    protected Button actBtn;
    protected Button newBtn;
    protected Button renBtn;
    protected Button delBtn;

    ManageConfigDialog(Shell parentShell, String _title, IProject _prj) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.title = _title;
        this.prj = _prj;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout(4, true));
        composite.setLayoutData((Object)new GridData(768));
        this.table = new Table(composite, 68356);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 4;
        this.table.setLayoutData((Object)gd);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableColumn col = new TableColumn(this.table, 0);
        col.setText(UIMessages.getString("ManageConfigDialog.1"));
        col.setWidth(100);
        col = new TableColumn(this.table, 0);
        col.setText(UIMessages.getString("ManageConfigDialog.2"));
        col.setWidth(120);
        col = new TableColumn(this.table, 0);
        col.setText(UIMessages.getString("ManageConfigDialog.3"));
        col.setWidth(80);
        this.actBtn = new Button(composite, 8);
        this.actBtn.setText(UIMessages.getString("ManageConfigDialog.4"));
        this.actBtn.setLayoutData((Object)new GridData(768));
        this.actBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] tis = ManageConfigDialog.this.table.getSelection();
                if (tis == null || tis.length != 1) {
                    return;
                }
                ICConfigurationDescription cfgd = (ICConfigurationDescription)tis[0].getData();
                ManageConfigDialog.this.des.setActiveConfiguration(cfgd);
                ManageConfigDialog.this.updateData();
            }
        });
        this.newBtn = new Button(composite, 8);
        this.newBtn.setText(UIMessages.getString(NEW));
        this.newBtn.setLayoutData((Object)new GridData(768));
        this.newBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageConfigDialog.this.handleNewPressed();
            }
        });
        this.delBtn = new Button(composite, 8);
        this.delBtn.setText(UIMessages.getString(REMOVE));
        this.delBtn.setLayoutData((Object)new GridData(768));
        this.delBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageConfigDialog.this.handleRemovePressed();
            }
        });
        this.renBtn = new Button(composite, 8);
        this.renBtn.setText(UIMessages.getString(RENAME));
        this.renBtn.setLayoutData((Object)new GridData(768));
        this.renBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageConfigDialog.this.handleRenamePressed();
            }
        });
        this.des = CDTPropertyManager.getProjectDescription((Widget)composite, this.prj);
        this.updateData();
        return composite;
    }

    protected void handleNewPressed() {
        INewCfgDialog dialog = this.handleSpecificMBS(this.mbs_id);
        if (dialog == null) {
            dialog = new NewConfigurationDialog(this.getShell());
            dialog.setTitle(UIMessages.getString(NEW_CONF_DLG));
        }
        dialog.setProject(this.des);
        if (dialog.open() == 0) {
            this.updateData();
        }
    }

    protected INewCfgDialog handleSpecificMBS(String id) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_ID);
        if (extensionPoint == null) {
            return null;
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        if (extensions == null) {
            return null;
        }
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int k = 0;
            while (k < elements.length) {
                if (elements[k].getName().equals(ELEMENT_NAME) && id.equals(elements[k].getAttribute(ID_NAME))) {
                    INewCfgDialog dialog = null;
                    try {
                        dialog = (INewCfgDialog)elements[k].createExecutableExtension(CLASS_NAME);
                        dialog.setTitle(elements[k].getAttribute(TITLE_NAME));
                        dialog.setShell(this.getShell());
                        return dialog;
                    }
                    catch (CoreException e) {
                        System.out.println("Cannot create dialog: " + e.getLocalizedMessage());
                        return null;
                    }
                }
                ++k;
            }
            ++i;
        }
        return null;
    }

    protected void handleRenamePressed() {
        int sel = this.table.getSelectionIndex();
        if (sel != -1) {
            ICConfigurationDescription cfgd = (ICConfigurationDescription)this.table.getItem(sel).getData();
            RenameConfigurationDialog dialog = new RenameConfigurationDialog(this.getShell(), cfgd, this.des.getConfigurations(), UIMessages.getString(RENAME_CONF_DLG));
            if (dialog.open() == 0) {
                cfgd.setName(dialog.getNewName());
                cfgd.setDescription(dialog.getNewDescription());
                this.updateData();
            }
        }
    }

    protected void handleRemovePressed() {
        TableItem[] tis = this.table.getSelection();
        if (tis == null || tis.length < 1) {
            return;
        }
        String[] names = new String[tis.length];
        int i = 0;
        while (i < tis.length) {
            names[i] = tis[i].getText(0);
            ++i;
        }
        Shell shell = CUIPlugin.getActiveWorkbenchShell();
        boolean shouldDelete = MessageDialog.openQuestion((Shell)shell, (String)UIMessages.getString("ManageConfig.deletedialog.title"), (String)UIMessages.getFormattedString("ManageConfig.deletedialog.message", names));
        if (shouldDelete) {
            boolean wasActive = false;
            int j = 0;
            while (j < tis.length) {
                ICConfigurationDescription cfgd = (ICConfigurationDescription)tis[j].getData();
                if (cfgd.isActive()) {
                    wasActive = true;
                }
                this.des.removeConfiguration(cfgd);
                ++j;
            }
            ICConfigurationDescription[] cfgds = this.des.getConfigurations();
            if (wasActive && cfgds.length > 0) {
                cfgds[0].setActive();
                this.des.setActiveConfiguration(cfgds[0]);
            }
            this.updateData();
        }
    }

    private void updateButtons() {
        int sel = this.table.getSelectionCount();
        this.delBtn.setEnabled(sel > 0 & sel < this.table.getItemCount());
        this.renBtn.setEnabled(sel == 1);
        this.actBtn.setEnabled(sel == 1);
    }

    private void updateData() {
        this.table.removeAll();
        ICConfigurationDescription[] cfgds = this.des.getConfigurations();
        this.mbs_id = cfgds[0].getBuildSystemId();
        Arrays.sort(cfgds, CDTListComparator.getInstance());
        int i = 0;
        while (i < cfgds.length) {
            TableItem t = new TableItem(this.table, 0);
            t.setText(0, cfgds[i].getName());
            t.setText(1, cfgds[i].getDescription());
            t.setText(2, cfgds[i].isActive() ? UIMessages.getString("ManageConfigDialog.5") : "");
            t.setData((Object)cfgds[i]);
            ++i;
        }
        if (this.table.getItemCount() > 0) {
            this.table.select(0);
        }
        this.table.setFocus();
        this.updateButtons();
    }

    ICProjectDescription getProjectDescription() {
        return this.des;
    }
}

